#!/usr/bin/python

import re, sys, os

release_regex = re.compile(r'^\S+ \(([\d.]+)[0-9.-]*\).*')
closes_regex = re.compile(r'^\s*(?:\*\s*)Closes: (#\d+(, *#\d+)*)\s*:.*')

def main():
    version = None
    tickets = []

    for line in sys.stdin:
        match = release_regex.match(line)
        if match:
            if version:
                break
            else:
                version = match.group(1)
                continue
        match = closes_regex.match(line)
        if match:
            if not version:
                print "Vor dem ersten 'Closes' brauche ich eine Versionsangabe. Abbruch."
                return 2
            tickets.extend([s.strip(',# ') for s in match.group(1).split(",")])

    url = "%(base)s/%(version)s/%(tickets)s" % {
        #'base': 'http://mir.office.noris.de:8000/releasenotes/close-bugs',
        'base': 'https://service.qsu.office.noris.de/releasenotes/close-bugs',
        'version': version,
        'tickets': ",".join(tickets)
        }
    print url
    os.system('kfmclient openURL %s' % url)
    return 0


sys.exit(main())
