from models import ValidationFailure
from django.core import urlresolvers
from django.http import HttpResponseRedirect

class ValidatorMiddleware(object):
    def process_response(self, request, response):
        if not request.path.startswith(u'/validator'):
            if response.status_code == 200:
                failure = ValidationFailure.do_validation(request, response)
                if failure:
                    return HttpResponseRedirect(urlresolvers.reverse('validator.detail', args=[failure.id]))
        return response
        
