# -*- encoding: utf-8 -*-

from django.conf.urls.defaults import *
from django.conf import settings

handler404 = 'kundebunt.popkern.views.page_not_found'

prefix = (settings.BASE_URL + '/')[1:]    # führendes '/' wegschneiden

urlpatterns = patterns('',
    (r'^%s/?$' % prefix, 'kundebunt.kunde.views.kunden_suche'),
    (r'^%sacct/' % prefix, include('kundebunt.acct.urls')),
    (r'^%smailadmin/' % prefix, include('kundebunt.mailadmin.urls')),   # muss zu settings.MAILADMIN_ROOTURL passen
    (r'^%sauth/' % prefix, include('kundebunt.kunde_auth.urls')),
    (r'^%spopkern/' % prefix, include('kundebunt.popkern.urls')),
    (r'^%sreleasenotes/' % prefix, include('kundebunt.releasenotes.urls')),
    (r'^%shardware/' % prefix, include('kundebunt.hardware.urls')),
    (r'^%shistory/' % prefix, include('kundebunt.history.urls')),
    (r'^%skunde/' % prefix, include('kundebunt.kunde.urls')),
    (r'^%sperson/(?P<person_id_or_username>[1-9]\d*|[a-z][-_.a-z0-9]*)/?$' % prefix, 'kundebunt.kunde.views.person_redirect'),
    (r'^%sperson/$' % prefix, 'kundebunt.kunde.views.create_person'),
    (r'^%sotrs(data)?/' % prefix, include('kundebunt.otrs.urls')),
    (r'^%suser/' % prefix, include('kundebunt.user.urls')),
    (r'^%sdownload(?:/|$)' % prefix, 'kundebunt.kunde_auth.views.check_service_access'),
    (r'^%sstats/server/' % prefix, include('kundebunt.serverstats.urls')),
    (r'^%scollectd/' % prefix, 'kundebunt.serverstats.views.check_graph_access'),
)

if settings.DEBUG:
    urlpatterns += patterns('',
            (r'^kundebunt-static/js/hardware/(?P<path>.*\.js)$', 'django.views.static.serve', {'document_root': '/home/mir/src/kundebunt/kundebunt/hardware/templates'}),
            (r'^kundebunt-static/js/stats/server/(?P<path>.*\.js)$', 'django.views.static.serve', {'document_root': '/home/mir/src/kundebunt/kundebunt/serverstats/templates'}),
            (r'^kundebunt-static/(?P<path>.*)$', 'django.views.static.serve', {'document_root': '/home/mir/src/kundebunt/static'}),
            (r'^admin/', include('django.contrib.admin.urls')),
            (r'^yui-noris/(?P<path>.*)$', 'django.views.static.serve', {'document_root': '/usr/share/yui-noris'}),
            (r'^yui-ext-noris/(?P<path>.*)$', 'django.views.static.serve', {'document_root': '/usr/share/yui-ext-noris'}), # testing only
            (r'^cleverbridge-icons/(?P<path>.*)$', 'django.views.static.serve', {'document_root': '/home/mir/src/cleverbridge-icons/icons'}),
        )

if settings.USE_PERFMON:
    urlpatterns += patterns('',     (r'^perf/', include('itscales.apps.perf.urls')))

if settings.USE_VALIDATOR:
    urlpatterns += patterns('',      (r'^validator/', include('kundebunt.validator.urls')))
