"""Hold the context in the session."""

from django import template
from django.conf import settings
from kundebunt.testutils.context_keeper import set_context
register = template.Library()

class ContextKeeperNode(template.Node):
    def render(self, context):
        if settings.VIEW_TEST:
            set_context(context)
        return ''

@register.tag
def context_keeper(parser, tag):
    return ContextKeeperNode()

