import logging, re
from pprint import pformat
from django.conf import settings
from django.dispatch import dispatcher
from django.test import signals
from django.test.utils import setup_test_environment
from t_repr import t_repr


class TestGhostWriter:
    def __init__(self):
        self.url_filter = re.compile(settings.TEST_URL_FILTER)
        self.logger = logging.getLogger("test.write")
        self.datasource_urls = re.compile(settings.TEST_DATASOURCE_URLS)
        setup_test_environment()
        dispatcher.connect(self.store_rendered_templates, signal=signals.template_rendered)

    def process_request(self, request):
        self.context = None
        return None

    def process_response(self, request, response):
        if self.url_filter.search(request.path):
            self.logger.debug("# --------------------------------------------------------------------")
            self.logger.debug("# %s %s" % (request.META["REQUEST_METHOD"], request.path))
            if request.GET or request.POST:
                self.logger.debug("GET = MultiValueDict(%s)", pformat(dict(request.GET.lists())))
                self.logger.debug("POST = MultiValueDict(%s)", pformat(dict(request.POST.lists())))
                self.logger.debug("response, context = runner.get_response(%r, %r, GET, POST)" %
                                  (request.path, request.META["REQUEST_METHOD"]))
            else:
                self.logger.debug("response, context = runner.get_response(%r, %r, {}, {})" %
                                  (request.path, request.META["REQUEST_METHOD"]))
            self.logger.debug("assert runner.check_response(response, %s)", pformat(t_repr(response)))
            if response.status_code < 300:
                if self.datasource_urls.match(request.path):
                    self.logger.debug("assert runner.check_datasource(response, %s)" % response.content)
                else:
                    self.logger.debug("assert runner.check_context(response, context, %s)", pformat(self.context))
        return response

    def store_rendered_templates(self, signal, sender, template, context):
        "A utility function for storing templates and contexts that are rendered"
        context = t_repr(context)
        context.pop("block", None)
        self.context = context
