"""tests if the tests before haven't created xhtml-invalid documents"""

import datetime
from kundebunt.validator import models
from kundebunt.tests.fixtures import base_setup

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)

def test_xml_valid():
    seen = set()
    failures = models.ValidationFailure.objects.filter(
        timestamp__gt=datetime.datetime.now() + datetime.timedelta(minutes=-5))
    if len(failures) > 0:
        print "%d validation failures:"
        for failure in failures:
            if not failure.path in seen:
                seen.add(failure.path)
                print "%r\n%s" % (failure, failure.errors)
                runner.print_html(failure.get_response())
                print "\n\n----------------------------------\n"
        assert len(failures) == 0
