"""
Runs pychecker.
"""


import os, os.path, re

# list of modules to put through pychecker
modules = ['mailadmin','popkern']

# these messages are harmless.
harmless_messages = """
/home/mir/src/kundebunt/popkern/utils.py:124: Setting accessible_domains to itself has no effect
/home/mir/src/kundebunt/contrib/advisory.py:10: Statement appears to have no effect
/home/mir/src/django/active/django/db/models/manipulators.py:81: Overridden method (save) doesn't match signature in class (<class 'kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator'>)
/home/mir/src/django/active/django/db/models/manipulators.py:81: Overridden method (save) doesn't match signature in class (<class 'kundebunt.mailadmin.forms.mailrule.MailruleAddManipulator'>)
/home/mir/lib/python/kundebunt/mailadmin/forms/search.py:52: Q | Q has no effect
/home/mir/lib/python/kundebunt/mailadmin/forms/search.py:240: Q | Q has no effect
/home/mir/lib/python/kundebunt/mailadmin/views.py:53: Base class (views.KundeNotActive) __init__() not called
/home/mir/lib/python/kundebunt/popkern/fields.py:93: __get__ is not a special method
/home/mir/lib/python/kundebunt/popkern/fields.py:121: __set__ is not a special method
/home/mir/src/kundebunt/kundebunt/popkern/updatelog.py:195: Invalid arguments to (dict), got 2, expected between 0 and 1
/home/mir/src/kundebunt/popkern/datasources.py:56: Redefining attribute (<generator expression>) original line (54)
/home/mir/src/kundebunt/popkern/datasources.py:56: Redefining attribute (<generator expression>) original line (72)
/home/mir/lib/python/kundebunt/popkern/datasources.py:147: Overridden method (from_request) doesn't match signature in class (<class 'datasources.QuerySetDataSource'>)
/home/mir/lib/python/kundebunt/popkern/datasources.py:147: Overridden method (from_request) doesn't match signature in class (<class 'kundebunt.popkern.datasources.QuerySetDataSource'>)
/home/mir/lib/python/kundebunt/popkern/popdb.py:194: __unicode__ is not a special method
/home/mir/lib/python/kundebunt/popkern/popdb.py:289: Law of Demeter violated, more than 5 references for (djfield.rel.to._meta.pk.attname)
/home/mir/src/kundebunt/kundebunt/popkern/popdb.py:47: Variable (_dummy) not used
/home/mir/src/kundebunt/kundebunt/popkern/popdb.py:192: Base class (exceptions.RuntimeError) __init__() not called
/home/mir/src/kundebunt/kundebunt/popkern/popdb.py:753: self is not first method argument
/home/mir/lib/python/kundebunt/popkern/datasources.py:290: Q | Q has no effect
/home/mir/src/kundebunt/kundebunt/popkern/datasources.py:100: Redefining attribute (<generator expression>) original line (97)
/home/mir/src/kundebunt/kundebunt/popkern/datasources.py:117: Redefining attribute (<generator expression>) original line (116)
/home/mir/lib/python/kundebunt/popkern/datasources.py:101: Redefining attribute (<generator expression>) original line (98)
/home/mir/lib/python/kundebunt/popkern/datasources.py:118: Redefining attribute (<generator expression>) original line (117)
/home/mir/lib/python/kundebunt/popkern/formfields.py:596: Function (__init__) has too many arguments (16)
/home/mir/lib/python/kundebunt/popkern/utils.py:31: self is not first method argument
/home/mir/lib/python/kundebunt/popkern/utils.py:43: self is not first method argument
kundebunt/popkern/formfields.py:642: Function (__init__) has too many arguments (16)
/home/mir/src/kundebunt/kundebunt/popkern/datasources.py:103: Redefining attribute (<generator expression>) original line (100)
home/mir/src/kundebunt/kundebunt/popkern/datasources.py:120: Redefining attribute (<generator expression>) original line (119)
home/mir/src/kundebunt/kundebunt/popkern/utils.py:558: Q | Q has no effect
"""

pycheck_re = re.compile(r'^(?:.*/)?(?:kundebunt|django)/([^:]+):\d+: (.*)\s*$')

def test_pychecker():
    # test version of pychecker
    f = os.popen('pychecker --version', 'r')
    version = [int(s) for s in f.readline().strip().split('.')]
    f.close()
    if version < [0, 8, 16]:
        print 'pychecker too old, skipping this test.'
        return

    harmless_set = set([pycheck_re.match(line).groups() for line in harmless_messages.split('\n') if line])
    import kundebunt
    top_dir = kundebunt.__path__[0]
    search_path = " ".join([os.path.join(top_dir, module) for module in modules])
    f = os.popen('''find %s -name '*.py' | xargs pychecker -Q | grep kundebunt''' % search_path, "r")
    success = True
    for line in f:
        if line:
            info = pycheck_re.match(line)
            if info==None or not info.groups() in harmless_set:
                print line
                success = False
    f.close()
    assert success, "pychecker found interesting code."
