import datetime, py
from kundebunt.tests.fixtures import base_setup
from kundebunt.testutils.t_repr import t_repr

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.insert_data("domainkunde",
        [{
        'beginn': 0L,
        'domain': 'noris.de',
        'ende': None,
        'expires': None,
        'flags': 3L,
        'infotext': None,
        'kunde': 1L,
        'owner': None,
        'person': None,
        'rechinfo': None,
        'status': 9,
        'timestamp': datetime.datetime.now(),
        }])

def test_domain_sort_key():
    from kundebunt.popkern.utils import domain_sort_key
    assert domain_sort_key("service.noris.de") == ['de', 'noris', 'service']
    assert domain_sort_key(".service.noris.de.") == ['de', 'noris', 'service', '']
    assert domain_sort_key(".") == ['']
    assert domain_sort_key("") == ['']
    assert domain_sort_key(None) == None
    assert domain_sort_key("local.part@eine.domain") == ['domain', 'eine', 'local.part']
    assert domain_sort_key("local.part@eine.domain.") == ['domain', 'eine', 'local.part']
    assert domain_sort_key("@eine.domain.") == ['domain', 'eine', '']
    assert domain_sort_key("bla@ein@e.domain") == ['domain', 'ein@e', 'bla']

def test_domain():
    from kundebunt.popkern.models import Domainkunde, Kunde
    from kundebunt.popkern.utils import Domain

    d = Domain("blabla.noris.de",[Domainkunde(domain="noris.de")])
    assert t_repr((d.subdomain, d.domainkunde, d.foreign_domain, d.obsolete_domain)) == ('blabla', "<Domainkunde: noris.de>", None, None)
    assert repr(d) == "<Domain blabla . noris.de>"
    assert t_repr(d.accessible_domains) ==  ["<Domainkunde: noris.de>"]
    assert str(d) == 'blabla.noris.de'

    d = Domain("blabla.wrzlbrnz.local", [])
    assert (d.subdomain, d.domainkunde, d.foreign_domain, d.obsolete_domain) == (None, None, None, 'blabla.wrzlbrnz.local')
    assert repr(d) == "<Domain blabla.wrzlbrnz.local (obsolete)>"
    assert str(d) == 'blabla.wrzlbrnz.local'

    d = Domain("blznkratz.noris.de",[])
    assert t_repr((d.subdomain, d.domainkunde, d.foreign_domain, d.obsolete_domain)) ==  ('blznkratz', None, "<Domainkunde: noris.de>", None)
    assert repr(d) == "<Domain blznkratz . noris.de (foreign)>"
    assert str(d) == 'blznkratz.noris.de'

    py.test.raises(AssertionError, Domain, "blabla.wrzlbrnz.local")

    d = Domain("blabla.wrzlbrnz.local", kunden=Kunde.objects.filter(name="POP"))
    assert repr(d) == "<Domain blabla.wrzlbrnz.local (obsolete)>"
    assert set(t_repr(d.accessible_domains)) == set(["<Domainkunde: noris.de>","<Domainkunde: noris.net>"])

    d = Domain("", [])
    assert repr(d) == "<Domain None>"
    assert str(d) == ""

def test_email_address():
    from kundebunt.popkern.utils import EmailAddress
    e = EmailAddress("mir@noris.de", True)
    assert repr(e) == "<EmailAddress mir @ noris.de>"
    e.check_domain(["de"])
    assert repr(e.checked_domain) == "<Domain noris . de>"
    assert t_repr((e.subdomain, e.domainkunde, e.foreign_domain, e.obsolete_domain)) == ('noris', 'de', None, None)

    assert repr(EmailAddress("mir", True)) == "<EmailAddress  @ mir>"
    assert repr(EmailAddress("mir", False)) == "<EmailAddress mir @ >"
    assert repr(EmailAddress("", False)) == "<EmailAddress  @ >"
    assert repr(EmailAddress(None, True)) == "<EmailAddress  @ >"

