from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.db import transaction
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.popkern import updatelog
from kundebunt.tests.fixtures import base_setup, testclasses

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)

class TestAsFany(testclasses.AsFany):

    @staticmethod
    def get_runner():
        return runner

    @transaction.commit_on_success
    def test_updatelog(self):
        from django.db import connection
        cursor = connection.cursor()
        cursor.execute("alter table updatelog auto_increment=1")

        from kundebunt.popkern.models import Mailrule, Updatelog, Kunde, Person
        updatelog._log_person.person = Person.objects.get(user="fany")

        pop = Kunde.objects.get(name="POP")
        rule = Mailrule(kunde=pop, quelle="quelle@bla.net", ziel="ziel@bla.net", typ=Mailrule.get_typ_descr("virt"))
        rule.save()

        rule.quelle="anderequelle@bla.net"
        rule.ziel="anderesziel@bla.net"
        rule.save()

        rule.ziel="ganzwoanders@bla.net"
        rule.save()

        rule.delete()
        ist = t_repr(Updatelog.objects.all())
        pprint(ist)
        print
        soll =[
            '<Updatelog: #1, fany: Tabelle mailrules(kunde=1): id|kunde|quelle|typ|ziel|*:164|1|quelle@bla.net|virt|ziel@bla.net>',
            '<Updatelog: #2, fany: Tabelle kunde(id=1): mailrules|*:164>',
            '<Updatelog: #3, fany: Tabelle mailrules(kunde=1): id|quelle|ziel:164|quelle@bla.net|ziel@bla.net>',
            '<Updatelog: #4, fany: Tabelle mailrules(kunde=1): id|quelle|ziel:164|anderequelle@bla.net|anderesziel@bla.net>',
            '<Updatelog: #5, fany: Tabelle mailrules(kunde=1): id|kunde|quelle|typ|ziel|-:164|1|anderequelle@bla.net|virt|ganzwoanders@bla.net>',
            '<Updatelog: #6, fany: Tabelle kunde(id=1): mailrules|-:164>'
            ]

        for (_i,_s) in zip(ist,soll):
            if _i!=_s:
                print "Ist:  %s" % _i
                print "Soll: %s" % _s
                print
        assert ist==soll
        transaction.rollback()

    @transaction.commit_on_success
    def test_composite_keys_updatelog(self):
        from kundebunt.popkern.models import Updatelog, Kunde, Person, Acct, Acctassoc, Dienst
        updatelog._log_person.person = Person.objects.get(user="fany")
        pop = Kunde.objects.get(name="POP")

        acct = Acct.objects.create(
                kunde = pop, jjmm=201001, tt=28,
                dienst=Dienst.objects.get(name='service'),
                dest=Acct.get_dest_descr("alle"),
                pakete=0, bytes=2, quelle=Acct.get_quelle_descr('noris')
        )
        assoc = Acctassoc.objects.create(
            hash=acct.hash, seq=acct.seq,
            info = u"Schwierige Sache"
        )

        acct.bytes=3
        acct.save()

        assoc.info = u'Ohne Berechnung'
        assoc.save()

        assoc.delete()
        acct.delete()

        ist = t_repr(Updatelog.objects.all())
        print(ist)
        soll=[
            '<Updatelog: #1, fany: Tabelle acct(kunde=1): bytes|dest|dienst|hash|jjmm|kunde|pakete|quelle|seq|tt|*:2|alle|1254|529712830|201001|1|0|noris|1|28>',
            '<Updatelog: #2, fany: Tabelle acctassoc(kunde=1): hash|info|seq|*:529712830|Schwierige Sache|1>',
            '<Updatelog: #3, fany: Tabelle acct(kunde=1): bytes|hash|seq:2|529712830|1>',
            '<Updatelog: #4, fany: Tabelle acctassoc(kunde=1): hash|info|seq:529712830|Schwierige Sache|1>',
            '<Updatelog: #5, fany: Tabelle acctassoc(kunde=1): hash|info|seq|-:529712830|Ohne Berechnung|1>',
            '<Updatelog: #6, fany: Tabelle acct(kunde=1): bytes|dest|dienst|hash|jjmm|kunde|pakete|quelle|seq|tt|-:3|alle|1254|529712830|201001|1|0|noris|1|28>',
        ]

        for (_i,_s) in zip(ist,soll):
            if _i!=_s:
                print "Ist:  %s" % _i
                print "Soll: %s" % _s
                print
        assert ist==soll
        transaction.rollback()
