# -*- encoding: UTF-8 -*-

"""
Durchlauf aller Masken für eine Person ohne staff-Berechtigung mit
mehreren Unterkunden. Die Masken werden nur oberflächlich
getestet (kein Test auf Fehlermeldungen oder spezielle Bedingungen).
Sprache steht auf Englisch.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'checkts')

class TestWithMultipleCustomers(testclasses.WithMultipleCustomers):
    class TestAsStaff(testclasses.AsStaff):
        def test_initial_portal(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/sluka/
            response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>'],
            'kunden_name': 'sluka',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailrule_count': 1L,
            'messages': [],
            'mailbox_rules': {},
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/test/
            response, context = runner.get_response('/mailadmin/portal/test/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: test>'],
            'kunden_name': 'test',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/wally/
            response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: wally>'],
            'kunden_name': 'wally',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})

        def test_customer_search(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/customer-qsearch/
            GET = MultiValueDict({'cust_search': ['wally'], 'quick':[1]})
            POST = MultiValueDict({})
            response, context = runner.get_response('/mailadmin/customer-qsearch/', 'GET', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/portal/wally/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/customer-qsearch/
            GET = MultiValueDict({'cust_search': ['POP'], 'quick':[1]})
            POST = MultiValueDict({})
            response, context = runner.get_response('/mailadmin/customer-qsearch/', 'GET', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/portal/POP/',
            'status_code': 302})

        def test_portal_anderer_kunde(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POP/
            response, context = runner.get_response('/mailadmin/portal/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: POP>'],
            'kunden_name': 'POP',
            'mailbox_count': 1L,
            'mailboxes': ['<Person: fany, Herr Martin H. Sluka>'],
            'mailbox_rules': {},
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})

        def test_customer_search_formular(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/customer-qsearch/
            GET = MultiValueDict({'cust_search': ['']})
            POST = MultiValueDict({})
            response, context = runner.get_response('/mailadmin/customer-qsearch/', 'GET', GET, POST)
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': MultiValueDict({'cust_search': ['']}),
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>'},
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})

        def test_create_mailbox_for_POP(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailbox/POP/
            response, context = runner.get_response('/mailadmin/create-mailbox/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {},
                        'data': {'kunden_name': 'POP'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
                'messages': [],
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/create-mailbox/POP/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['piep.de'],
            'mailrule.0.quelle_localpart': ['piep'],
            'name': ['Pieper'],
            'pass_field': ['piep'],
            'password_confirmal': ['piep'],
            'user': ['piep']})
            response, context = runner.get_response('/mailadmin/create-mailbox/POP/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/piep/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/piep/
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'piep.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                          'pass_field': ['Das Passwort ist recht kurz.']},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'piep.de',
                                'mailrule.0.quelle_localpart': 'piep',
                                'mailrule.0.quelle_subdomain': None,
                                'name': 'Pieper',
                                'user': 'piep'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
                'object': '<Person: piep, Pieper>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})

        def test_edit_mailbox_for_POP(self):
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/piep/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['noris.de'],
            'mailrule.0.quelle_localpart': ['piep'],
            'mailrule.1.quelle_domain': [''],
            'mailrule.1.quelle_localpart': [''],
            'name': ['Pieper'],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['piep']})
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/piep/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/piep/
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'noris.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                          'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'piep@piep.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],
                                          'pass_field': ['Das Passwort ist recht kurz.']},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'noris.de',
                                'mailrule.0.quelle_localpart': 'piep',
                                'mailrule.0.quelle_subdomain': None,
                                'name': 'Pieper',
                                'user': 'piep'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
                'object': '<Person: piep, Pieper>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/piep/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['noris.de'],
            'mailrule.0.quelle_localpart': ['piep'],
            'mailrule.1.quelle_domain': ['checkts.net'],
            'mailrule.1.quelle_localpart': ['piep'],
            'name': ['Pieper'],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['piep']})
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/piep/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/piep/
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'noris.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                          'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'piep@piep.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],
                                          'pass_field': ['Das Passwort ist recht kurz.']},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'noris.de',
                                'mailrule.0.quelle_localpart': 'piep',
                                'mailrule.0.quelle_subdomain': None,
                                'mailrule.1.quelle_domain': 'checkts.net',
                                'mailrule.1.quelle_localpart': 'piep',
                                'mailrule.1.quelle_subdomain': '',
                                'name': 'Pieper',
                                'user': 'piep'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
                'object': '<Person: piep, Pieper>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/piep/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.check_remove': ['on'],
            'mailrule.0.quelle_domain': ['noris.de'],
            'mailrule.0.quelle_localpart': ['piep'],
            'mailrule.1.quelle_domain': ['checkts.net'],
            'mailrule.1.quelle_localpart': ['piep'],
            'mailrule.2.quelle_domain': [''],
            'mailrule.2.quelle_localpart': [''],
            'name': ['Pieper'],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['piep']})
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/piep/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/piep/
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.'],
                                          'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'piep@piep.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'checkts.net',
                                'mailrule.0.quelle_localpart': 'piep',
                                'mailrule.0.quelle_subdomain': '',
                                'name': 'Pieper',
                                'user': 'piep'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
                'object': '<Person: piep, Pieper>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/piep/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['checkts.net'],
            'mailrule.0.quelle_localpart': ['pieper'],
            'mailrule.1.quelle_domain': [''],
            'mailrule.1.quelle_localpart': [''],
            'name': ['Pieper'],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['pieper']})
            response, context = runner.get_response('/mailadmin/mailbox/piep/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/pieper/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/pieper/
            response, context = runner.get_response('/mailadmin/mailbox/pieper/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.'],
                                          'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'piep@piep.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'checkts.net',
                                'mailrule.0.quelle_localpart': 'pieper',
                                'mailrule.0.quelle_subdomain': '',
                                'name': 'Pieper',
                                'user': 'pieper'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
                'object': '<Person: pieper, Pieper>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})

        def test_delete_mailbox_for_POP(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/delete-mailbox/pieper/
            response, context = runner.get_response('/mailadmin/delete-mailbox/pieper/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'kunden_name': 'POP',
            'mailbox': '<Person: pieper, Pieper>',
            'mailbox_is_deleteable': True,
            'mailrules': ['<Mailrule: (virt) pieper@checkts.net -> pieper>'],
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/delete-mailbox/pieper/
            response, context = runner.get_response('/mailadmin/delete-mailbox/pieper/', 'POST', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/portal/POP/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POP/
            response, context = runner.get_response('/mailadmin/portal/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: POP>'],
            'kunden_name': 'POP',
            'mailbox_count': 1L,
            'mailboxes': ['<Person: fany, Herr Martin H. Sluka>'],
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POP/
            response, context = runner.get_response('/mailadmin/portal/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: POP>'],
            'kunden_name': 'POP',
            'mailbox_count': 1L,
            'mailboxes': ['<Person: fany, Herr Martin H. Sluka>'],
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})

        def test_edit_mailbox_fany(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/fany/
            response, context = runner.get_response('/mailadmin/mailbox/fany/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht \xc3\xbcber andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                        '<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'sluka@noris.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                        'data': {'kunden_name': 'POP',
                                'name': 'Herr Martin H. Sluka',
                                'user': 'fany'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': [],
                'object': '<Person: fany, Herr Martin H. Sluka>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/fany/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['unf.ug'],
            'mailrule.0.quelle_localpart': ['popfan'],
            'name': ['Herr Martin H. Sluka'],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['fany']})
            response, context = runner.get_response('/mailadmin/mailbox/fany/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/fany/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/fany/
            response, context = runner.get_response('/mailadmin/mailbox/fany/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'sluka@noris.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],},
                        'data': {'kunden_name': 'POP',
                                'mailrule.0.quelle_domain': 'unf.ug',
                                'mailrule.0.quelle_localpart': 'popfan',
                                'mailrule.0.quelle_subdomain': '',
                                'name': 'Herr Martin H. Sluka',
                                'user': 'fany'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
                'object': '<Person: fany, Herr Martin H. Sluka>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/mailbox/fany/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'mailrule.0.quelle_domain': ['unf.ug'],
            'mailrule.0.quelle_localpart': ['popfan'],
            'mailrule.1.quelle_domain': [''],
            'mailrule.1.quelle_localpart': [''],
            'name': [''],
            'pass_field': [''],
            'password_confirmal': [''],
            'user': ['fany']})
            response, context = runner.get_response('/mailadmin/mailbox/fany/', 'POST', GET, POST)
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'sluka@noris.de\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n'],},
                        'data': MultiValueDict({'mailrule.0.quelle_domain': ['unf.ug'], 'kunden_name': ['POP'], 'mailrule.0.quelle_localpart': ['popfan'], 'pass_field': [''], 'mailrule.0.check_remove': [False], 'mailrule.1.quelle_localpart': [''], 'mailrule.1.quelle': [None], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'mailrule.1.quelle_subdomain': [None], 'mailrule.1.quelle_domain': [''], 'password_confirmal': [''], 'user': ['fany'], 'mailrule.1.check_remove': [False], 'name': [''], 'force_create':[False]}),
                        'edit_inline': True,
                        'error_dict': {'name': ['Bitte dieses Feld ausfüllen.']},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'POP',
                'messages': [],
                'object': '<Person: fany, Herr Martin H. Sluka>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})

        def test_create_mailrule_for_POP(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailrule/POP/
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'rule_type': 'virt', 'kunden_name': 'POP', 'quelle_localpart': '', 'form_is_readonly': '',
                            'quelle_domain': '', 'quelle_subdomain': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailrule/POP/dev_null/
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/dev_null/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'form_is_readonly': '',
                            'kunden_name': 'POP',
                            'quelle_domain': '',
                            'quelle_localpart': '',
                            'quelle_subdomain': None,
                            'rule_type': 'dev_null',
                            'timestamp_date': Ellipsis,
                            'timestamp_time': Ellipsis,
                            },
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/create-mailrule/POP/dev_null/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'rule_type': ['dev_null'],
            'quelle_domain': ['spam.noris.net'],
            'typ_display': ['Verwerfen']})
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/dev_null/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailrule/167',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailrule/167/
            response, context = runner.get_response('/mailadmin/mailrule/167/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'form_is_readonly': '',
                            'kunden_name': 'POP',
                            'quelle_domain': 'noris.net',
                            'quelle_localpart': '',
                            'quelle_subdomain': 'spam',
                            'rule_type': 'dev_null',
                            'timestamp_date': Ellipsis,
                            'timestamp_time': Ellipsis,
                            },
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
            'object': '<Mailrule: (dev_null) spam.noris.net -> None>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailrule/POP/
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'rule_type': 'virt', 'kunden_name': 'POP', 'quelle_localpart': '', 'form_is_readonly': '',
                            'quelle_domain': '', 'quelle_subdomain': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailrule/POP/smtp_route_mx/
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/smtp_route_mx/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'form_is_readonly': '',
                            'kunden_name': 'POP',
                            'quelle_domain': '',
                            'quelle_localpart': '',
                            'quelle_subdomain': None,
                            'rule_type': 'smtp_route_mx',
                            'timestamp_date': Ellipsis,
                            'timestamp_time':Ellipsis,
                            },
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/create-mailrule/POP/smtp_route_mx/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['POP'],
            'rule_type': ['smtp_route_mx'],
            'quelle_domain': ['noris.de'],
            'ziel': ['noris.net']})
            response, context = runner.get_response('/mailadmin/create-mailrule/POP/smtp_route_mx/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailrule/168',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailrule/168/
            response, context = runner.get_response('/mailadmin/mailrule/168/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'quelle_domain': ["Die Domain 'noris.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."]},
                    'data': {'form_is_readonly': '',
                            'kunden_name': 'POP',
                            'quelle_domain': 'noris.de',
                            'quelle_localpart': '',
                            'quelle_subdomain': None,
                            'rule_type': 'smtp_route_mx',
                            'timestamp_date': Ellipsis,
                            'timestamp_time': Ellipsis,
                            'ziel': 'noris.net'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
            'object': '<Mailrule: (smtp_route_mx) noris.de -> noris.net>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POP/
            response, context = runner.get_response('/mailadmin/portal/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: POP>'],
            'kunden_name': 'POP',
            'mailbox_count': 1L,
            'mailboxes': ['<Person: fany, Herr Martin H. Sluka>'],
            'mailbox_rules': {'fany': ['<Mailrule: (virt) popfan@unf.ug -> fany>']},
            'mailrule_count': 3L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': ['<Mailrule: (smtp_route_mx) noris.de -> noris.net>',
                    '<Mailrule: (dev_null) spam.noris.net -> None>',
                    '<Mailrule: (virt) popfan@unf.ug -> fany>'],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            assert runner.body_without(response, 'Keine E-Mail-Adresse')
            # --------------------------------------------------------------------
            # GET /mailadmin/mailrule/166/
            response, context = runner.get_response('/mailadmin/mailrule/166/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'form_is_readonly': '',
                            'kunden_name': 'POP',
                            'quelle_domain': 'unf.ug',
                            'quelle_localpart': 'popfan',
                            'quelle_subdomain': '',
                            'rule_type': 'virt',
                            'timestamp_date': Ellipsis,
                            'timestamp_time': Ellipsis,
                            'virt_ziele': 'fany'
                            },
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': Ellipsis},
            'kunden_name': 'POP',
            'messages': [],
            'object': '<Mailrule: (virt) popfan@unf.ug -> fany>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})

        def test_portal_notexisting_customer(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POPdasdasasd/
            response, context = runner.get_response('/mailadmin/portal/POPdasdasasd/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'kunden_name': 'POPdasdasasd',
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})

        def test_create_mailbox_for_test(self):
            # --------------------------------------------------------------------
            # GET /mailadmin/create-mailbox/test/
            response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {},
                        'data': {'kunden_name': 'test'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
                'messages': [],
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Groß- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/create-mailbox/test/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['test'],
            'mailrule.0.quelle_domain': ['checkts.net'],
            'mailrule.0.quelle_localpart': ['neuertest'],
            'name': ['neutest'],
            'pass_field': ['neu'],
            'password_confirmal': [''],
            'user': ['neuertest']})
            response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'POST', GET, POST)
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                        'data': MultiValueDict({'mailrule.0.quelle_domain': ['checkts.net'], 'kunden_name': ['test'], 'mailrule.0.quelle_localpart': ['neuertest'], 'pass_field': ['neu'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': ['neutest'], 'mailrule.0.quelle': [None], 'user': ['neuertest'], 'password_confirmal': [''], 'force_create':[False]}),
                        'edit_inline': True,
                        'error_dict': {'password_confirmal': ['Bitte das Passwort zur \xc3\x9cberprüfung zus\xc3\xa4tzlich in das Best\xc3\xa4tigungsfeld eingeben.']},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
                'messages': [],
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # POST /mailadmin/create-mailbox/test/
            GET = MultiValueDict({})
            POST = MultiValueDict({'kunden_name': ['test'],
            'mailrule.0.quelle_domain': ['checkts.net'],
            'mailrule.0.quelle_localpart': ['neuertest'],
            'name': ['neutest'],
            'pass_field': ['neu'],
            'password_confirmal': ['neu'],
            'user': ['neuertest']})
            response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/mailbox/neuertest/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /mailadmin/mailbox/neuertest/
            response, context = runner.get_response('/mailadmin/mailbox/neuertest/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context,
                {'form': {'_inline_collections': Ellipsis,
                        'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                        'data': {'kunden_name': 'test',
                                'mailrule.0.quelle_domain': 'checkts.net',
                                'mailrule.0.quelle_localpart': 'neuertest',
                                'mailrule.0.quelle_subdomain': '',
                                'name': 'neutest',
                                'user': 'neuertest'},
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
                'kunden_name': 'test',
                'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
                'object': '<Person: neuertest, neutest>',
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
                'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({}),
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})
            assert runner.body_without(response, 'Keine E-Mail')
