# -*- encoding: UTF-8 -*-

"""
Durchlauf aller Masken für eine Person ohne staff-Berechtigung mit
mehreren Unterkunden. Die Masken werden nur oberflächlich
getestet (kein Test auf Fehlermeldungen oder spezielle Bedingungen).
Sprache steht auf Englisch.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    settings.LANGUAGE_CODE='en'

class TestWithMultipleCustomers(testclasses.WithMultipleCustomers):
    def test_initial_portal(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_initial_kundensicht(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/wally/
        response, context = runner.get_response('/mailadmin/create-mailbox/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'kunden_name': 'wally'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})

    def test_create_mailbox(self):
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/wally/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['wally'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['wabba'],
        'name': ['Wabbawabba'],
        'pass_field': ['wabba'],
        'password_confirmal': ['wabba']})
        response, context = runner.get_response('/mailadmin/create-mailbox/wally/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/wal1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/wal1/
        response, context = runner.get_response('/mailadmin/mailbox/wal1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['This password is rather short.']},
                    'data': {'kunden_name': 'wally',
                            'mailrule.0.quelle_domain': 'checkts.net',
                            'mailrule.0.quelle_localpart': 'wabba',
                            'mailrule.0.quelle_subdomain': '',
                            'name': 'Wabbawabba',
                            'user': 'wal1'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'wally',
            'messages': ['It may take up to ten minutes until this change becomes active.', 'The account was created successfully.'],
            'object': '<Person: wal1, Wabbawabba>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 1L,
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>']},
        'mailrule_count': 2L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_edit_mailbox(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/wal1/
        response, context = runner.get_response('/mailadmin/mailbox/wal1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['This password is rather short.']},
                    'data': {'kunden_name': 'wally',
                            'mailrule.0.quelle_domain': 'checkts.net',
                            'mailrule.0.quelle_localpart': 'wabba',
                            'mailrule.0.quelle_subdomain': '',
                            'name': 'Wabbawabba',
                            'user': 'wal1'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'wally',
            'messages': [],
            'object': '<Person: wal1, Wabbawabba>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/wal1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['wally'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['wabba'],
        'mailrule.1.quelle_domain': ['unf.ug'],
        'mailrule.1.quelle_localpart': ['gnubgnub'],
        'name': ['Wabbawabba'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['wal1']})
        response, context = runner.get_response('/mailadmin/mailbox/wal1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/wal1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/wal1/
        response, context = runner.get_response('/mailadmin/mailbox/wal1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['This password is rather short.']},
                    'data': {'kunden_name': 'wally',
                            'mailrule.0.quelle_domain': 'checkts.net',
                            'mailrule.0.quelle_localpart': 'wabba',
                            'mailrule.0.quelle_subdomain': '',
                            'mailrule.1.quelle_domain': 'unf.ug',
                            'mailrule.1.quelle_localpart': 'gnubgnub',
                            'mailrule.1.quelle_subdomain': '',
                            'name': 'Wabbawabba',
                            'user': 'wal1'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'wally',
            'messages': ['It may take up to ten minutes until this change becomes active.', 'The account was updated successfully.'],
            'object': '<Person: wal1, Wabbawabba>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/wally/
        response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: wally>'],
        'kunden_name': 'wally',
        'mailbox_count': 1L,
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>']},
        'mailrule_count': 2L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 1L,
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>']},
        'mailrule_count': 3L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_without(response, 'Keine E-Mail')

    def test_kundensicht2(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/sluka/
        response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailbox_rules': {},
        'mailboxes': [],
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/test/
        response, context = runner.get_response('/mailadmin/portal/test/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: test>'],
        'kunden_name': 'test',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 0L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_create_mailbox2(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/test/
        response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {},
                    'data': {'kunden_name': 'test'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/test/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['test'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['taste'],
        'name': ['T\xc3\xa4stt\xc3\xa4st'],
        'pass_field': ['test'],
        'password_confirmal': ['test']})
        response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/tes1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/tes1/
        response, context = runner.get_response('/mailadmin/mailbox/tes1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['This password is rather short.']},
                    'data': {'kunden_name': 'test',
                            'mailrule.0.quelle_domain': 'checkts.net',
                            'mailrule.0.quelle_localpart': 'taste',
                            'mailrule.0.quelle_subdomain': '',
                            'name': 'T\xc3\xa4stt\xc3\xa4st',
                            'user': 'tes1'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'test',
            'messages': ['It may take up to ten minutes until this change becomes active.', 'The account was created successfully.'],
            'object': '<Person: tes1, T\xc3\xa4stt\xc3\xa4st>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/test/
        response, context = runner.get_response('/mailadmin/portal/test/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: test>'],
        'kunden_name': 'test',
        'mailbox_count': 1L,
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>'],
        'mailbox_rules': {'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) taste@checkts.net -> tes1>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 2L,
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>',
                    '<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'], 'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailrule_count': 4L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) taste@checkts.net -> tes1>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_mailbox_qsearch(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox-qsearch/
        response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'mailboxes': [],
        'mailbox_rules': {},
        'messages': [],
        'noquery': True,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        # 'search_params': ''
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox-qsearch/
        GET = MultiValueDict({'search': ['wab'], 'kunde': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': ['wab'], 'kunde': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>']},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'search=wab&kunde=',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox-qsearch/
        GET = MultiValueDict({'search': ['gnub'], 'kunde': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': ['gnub'], 'kunde': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>']},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'search=gnub&kunde=',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox-qsearch/
        GET = MultiValueDict({'search': [''], 'kunde': ['test']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': [''], 'kunde': ['test']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'kunden_name': 'test',
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>'],
        'mailbox_rules': {'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'search=&kunde=test',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox-qsearch/
        GET = MultiValueDict({'all': ['all']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'all': ['all']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>',
                    '<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) wabba@checkts.net -> wal1>', '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'], 'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'all=all',
        'user': '<User: checkts>'})

    def test_mailrule_search(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-search/
        response, context = runner.get_response('/mailadmin/mailrule-search/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': Ellipsis,
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleSearchForm object>'},
        'messages': [],
        'noquery': True,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-search/
        GET = MultiValueDict({'domain_mode': ['starts_with'],
        'domain_text': [''],
        'field': ['quelle'],
        'kunde': [''],
        'localpart': ['gnub'],
        'localpart_mode': ['starts_with'],
        'typ': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-search/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'field': ['quelle'], 'localpart_mode': ['starts_with'], 'domain_text': [''], 'kunde': [''], 'domain_mode': ['starts_with'], 'localpart': ['gnub'], 'typ': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleSearchForm object>'},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'search_params': 'field=quelle&localpart_mode=starts_with&domain_text=&kunde=&domain_mode=starts_with&localpart=gnub&typ=',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-search/
        GET = MultiValueDict({'domain_mode': ['starts_with'],
        'domain_text': ['checkts'],
        'field': ['quelle'],
        'kunde': [''],
        'localpart': [''],
        'localpart_mode': ['starts_with'],
        'typ': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-search/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'field': ['quelle'], 'localpart_mode': ['starts_with'], 'domain_text': ['checkts'], 'kunde': [''], 'domain_mode': ['starts_with'], 'localpart': [''], 'typ': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleSearchForm object>'},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'field=quelle&localpart_mode=starts_with&domain_text=checkts&kunde=&domain_mode=starts_with&localpart=&typ=',
        'rules': ['<Mailrule: (virt) taste@checkts.net -> tes1>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>'],
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-search/
        GET = MultiValueDict({'domain_mode': ['starts_with'],
        'domain_text': [''],
        'field': ['quelle'],
        'kunde': ['wally'],
        'localpart': [''],
        'localpart_mode': ['starts_with'],
        'typ': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-search/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'field': ['quelle'], 'localpart_mode': ['starts_with'], 'domain_text': [''], 'kunde': ['wally'], 'domain_mode': ['starts_with'], 'localpart': [''], 'typ': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleSearchForm object>'},
        'kunden_name': 'wally',
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'search_params': 'field=quelle&localpart_mode=starts_with&domain_text=&kunde=wally&domain_mode=starts_with&localpart=&typ=',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-search/
        GET = MultiValueDict({'domain_mode': ['starts_with'],
        'domain_text': [''],
        'field': ['quelle'],
        'kunde': [''],
        'localpart': [''],
        'localpart_mode': ['starts_with'],
        'typ': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-search/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'field': ['quelle'], 'localpart_mode': ['starts_with'], 'domain_text': [''], 'kunde': [''], 'domain_mode': ['starts_with'], 'localpart': [''], 'typ': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleSearchForm object>'},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) taste@checkts.net -> tes1>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'search_params': 'field=quelle&localpart_mode=starts_with&domain_text=&kunde=&domain_mode=starts_with&localpart=&typ=',
        'user': '<User: checkts>'})

    def test_mailrule_qsearch(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-qsearch/
        response, context = runner.get_response('/mailadmin/mailrule-qsearch/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleQuickSearchForm object>'},
        'messages': [],
        'noquery': True,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-qsearch/
        GET = MultiValueDict({'search': ['taste'], 'kunde': [''], 'domain_select': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': ['taste'], 'domain_select': [''], 'kunde': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleQuickSearchForm object>'},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': 'search=taste&kunde=&domain_select=',
        'rules': ['<Mailrule: (virt) taste@checkts.net -> tes1>'],
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-qsearch/
        GET = MultiValueDict({'search': [''], 'kunde': [''], 'domain_select': ['checkts.net']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': [''], 'domain_select': ['checkts.net'], 'kunde': ['']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleQuickSearchForm object>'},
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) taste@checkts.net -> tes1>',
                '<Mailrule: (virt) wabba@checkts.net -> wal1>'],
        'search_params': 'search=&kunde=&domain_select=checkts.net',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule-qsearch/
        GET = MultiValueDict({'search': [''], 'kunde': ['wally'], 'domain_select': ['']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/mailrule-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'search': [''], 'domain_select': [''], 'kunde': ['wally']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailruleQuickSearchForm object>'},
        'kunden_name': 'wally',
        'messages': [],
        'noquery': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) wabba@checkts.net -> wal1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'search_params': 'search=&kunde=wally&domain_select=',
        'user': '<User: checkts>'})

    def test_edit_mailrule(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule/164/
        response, context = runner.get_response('/mailadmin/mailrule/164/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'form_is_readonly': '',
                        'kunden_name': 'wally',
                        'quelle_localpart': 'wabba',
                        'quelle_domain': 'checkts.net',
                        'quelle_subdomain': '',
                        'rule_type': 'virt',
                        'timestamp_date': Ellipsis,
                        'timestamp_time': Ellipsis,
                        'virt_ziele': 'wal1'
                        },
                'edit_inline': True,
                'error_dict': {},
                'manipulator': Ellipsis},
        'kunden_name': 'wally',
        'messages': [],
        'object': '<Mailrule: (virt) wabba@checkts.net -> wal1>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailrule/164/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['wally'],
        'quelle_domain': ['checkts.net'],
        'quelle_localpart': ['wabba'],
        'rule_type': ['virt'],
        'virt_ziele': ['wal1\r\ngibtsnicht']})
        response, context = runner.get_response('/mailadmin/mailrule/164/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailrule/164/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule/164/
        response, context = runner.get_response('/mailadmin/mailrule/164/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'virt_ziele': ['gibtsnicht: This mailbox has not been registered with noris network.']},
                'data': {'form_is_readonly': '',
                        'kunden_name': 'wally',
                        'quelle_domain': 'checkts.net',
                        'quelle_localpart': 'wabba',
                        'quelle_subdomain': '',
                        'rule_type': 'virt',
                        'timestamp_date': Ellipsis,
                        'timestamp_time': Ellipsis,
                        'virt_ziele': 'gibtsnicht\nwal1'
                        },
                'edit_inline': True,
                'error_dict': {},
                'manipulator': Ellipsis},
        'kunden_name': 'wally',
        'messages': ['It may take up to ten minutes until this change becomes active.', 'The mail forwarding rule was updated successfully.'],
        'object': '<Mailrule: (virt) wabba@checkts.net -> wal1,gibtsnicht>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})

    def test_mailrule_delete(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/delete-mailrule/164/
        response, context = runner.get_response('/mailadmin/delete-mailrule/164/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'kunden_name': 'wally',
        'mailrule': '<Mailrule: (virt) wabba@checkts.net -> wal1,gibtsnicht>',
        'mailrule_is_deleteable': True,
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/delete-mailrule/164/
        response, context = runner.get_response('/mailadmin/delete-mailrule/164/', 'POST', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/wally/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/wally/
        response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: wally>'],
        'kunden_name': 'wally',
        'mailbox_count': 1L,
        'mailboxes': ['<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) gnubgnub@unf.ug -> wal1>']},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 2L,
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>',
                    '<Person: wal1, Wabbawabba>'],
        'mailbox_rules': {'wal1': ['<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'], 'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailrule_count': 3L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) taste@checkts.net -> tes1>',
                '<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_mailrule_delete2(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/wal1/
        response, context = runner.get_response('/mailadmin/mailbox/wal1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['This password is rather short.'],
                                      'mailrules': ['<p>If you use the webmail interface:</p>\n\n<p>This mailbox has an invalid sender and reply address, \'wabba@checkts.net\':\nThere is no mail forwarding rule that connects this e-mail address back to the mailbox, and therefore, replies cannot be received.</p>\n\n<p>To assign a valid sender and reply address to this mailbox, please either</p>\n\n<ul><li>create a mail forwarding rule for this address to the mailbox, for example by entering the address in one of the email fields below,</li>\n<li><em>or</em> change the sender address at <a href="https://mail.noris.net">https://mail.noris.net</a>\nat the following page:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>To disable this warning, please ask our <a href="mailto:support@noris.net">support staff</a>\nto update the sender address in our database.</li>\n</ul>\n'],},
                    'data': {'kunden_name': 'wally',
                            'mailrule.0.quelle_domain': 'unf.ug',
                            'mailrule.0.quelle_localpart': 'gnubgnub',
                            'mailrule.0.quelle_subdomain': '',
                            'name': 'Wabbawabba',
                            'user': 'wal1'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'wally',
            'messages': [],
            'object': '<Person: wal1, Wabbawabba>',
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'In the email address, lower or upper case makes no difference. If the part before the domain remains empty, it stands for the whole domain.',
            'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/delete-mailbox/wal1/
        response, context = runner.get_response('/mailadmin/delete-mailbox/wal1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'kunden_name': 'wally',
        'mailbox': '<Person: wal1, Wabbawabba>',
        'mailbox_is_deleteable': True,
        'mailrules': ['<Mailrule: (virt) gnubgnub@unf.ug -> wal1>'],
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/delete-mailbox/wal1/
        response, context = runner.get_response('/mailadmin/delete-mailbox/wal1/', 'POST', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/wally/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/wally/
        response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: wally>'],
        'kunden_name': 'wally',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 0L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 1L,
        'mailbox_rules': {'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>'],
        'mailrule_count': 2L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) taste@checkts.net -> tes1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/test/
        response, context = runner.get_response('/mailadmin/portal/test/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: test>'],
        'kunden_name': 'test',
        'mailbox_count': 1L,
        'mailbox_rules': {'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>'],
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (virt) taste@checkts.net -> tes1>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 1L,
        'mailbox_rules': {'tes1': ['<Mailrule: (virt) taste@checkts.net -> tes1>']},
        'mailboxes': ['<Person: tes1, T\xc3\xa4stt\xc3\xa4st>'],
        'mailrule_count': 2L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
                '<Mailrule: (virt) taste@checkts.net -> tes1>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
