# -*- encoding: utf-8 -*-

"""
Durchlauf aller Masken für eine Person ohne staff-Berechtigung mit
einem einzigen Kundeneintrag. Die Masken werden nur oberflächlich
getestet (kein Test auf Fehlermeldungen oder spezielle Bedingungen).
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)

def test_initial_portal():
    # --------------------------------------------------------------------
    # GET /mailadmin/portal/
    response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'domain_title': None,
    'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
    'domains': [],
    'get_new_mailbox_url': 'create-mailbox/',
    'kunden': ['<Kunde: sluka>'],
    'kunden_name': 'sluka',
    'mailbox_count': 0L,
    'mailboxes': [],
    'mailbox_rules': {},
    'mailrule_count': 1L,
    'messages': [],
    'no_domains': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
    'single_kunde': True,
    'too_many_domains': False,
    'too_many_mailboxes': False,
    'too_many_rules': False,
    'user': '<User: checkts>'})

def test_create_mailbox():
    # --------------------------------------------------------------------
    # GET /mailadmin/create-mailbox/sluka/
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # POST /mailadmin/create-mailbox/sluka/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': ['checkts.net'],
    'mailrule.0.quelle_localpart': ['adalbert'],
    'name': ['Adalbert'],
    'pass_field': ['aba'],
    'password_confirmal': ['aba']})
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(''),
    'location': '/mailadmin/mailbox/slu1/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox/slu1/
    response, context = runner.get_response('/mailadmin/mailbox/slu1/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'adalbert',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'Adalbert',
                        'user': 'slu1'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: slu1, Adalbert>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

def test_edit_mailbox():
    # --------------------------------------------------------------------
    # POST /mailadmin/mailbox/slu1/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': ['checkts.net'],
    'mailrule.0.quelle_localpart': ['adalbert'],
    'mailrule.1.quelle_domain': ['unf.ug'],
    'mailrule.1.quelle_localpart': ['adalbert'],
    'name': ['Adalbert'],
    'name_display': ['slu1'],
    'pass_field': [''],
    'password_confirmal': ['']})
    response, context = runner.get_response('/mailadmin/mailbox/slu1/', 'POST', GET, POST)
    assert runner.check_response(response, {'status_code': 302, 'cookies': SimpleCookie(''), 'location': '.'})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox/slu1/
    response, context = runner.get_response('/mailadmin/mailbox/slu1/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'adalbert',
                        'mailrule.0.quelle_subdomain': '',
                        'mailrule.1.quelle_domain': 'unf.ug',
                        'mailrule.1.quelle_localpart': 'adalbert',
                        'mailrule.1.quelle_subdomain': '',
                        'name': 'Adalbert',
                        'user': 'slu1'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: slu1, Adalbert>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # GET /mailadmin/portal/
    response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'domain_title': None,
    'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
    'domains': [],
    'get_new_mailbox_url': 'create-mailbox/',
    'kunden': ['<Kunde: sluka>'],
    'kunden_name': 'sluka',
    'mailbox_count': 1L,
    'mailboxes': ['<Person: slu1, Adalbert>'],
    'mailbox_rules': {'slu1': ['<Mailrule: (virt) adalbert@checkts.net -> slu1>', '<Mailrule: (virt) adalbert@unf.ug -> slu1>']},
    'mailrule_count': 3L,
    'messages': [],
    'no_domains': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
            '<Mailrule: (virt) adalbert@checkts.net -> slu1>',
            '<Mailrule: (virt) adalbert@unf.ug -> slu1>'],
    'single_kunde': True,
    'too_many_domains': False,
    'too_many_mailboxes': False,
    'too_many_rules': False,
    'user': '<User: checkts>'})

def test_create_mailbox_berta():
    # --------------------------------------------------------------------
    # GET /mailadmin/create-mailbox/sluka/
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # POST /mailadmin/create-mailbox/sluka/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': ['checkts.net'],
    'mailrule.0.quelle_localpart': ['berta'],
    'name': ['Berta'],
    'pass_field': ['ada'],
    'password_confirmal': ['ada']})
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(''),
    'location': '/mailadmin/mailbox/slu2/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox/slu2/
    response, context = runner.get_response('/mailadmin/mailbox/slu2/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'berta',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'Berta',
                        'user': 'slu2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: slu2, Berta>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # POST /mailadmin/mailbox/slu2/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': ['checkts.net'],
    'mailrule.0.quelle_localpart': ['berta'],
    'mailrule.1.quelle_domain': ['unf.ug'],
    'mailrule.1.quelle_localpart': ['bertadel'],
    'name': ['Berta'],
    'name_display': ['slu2'],
    'pass_field': [''],
    'password_confirmal': ['']})
    response, context = runner.get_response('/mailadmin/mailbox/slu2/', 'POST', GET, POST)
    assert runner.check_response(response, {'status_code': 302, 'cookies': SimpleCookie(''), 'location': '.'})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox/slu2/
    response, context = runner.get_response('/mailadmin/mailbox/slu2/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'berta',
                        'mailrule.0.quelle_subdomain': '',
                        'mailrule.1.quelle_domain': 'unf.ug',
                        'mailrule.1.quelle_localpart': 'bertadel',
                        'mailrule.1.quelle_subdomain': '',
                        'name': 'Berta',
                        'user': 'slu2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: slu2, Berta>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # POST /mailadmin/mailbox/slu2/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': ['checkts.net'],
    'mailrule.0.quelle_localpart': ['berta'],
    'mailrule.1.check_remove': ['on'],
    'mailrule.1.quelle_domain': ['unf.ug'],
    'mailrule.1.quelle_localpart': ['bertadel'],
    'mailrule.2.quelle_domain': [''],
    'mailrule.2.quelle_localpart': [''],
    'name': ['Berta'],
    'name_display': ['slu2'],
    'pass_field': [''],
    'password_confirmal': ['']})
    response, context = runner.get_response('/mailadmin/mailbox/slu2/', 'POST', GET, POST)
    assert runner.check_response(response, {'status_code': 302, 'cookies': SimpleCookie(''), 'location': '.'})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox/slu2/
    response, context = runner.get_response('/mailadmin/mailbox/slu2/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context,
        {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'berta',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'Berta',
                        'user': 'slu2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: slu2, Berta>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # GET /mailadmin/portal/
    response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'domain_title': None,
    'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
    'domains': [],
    'get_new_mailbox_url': 'create-mailbox/',
    'kunden': ['<Kunde: sluka>'],
    'kunden_name': 'sluka',
    'mailbox_count': 2L,
    'mailboxes': ['<Person: slu1, Adalbert>', '<Person: slu2, Berta>'],
    'mailbox_rules': {'slu2': ['<Mailrule: (virt) berta@checkts.net -> slu2>'], 'slu1': ['<Mailrule: (virt) adalbert@checkts.net -> slu1>', '<Mailrule: (virt) adalbert@unf.ug -> slu1>']},
    'mailrule_count': 4L,
    'messages': [],
    'no_domains': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>',
            '<Mailrule: (virt) adalbert@checkts.net -> slu1>',
            '<Mailrule: (virt) berta@checkts.net -> slu2>',
            '<Mailrule: (virt) adalbert@unf.ug -> slu1>'],
    'single_kunde': True,
    'too_many_domains': False,
    'too_many_mailboxes': False,
    'too_many_rules': False,
    'user': '<User: checkts>'})

def test_search_mailbox():
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox-qsearch/
    GET = MultiValueDict({'search': ['ada'], 'kunde': ['sluka']})
    POST = MultiValueDict({})
    response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': MultiValueDict({'search': ['ada'], 'kunde': ['sluka']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
    'kunden_name': 'sluka',
    'mailboxes': ['<Person: slu1, Adalbert>'],
    'mailbox_rules': {'slu1': ['<Mailrule: (virt) adalbert@checkts.net -> slu1>', '<Mailrule: (virt) adalbert@unf.ug -> slu1>']},
    'messages': [],
    'noquery': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'search_params': 'search=ada&kunde=sluka',
    'user': '<User: checkts>'})
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox-qsearch/
    GET = MultiValueDict({'search': ['bert'], 'kunde': ['']})
    POST = MultiValueDict({})
    response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': MultiValueDict({'search': ['bert'], 'kunde': ['']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
    'mailboxes': ['<Person: slu1, Adalbert>', '<Person: slu2, Berta>'],
    'mailbox_rules': {'slu2': ['<Mailrule: (virt) berta@checkts.net -> slu2>'], 'slu1': ['<Mailrule: (virt) adalbert@checkts.net -> slu1>', '<Mailrule: (virt) adalbert@unf.ug -> slu1>']},
    'messages': [],
    'noquery': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'search_params': 'search=bert&kunde=',
    'user': '<User: checkts>'})
    assert runner.body_without(response, 'Keine E-Mail')
    # --------------------------------------------------------------------
    # GET /mailadmin/mailbox-qsearch/
    GET = MultiValueDict({'search': [''], 'kunde': ['']})
    POST = MultiValueDict({})
    response, context = runner.get_response('/mailadmin/mailbox-qsearch/', 'GET', GET, POST)
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': MultiValueDict({'search': [''], 'kunde': ['']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
    'mailboxes': ['<Person: slu1, Adalbert>', '<Person: slu2, Berta>'],
    'mailbox_rules': {'slu2': ['<Mailrule: (virt) berta@checkts.net -> slu2>'], 'slu1': ['<Mailrule: (virt) adalbert@checkts.net -> slu1>', '<Mailrule: (virt) adalbert@unf.ug -> slu1>']},
    'messages': [],
    'noquery': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'search_params': 'search=&kunde=',
    'user': '<User: checkts>'})
