# -*- encoding: UTF-8 -*-

"""
Testet das Verhalten von Mailboxen, wenn noch ein anderer Personeneintrag da ist, und ob das Setzen des Mailflags funktioniert.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import testclasses, base_setup

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)


class TestAsStaff(testclasses.AsStaff):
    def test_create_sluka(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['Martin Sluka'],
        'pass_field': ['s'],
        'password_confirmal': ['s'],
        'user': ['sluka']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/sluka/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/sluka/
        response, context = runner.get_response('/mailadmin/mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht über andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                    'Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                  'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'name': 'Martin Sluka',
                        'user': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: sluka, Martin Sluka>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

    def test_exists_for_same_customer(self):
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['a'],
        'pass_field': ['a'],
        'password_confirmal': ['a'],
        'user': ['sluka']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': [''], 'pass_field': ['a'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'user': ['sluka'], 'password_confirmal': ['a'], 'name': ['a'], 'force_create':[False]}),
                'edit_inline': True,
                'error_dict': {'user': ["Ein Postfach mit dem Benutzernamen 'sluka' besteht bereits."]},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

    def test_exists_for_other_customer(self):
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['Martin Sluka'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['checkts']})
        response, context = runner.get_response('/mailadmin/mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht über andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                    'Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                  'pass_field': ['Das Passwort ist recht kurz.']},
                'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': [''], 'pass_field': [''], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'user': ['checkts'], 'password_confirmal': [''], 'name': ['Martin Sluka'], 'force_create':[False]}),
                'edit_inline': True,
                'error_dict': {'user': ["Der Benutzername 'checkts' ist f\xc3\xbcr einen anderen Kunden belegt."]},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: sluka, Martin Sluka>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

    def test_remove_sluka(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/delete-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/delete-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'kunden_name': 'sluka',
        'mailbox': '<Person: sluka, Martin Sluka>',
        'mailbox_is_deleteable': True,
        'mailrules': [],
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/delete-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/delete-mailbox/sluka/', 'POST', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/sluka/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/sluka/
        response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailbox_rules': {},
        'mailboxes': [],
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_exists_without_mail_flag(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['la'],
        'pass_field': ['a'],
        'password_confirmal': ['a'],
        'user': ['sluka']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': [''], 'pass_field': ['a'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'user': ['sluka'], 'password_confirmal': ['a'], 'name': ['la'], 'force_create':[False]}),
                'edit_inline': True,
                'error_dict': {'user': ['Es gibt bereits einen Personeneintrag f\xc3\xbcr den Benutzernamen \'sluka\', allerdings ohne Mailflag. Entweder nehmen Sie einen anderen Benutzernamen, oder Sie <a href="/mailadmin/set-mailflag/sluka">setzen das Mailflag f\xc3\xbcr diesen Personeneintrag</a>']},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

    def test_set_mailflag(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/set-mailflag/sluka/
        response, context = runner.get_response('/mailadmin/set-mailflag/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht über andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                    'Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                  'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'name': 'Martin Sluka',
                        'user': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/set-mailflag/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'], 'user': ['sluka'], 'name': ['Martin Sluka']})
        response, context = runner.get_response('/mailadmin/set-mailflag/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/sluka/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/sluka/
        response, context = runner.get_response('/mailadmin/mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht über andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                    'Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                  'pass_field': ['Das Passwort ist recht kurz.']},
                'data': {'kunden_name': 'sluka',
                        'name': 'Martin Sluka',
                        'user': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: sluka, Martin Sluka>',
        'person': '<Person: checkts, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Groß- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})

    def test_delete_sluka_again(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/delete-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/delete-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'kunden_name': 'sluka',
        'mailbox': '<Person: sluka, Martin Sluka>',
        'mailbox_is_deleteable': True,
        'mailrules': [],
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/delete-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/delete-mailbox/sluka/', 'POST', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/sluka/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/sluka/
        response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailbox_rules': {},
        'mailboxes': [],
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})

    def test_create_sluka_as_test(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/test/
        response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'test'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Groß- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/test/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['test'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['a'],
        'pass_field': ['a'],
        'password_confirmal': ['a'],
        'user': ['sluka']})
        response, context = runner.get_response('/mailadmin/create-mailbox/test/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
                'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['test'], 'mailrule.0.quelle_localpart': [''], 'pass_field': ['a'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'user': ['sluka'], 'password_confirmal': ['a'], 'name': ['a'], 'force_create':[False]}),
                'edit_inline': True,
                'error_dict': {'user': ["Der Benutzername 'sluka' ist f\xc3\xbcr einen anderen Kunden belegt."]},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Groß- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: checkts>'})
