 #-*- encoding: UTF-8 -*-

"""
Testet /mailadmin/portal in allen Varianten.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.popkern.navigation import navi_url

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)

def test_initial_portal():
    """Modul-Initialisierung aus dem ersten eigentlichen Testcase raushalten"""
    from kundebunt.popkern.models import Person, Kunde, Domainkunde, Mailrule
    from kundebunt.popkern import updatelog
    # --------------------------------------------------------------------
    # GET /mailadmin/portal/
    response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'domain_title': None,
    'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
    'domains': [],
    'get_new_mailbox_url': 'create-mailbox/',
    'kunden': ['<Kunde: sluka>'],
    'kunden_name': 'sluka',
    'mailbox_count': 0L,
    'mailboxes': [],
    'mailbox_rules': {},
    'mailrule_count': 1L,
    'messages': [],
    'no_domains': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
    'single_kunde': True,
    'too_many_domains': False,
    'too_many_mailboxes': False,
    'too_many_rules': False,
    'user': '<User: checkts>'})

def test_k1p0r1():
    """Kunde ohne Unterkunde, keine Postfächer, eine Weiterleitungsregel"""
    # --------------------------------------------------------------------
    # GET /mailadmin/portal/
    from kundebunt.popkern.models import Person, Kunde, Domainkunde, Mailrule
    from kundebunt.popkern import updatelog
    response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'domain_title': None,
    'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
    'domains': [],
    'get_new_mailbox_url': 'create-mailbox/',
    'kunden': ['<Kunde: sluka>'],
    'kunden_name': 'sluka',
    'mailbox_count': 0L,
    'mailboxes': [],
    'mailbox_rules': {},
    'mailrule_count': 1L,
    'messages': [],
    'no_domains': False,
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
    'single_kunde': True,
    'too_many_domains': False,
    'too_many_mailboxes': False,
    'too_many_rules': False,
    'user': '<User: checkts>'})
    assert runner.body_contains(response, 'Kein Postfach gefunden')
    assert runner.body_contains(response, 'mx.sluka.de')
    context.update({'kunden_name': 'sluka'})
    assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
    assert runner.body_without(response, '<h1>Kunden')

class TestNoCustomers(testclasses.WithoutCustomers):
    def test_kunde_no_customers(self):
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 403})

class TestNoDomain(testclasses.WithoutDomains):
    def test_no_domain(self):
        """Kunde ohne Domain"""
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': True,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Ihrem Account wurden keine Domains zugeordnet')

class TestManyMailboxesK1(testclasses.WithManyMailboxes):
    def test_many_mailboxes_k1(self):
        """Kunde mit vielen Mailboxen"""
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 100L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': True,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Alle 100 Postfächer auflisten')
        assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailbox_qsearch', context, True))

class TestNoRulesK1(testclasses.WithoutRules):
    def test_no_rules_k1(self):
        """Kunde ohne Weiterleitungsregeln"""
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 0L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Keine Verarbeitungsregel gefunden.')
        assert runner.body_without_link(response, navi_url('mailadmin.mailrule_qsearch', context, add_default_context=True))
        assert runner.body_without_link(response, navi_url('mailadmin.mailrule_search', context, add_default_context=True))

class TestManyRulesK1(testclasses.WithManyRules):
    def test_many_rules_k1(self):
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': 'Domains',
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': ['<Domainkunde: checkts.net>', '<Domainkunde: unf.ug>'],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 101L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': True,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Alle 101 Regeln auflisten')
        assert runner.body_contains(response, 'action="/mailadmin/mailrule-qsearch/')
        assert runner.body_contains_link(response, '%s?kunde=sluka&amp;noquery=1' % navi_url('mailadmin.mailrule_search', context, True))
        assert runner.body_contains(response,'<h1>Domains')
        assert runner.body_contains_link(response,'%s?kunde=sluka&amp;field=any&amp;domain_mode=equals&amp;domain_text=checkts.net#results'
                                           % navi_url('mailadmin.mailrule_search', context, True))

    class TestManyRulesManyDomainsK1(testclasses.WithManyDomains):
        def test_many_rules_many_domains_k1(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>'],
            'kunden_name': 'sluka',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 101L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': True,
            'too_many_mailboxes': False,
            'too_many_rules': True,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, 'Alle 101 Regeln auflisten')
            assert runner.body_contains(response, 'action="/mailadmin/mailrule-qsearch/')
            assert runner.body_contains_link(response, '%s?kunde=sluka&amp;noquery=1' % navi_url('mailadmin.mailrule_search', context, True))
            assert runner.body_without(response,'<h1>Domains')
            assert runner.body_without_link(response,'%s?kunde=sluka&amp;domain_select=checkts.net#results'
                                            % navi_url('mailadmin.mailrule_qsearch', context, True))

    class TestManyRulesNoDomainsK1(testclasses.WithoutDomains):
        def test_many_rules_no_domains_k1(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': 'Domains',
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>'],
            'kunden_name': 'sluka',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 101L,
            'messages': [],
            'no_domains': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': True,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, 'Alle 101 Regeln auflisten')
            assert runner.body_contains(response, 'action="/mailadmin/mailrule-qsearch/')
            assert runner.body_contains_link(response, '%s?kunde=sluka&amp;noquery=1' % navi_url('mailadmin.mailrule_search', context, True))
            assert runner.body_without(response,'<h1>Domains')
            assert runner.body_without_link(response,'%s?kunde=sluka&amp;domain_select=checkts.net#results'
                                            % navi_url('mailadmin.mailrule_qsearch', context, True))
            assert runner.body_contains(response, 'Ihrem Account wurden keine Domains zugeordnet')

class TestMultipleCustomers(testclasses.WithMultipleCustomers):
    def test_k3p0m1(self):
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': False,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Kein Postfach gefunden')
        assert runner.body_contains(response, 'mx.sluka.de')
        assert runner.body_contains(response, '<h1>Kunden')
        context.update({'kunden_name': 'wally'})
        assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
        assert runner.body_contains_link(response, navi_url('mailadmin.create_mailrule', context, True))
        assert runner.body_contains_link(response, navi_url('mailadmin.portal', context, True))

        # --------------------------------------------------------------------
        # GET /mailadmin/portal/wally/
        response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: wally>'],
        'kunden_name': 'wally',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 0L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, 'Kein Postfach gefunden')
        assert runner.body_without(response, 'mx.sluka.de')
        context.update({'kunden_name': 'wally'})
        assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
        assert runner.body_without(response, '<h1>Kunden')

    class TestManyMailboxesK3(testclasses.WithManyMailboxes):
        def test_many_mailboxes_k3(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>', '<Kunde: test>', '<Kunde: wally>'],
            'mailbox_count': 100L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 1L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
            'single_kunde': False,
            'too_many_domains': False,
            'too_many_mailboxes': True,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, 'Alle 100 Postfächer auflisten')
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailbox_qsearch', context, True))
            assert runner.body_contains(response, 'mx.sluka.de')
            assert runner.body_contains(response, '<h1>Kunden')
            context.update({'kunden_name': 'wally'})
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailrule', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.portal', context, True))

            # --------------------------------------------------------------------
            # GET /mailadmin/portal/sluka/
            response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>'],
            'kunden_name': 'sluka',
            'mailbox_count': 100L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 1L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': True,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, 'Alle 100 Postfächer auflisten')
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailbox_qsearch', context, True))
            assert runner.body_contains(response, 'mx.sluka.de')
            context.update({'kunden_name': 'sluka'})
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
            assert runner.body_without(response, '<h1>Kunden')

class TestStaff(testclasses.AsStaff):
    def test_staff_k1p0m0(self):
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'kunden_name': None,
        'mailbox_rules': {},
        'mailboxes': [],
        'messages': [],
        'noquery': True,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'search_params': '',
        'user': '<User: checkts>'})

    class TestStaffNoCustomers(testclasses.WithoutCustomers):
        def test_staff_no_customers(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 403})


    class TestStaffMultipleCustomers(testclasses.WithMultipleCustomers):
        def test_s3p0m1(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({}),
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/sluka/
            response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: sluka>'],
            'kunden_name': 'sluka',
            'mailbox_count': 0L,
            'mailboxes': [],
            'mailbox_rules': {},
            'mailrule_count': 1L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, "<h1>Andere Kunden")
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.kunde_qsearch', context, True))
            assert runner.body_contains(response, '<h1>Postfächer für sluka')
            context.update({'kunden_name': 'sluka'})
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailbox_qsearch', context, True))
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailrule_qsearch', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailrule', context, True))
            assert runner.body_contains_link(response, "%s?kunde=sluka&amp;noquery=1" % navi_url('mailadmin.mailrule_search', context, True))
            assert runner.body_contains(response, 'Kein Postfach gefunden')
            assert runner.body_contains(response, 'mx.sluka.de')
            assert runner.body_without(response, '<h1>Kunden')
            assert runner.body_without(response, 'wally')
            assert runner.body_without(response, 'Ihrem Account wurden keine Domains zugeordnet')

            # --------------------------------------------------------------------
            # GET /mailadmin/customer-qsearch/
            GET = MultiValueDict({'cust_search': ['POP'], 'quick':[1]})
            POST = MultiValueDict({})
            response, context = runner.get_response('/mailadmin/customer-qsearch/', 'GET', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(''),
            'location': '/mailadmin/portal/POP/',
            'status_code': 302})

            # --------------------------------------------------------------------
            # GET /mailadmin/portal/POP/
            response, context = runner.get_response('/mailadmin/portal/POP/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'domain_title': None,
            'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
            'domains': [],
            'get_new_mailbox_url': 'create-mailbox/',
            'kunden': ['<Kunde: POP>'],
            'kunden_name': 'POP',
            'mailbox_count': 1L,
            'mailboxes': ['<Person: fany, Herr Martin H. Sluka>'],
            'mailbox_rules': {},
            'mailrule_count': 0L,
            'messages': [],
            'no_domains': False,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'rules': [],
            'single_kunde': True,
            'too_many_domains': False,
            'too_many_mailboxes': False,
            'too_many_rules': False,
            'user': '<User: checkts>'})
            assert runner.body_contains(response, "<h1>Andere Kunden")
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.kunde_qsearch', context, True))
            assert runner.body_contains(response, '<h1>Postfächer für POP')
            context.update({'kunden_name': 'POP'})
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailbox_qsearch', context, True))
            assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.mailrule_qsearch', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
            assert runner.body_contains_link(response, navi_url('mailadmin.create_mailrule', context, True))
            assert runner.body_contains_link(response, "%s?kunde=POP&amp;noquery=1" % navi_url('mailadmin.mailrule_search', context, True))
            assert runner.body_without(response, 'Kein Postfach gefunden')
            assert runner.body_contains(response, 'Keine E-Mail-Adresse vergeben')
            context.update({"mailbox_name": "fany"})
            assert runner.body_contains_link(response, navi_url('mailadmin.edit_mailbox', context, True))
            assert runner.body_without(response, 'mx.sluka.de')
            assert runner.body_contains(response, 'Keine Verarbeitungsregel gefunden')
            assert runner.body_without(response, '<h1>Kunden')
            assert runner.body_without(response, 'wally')
            assert runner.body_without(response, 'Ihrem Account wurden keine Domains zugeordnet')


    def test_staff_kundensuche_wally(self):
        """--> Zeigt nur den einen Kunden wally an und geht direkt in Portalansicht"""
        # GET /mailadmin/customer-qsearch/
        GET = MultiValueDict({'cust_search': ['wally'], 'quick':[1]})
        POST = MultiValueDict({})
        response, context = runner.get_response('/mailadmin/customer-qsearch/', 'GET', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/wally/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/wally/
        response, context = runner.get_response('/mailadmin/portal/wally/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: wally>'],
        'kunden_name': 'wally',
        'mailbox_count': 0L,
        'mailboxes': [],
        'mailbox_rules': {},
        'mailrule_count': 0L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: checkts, Herr Martin H. Sluka>',
        'rules': [],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: checkts>'})
        assert runner.body_contains(response, "<h1>Andere Kunden")
        assert runner.body_contains(response, 'action="%s' % navi_url('mailadmin.kunde_qsearch', context, True))
        assert runner.body_contains(response, 'Kein Postfach gefunden')
        assert runner.body_without(response, 'mx.sluka.de')
        context.update({'kunden_name': 'wally'})
        assert runner.body_contains_link(response, navi_url('mailadmin.create_mailbox', context, True))
        assert runner.body_without(response, '<h1>Kunden')
        assert runner.body_contains(response, "<h1>Postfächer für wally")
        assert runner.body_without(response, "sluka")
        assert runner.body_contains(response, "Keine Verarbeitungsregel gefunden.")

    class TestNoRulesS1(testclasses.WithoutRules):
        def test_no_rules_s1(self):
            """Staff ohne Weiterleitungsregeln"""
            # --------------------------------------------------------------------
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({}),
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})

    class TestManyRulesS1(testclasses.WithManyRules):
        def test_many_rules_s1(self):
            # GET /mailadmin/portal/
            response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
            assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({}),
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
            'kunden_name': None,
            'mailbox_rules': {},
            'mailboxes': [],
            'messages': [],
            'noquery': True,
            'person': '<Person: checkts, Herr Martin H. Sluka>',
            'search_params': '',
            'user': '<User: checkts>'})
        class TestManyRulesManyDomainsS1(testclasses.WithManyDomains):
            def test_many_rules_many_domains_s1(self):
                # GET /mailadmin/portal/
                response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
                assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
                assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                        'advisory_dict': {},
                        'data': MultiValueDict({}),
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
                'kunden_name': None,
                'mailbox_rules': {},
                'mailboxes': [],
                'messages': [],
                'noquery': True,
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'search_params': '',
                'user': '<User: checkts>'})

        class TestManyRulesNoDomainsS1(testclasses.WithoutDomains):
            def test_many_rules_no_domains_s1(self):
                # GET /mailadmin/portal/
                response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
                assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
                assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                        'advisory_dict': {},
                        'data': MultiValueDict({}),
                        'edit_inline': True,
                        'error_dict': {},
                        'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
                'kunden_name': None,
                'mailbox_rules': {},
                'mailboxes': [],
                'messages': [],
                'noquery': True,
                'person': '<Person: checkts, Herr Martin H. Sluka>',
                'search_params': '',
                'user': '<User: checkts>'})