# -*- encoding: UTF-8 -*-

"""
Testet das Setzen und die Überprüfung von person.email bei Mailboxen in allen Varianten
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import testclasses, base_setup

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)

class TestAsFany(testclasses.AsFany):

    @staticmethod
    def get_runner():
        return runner

    def test_create_null_email(self):
        """Anlegen einer Mailbox ohne Adressen. person.email ist Null.
        """
        from kundebunt.popkern import models
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'force_create': ['on'],
        'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': [''],
        'name': ['a1'],
        'pass_field': ['aaaaaa'],
        'password_confirmal': ['aaaaaa'],
        'user': ['a1']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a1/
        response, context = runner.get_response('/mailadmin/mailbox/a1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es sind keine E-Mail-Adressen angegeben. Wenn dieses Postfach nicht \xc3\xbcber andere Regeln angesprochen wird, kann es keine E-Mail empfangen.',
                    'Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.']},
                'data': {'kunden_name': 'sluka', 'name': 'a1', 'user': 'a1'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: a1, a1>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a1'],
        'name': ['a1'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a1']})
        response, context = runner.get_response('/mailadmin/mailbox/a1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a1/
        response, context = runner.get_response('/mailadmin/mailbox/a1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a1',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a1',
                        'user': 'a1'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a1, a1>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        assert models.Person.objects.get(user='a1').email == None

    def test_create_a2(self):
        """Normale Mailbox."""
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/sluka/
        from kundebunt.popkern import models
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'force_create': ['on'],
        'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a2'],
        'name': ['a2'],
        'pass_field': ['aaaaaa'],
        'password_confirmal': ['aaaaaa'],
        'user': ['a2']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a2/',
        'status_code': 302})
        assert models.Person.objects.get(user='a2').email=='a2@checkts.net'
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a2',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
    def test_create_a3(self):
        """Normale Mailbox, a3
        """
        # --------------------------------------------------------------------
        # GET /mailadmin/create-mailbox/sluka/
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'force_create': ['on'],
        'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a3'],
        'name': ['a3'],
        'pass_field': ['aaaaaa'],
        'password_confirmal': ['aaaaaa'],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a3',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_domain_rule_ok(self):
        """a3 auf domain rule setzen, alles OK.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_domain_vs_normal(self):
        """a2 nimmt nun a3 mit einer normalen Regel weg.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a2/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a2'],
        'mailrule.1.quelle_domain': ['checkts.net'],
        'mailrule.1.quelle_localpart': ['a3'],
        'name': ['a2'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a2']})
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a2/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a2',
                        'mailrule.0.quelle_subdomain': '',
                        'mailrule.1.quelle_domain': 'checkts.net',
                        'mailrule.1.quelle_localpart': 'a3',
                        'mailrule.1.quelle_subdomain': '',
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': [Ellipsis]},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_wildcard_vs_domain(self):
        """a2 wird nun nur per wilcard-Regel gefüttert.
        Die Domain-Regel in a3 hat Vorrang.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a2/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['*'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.1.check_remove': ['on'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.2.quelle_domain': [''],
        'mailrule.2.quelle_localpart': [''],
        'name': ['a2'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a2']})
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a2/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a2@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': '*',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': None,
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_wildcard_ok(self):
        """Domain-Regel von a3 wegnehmen, dann ist a2 in Ordnung.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a3'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a3',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': '*',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': None,
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_wildcard_vs_normal(self):
        """a3 nimmt nun die Adresse von a2 mit einer direkten Regel weg.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a2'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a3@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a2',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a2@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': '*',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': None,
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_create_a4(self):
        """a4 mit einer Subdomain-Adresse anlegen.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'force_create': ['on'],
        'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['sub.bla.checkts.net'],
        'mailrule.0.quelle_localpart': ['a4'],
        'name': ['a4'],
        'pass_field': ['aaaaaa'],
        'password_confirmal': ['aaaaaa'],
        'user': ['a4']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a4/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrule.0.quelle_domain': ['sub.bla.checkts.net: Die angegebene Domain ist im DNS nicht vorhanden.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a4',
                        'mailrule.0.quelle_subdomain': 'sub.bla',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_subdomain_ok(self):
        """a4 nun über eine Subdomain.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a4/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': ['*'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a4'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a4']})
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a4/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_subdomain_vs_subdomain(self):
        """a3 nun mit einer spezifischeren Subdomain-Regel, die Vorrang hat.
        a4 also mit Warnung.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['*.bla.checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrule.0.quelle_domain': ['bla.checkts.net: Die angegebene Domain ist im DNS nicht vorhanden.'],
                                    'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a3@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*.bla',
                        'mailrules_have_subdomains': True,
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a4@sub.bla.checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_subdomain_vs_domain(self):
        """In a3 wird nun die Regel geändert, so dass sie auf die Domain von a4
        passt. a4 wieder mit Warnung.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': ['sub.bla'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrule.0.quelle_domain': ['sub.bla.checkts.net: Die angegebene Domain ist im DNS nicht vorhanden.'],
                                    'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a3@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': 'sub.bla',
                        'mailrules_have_subdomains': True,
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a4@sub.bla.checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_subdomain_vs_nonmatch_subdomain(self):
        """Die Regel von a3 wird nun in eine Subdomain-Regel geändert, die auf diese
        Adresse von a4 gerade eben nicht mehr passt. a4 also wieder in Ordnung.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': ['*.sub.bla'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a3/
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrule.0.quelle_domain': ['sub.bla.checkts.net: Die angegebene Domain ist im DNS nicht vorhanden.'],
                                    'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a3@checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*.sub.bla',
                        'mailrules_have_subdomains': True,
                        'name': 'a3',
                        'user': 'a3'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a3, a3>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_subdomain_vs_lower_subdomain(self):
        """Die Mail-Regel von a3 nun durch eine Subdomain-Regel ersetzen, die zwar
        auf die Adresse von a4 passt, die aber unspezifischer ist. a4 also in Ordnung
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a4/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': ['*.bla'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a4'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a4']})
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a4/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': ['*'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrule.0.quelle_domain': ['bla.checkts.net: Die angegebene Domain ist im DNS nicht vorhanden.']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': '*.bla',
                        'mailrules_have_subdomains': True,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.', 'Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})

    def test_wildcard_for_subdomains(self):
        """Wildcard-Regeln passen nicht auf Subdomains von Kundendomains.
        """
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a2/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['a2'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['a2'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a2']})
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a2/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a2/
        response, context = runner.get_response('/mailadmin/mailbox/a2/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': 'checkts.net',
                        'mailrule.0.quelle_localpart': 'a2',
                        'mailrule.0.quelle_subdomain': '',
                        'name': 'a2',
                        'user': 'a2'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a2, a2>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['checkts.net'],
        'mailrule.0.quelle_localpart': ['xxxxxx'],
        'mailrule.0.quelle_subdomain': [''],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a3'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a3']})
        response, context = runner.get_response('/mailadmin/mailbox/a3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/a4/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['*'],
        'mailrule.0.quelle_localpart': [''],
        'mailrule.0.quelle_subdomain': [''],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'mailrule.1.quelle_subdomain': [''],
        'name': ['a4'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['a4']})
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/a4/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/a4/
        response, context = runner.get_response('/mailadmin/mailbox/a4/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'mailrules': ['<p>Wenn Sie das Webmail-Interface nutzen:</p>\n\n<p>Dieses Postfach hat die ung\xc3\xbcltige Absender- und Antwortadresse \'a4@sub.bla.checkts.net\':\nEs fehlt die Zuordnung der Adresse ans Postfach, Antworten k\xc3\xb6nnen also nicht empfangen werden.</p>\n\n<p>Um diesem Postfach eine g\xc3\xbcltige Absender- und Antwortadresse zuzuordnen, legen\nSie bitte</p>\n\n<ul><li>eine Weiterleitungsregel f\xc3\xbcr diese Adresse auf das Postfach an, z.B. indem Sie die Adresse unten eintragen,</li>\n<li><em>oder</em> \xc3\xa4ndern Sie die Absenderadresse unter <a href="https://mail.noris.net">https://mail.noris.net</a>,\nindem Sie diese unter folgendem Men\xc3\xbcpunkt eintragen:<br />\nOptionen -> Pers\xc3\xb6nliche Informationen -> E-Mail-Adresse</li>\n<li>Zum Deaktivieren dieser Warnung geben Sie bitte dem <a href="mailto:support@noris.net">Support</a>\nBescheid, dass er noch die Absendeadresse in unserer Datenbank anpasst.</li>\n</ul>\n']},
                'data': {'kunden_name': 'sluka',
                        'mailrule.0.quelle_domain': '*',
                        'mailrule.0.quelle_localpart': '',
                        'mailrule.0.quelle_subdomain': None,
                        'name': 'a4',
                        'user': 'a4'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
        'kunden_name': 'sluka',
        'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.', 'Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
        'object': '<Person: a4, a4>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
        'user': '<User: fany>'})
