# -*- encoding: UTF-8 -*-

"""
Testet Mailboxen in allen Varianten
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import testclasses, base_setup

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)


class TestAsFany(testclasses.AsFany):

    @staticmethod
    def get_runner():
        return runner

    def test_staff_create(self):
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'],
        'name': [''],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {
            'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'], 'pass_field': [''], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': [''], 'mailrule.0.quelle': [None], 'user': [''], 'password_confirmal': [''], 'force_create':[False], 'auto_password': [False]}),
            'edit_inline': True,
            'error_dict': {'mailrule.0.quelle_domain': ['Wenn eine E-Mail-Adresse angegeben ist, bitte auch eine Domain angeben.'],
                         'mailrule.0.quelle_localpart': ['Bitte eine g\xc3\xbcltige E-Mail-Adresse eingeben.'],
                         'name': ['Bitte dieses Feld ausfüllen.'],
                         'pass_field': ['Bitte ein Passwort angeben oder "Automatische Passwortvergabe" ankreuzen.']},
            'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'],
        'name': [''],
        'pass_field': [''],
        'password_confirmal': ['gffg'],
        'user': ['']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {
            'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'], 'pass_field': [''], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': [''], 'mailrule.0.quelle': [None], 'user': [''], 'password_confirmal': ['gffg'], 'force_create':[False], 'auto_password': [False]}),
                'edit_inline': True,
                'error_dict': {'mailrule.0.quelle_domain': ['Wenn eine E-Mail-Adresse angegeben ist, bitte auch eine Domain angeben.'],
                                'mailrule.0.quelle_localpart': ['Bitte eine g\xc3\xbcltige E-Mail-Adresse eingeben.'],
                                'name': ['Bitte dieses Feld ausfüllen.'],
                                'pass_field': ['Bitte ein Passwort angeben oder "Automatische Passwortvergabe" ankreuzen.']},
                'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd'],
        'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': ['wawa'],
        'password_confirmal': [''],
        'user': ['ram\xc3\xa4kama']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd' ist bei noris network nicht registriert (kein Datenbankeintrag).",
                                                                    'asdasd: Die angegebene Domain ist im DNS nicht vorhanden.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': MultiValueDict({'mailrule.0.quelle_domain': ['asdasd'], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['asdasdas\xc3\xa4\xc3\xb6\xc3\xbc'], 'pass_field': ['wawa'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': ['Pieter P\xc3\xa4rr'], 'mailrule.0.quelle': [None], 'user': ['ram\xc3\xa4kama'], 'password_confirmal': [''], 'force_create':[False], 'auto_password': [False]}),
                    'edit_inline': True,
                    'error_dict': {'mailrule.0.quelle_domain': ['Bitte geben Sie hier einen Domain-Namen an. Ein Domain-Name kann nur Buchstaben, Ziffern, "-" und "." enthalten. Außerdem ist "*" ohne weitere Eingaben erlaubt.'],
                                    'mailrule.0.quelle_localpart': ['Bitte eine g\xc3\xbcltige E-Mail-Adresse eingeben.'],
                                    'password_confirmal': ['Bitte das Passwort zur \xc3\x9cberprüfung zus\xc3\xa4tzlich in das Best\xc3\xa4tigungsfeld eingeben.'],
                                    'user': ['Bitte einen Benutzernamen eingeben; ein Benutzername beginnt mit einem Kleinbuchstaben und besteht aus den Zeichen a-z 0-9 - . _. Er kann maximal 64 Zeichen lang sein.']},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': ['asdasdas'],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': ['wawa'],
        'password_confirmal': ['qqqq'],
        'user': ['ram\xc3\xa4kama']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': MultiValueDict({'mailrule.0.quelle_domain': ['asdasd.de'], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['asdasdas'], 'pass_field': ['wawa'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': ['Pieter P\xc3\xa4rr'], 'mailrule.0.quelle': [None], 'user': ['ram\xc3\xa4kama'], 'password_confirmal': ['qqqq'], 'force_create':[False], 'auto_password': [False]}),
                    'edit_inline': True,
                    'error_dict': {'password_confirmal': ['Die beiden Passwort-Eingaben stimmen nicht \xc3\xbcberein.'],
                                    'user': ['Bitte einen Benutzernamen eingeben; ein Benutzername beginnt mit einem Kleinbuchstaben und besteht aus den Zeichen a-z 0-9 - . _. Er kann maximal 64 Zeichen lang sein.']},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': [''],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': ['1234'],
        'password_confirmal': ['1234'],
        'user': ['12345678']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': MultiValueDict({'mailrule.0.quelle_domain': ['asdasd.de'], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': [''], 'pass_field': ['1234'], 'mailrule.0.check_remove': [False], 'mailrule.0.quelle_subdomain': [None], 'name': ['Pieter P\xc3\xa4rr'], 'mailrule.0.quelle': [None], 'user': ['12345678'], 'password_confirmal': ['1234'], 'force_create':[False], 'auto_password': [False]}),
                    'edit_inline': True,
                    'error_dict': {'user': ['Bitte einen Benutzernamen eingeben; ein Benutzername beginnt mit einem Kleinbuchstaben und besteht aus den Zeichen a-z 0-9 - . _. Er kann maximal 64 Zeichen lang sein.']},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': [''],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': ['1234'],
        'password_confirmal': ['1234'],
        'user': ['abcd12345']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/abcd12345/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'asdasd.de',
                            'mailrule.0.quelle_localpart': '',
                            'mailrule.0.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.'],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

    def test_staff_edit(self):
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/abcd12345/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': ['postmaster'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['abcd12345']})
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/abcd12345/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'asdasd.de',
                            'mailrule.0.quelle_localpart': 'postmaster',
                            'mailrule.0.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345',},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/abcd12345/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': ['postmaster'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': [''],
        'pass_field': ['a'],
        'password_confirmal': [''],
        'user': ['']})
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.'],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],},
                    'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['postmaster'], 'pass_field': ['a'], 'mailrule.0.check_remove': [False], 'mailrule.1.quelle_localpart': [''], 'mailrule.1.quelle': [None], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'mailrule.1.quelle_subdomain': [None], 'mailrule.1.quelle_domain': [''], 'password_confirmal': [''], 'user': [''], 'mailrule.1.check_remove': [False], 'name': [''], 'force_create':[False], 'force_create':[False], 'auto_password': [False]}),
                    'edit_inline': True,
                    'error_dict': {'mailrule.0.quelle_domain': ['Bitte dieses Feld ausfüllen.'],
                                    'name': ['Bitte dieses Feld ausfüllen.'],
                                    'password_confirmal': ['Bitte das Passwort zur \xc3\x9cberprüfung zus\xc3\xa4tzlich in das Best\xc3\xa4tigungsfeld eingeben.'],
                                    'user': ['Bitte dieses Feld ausfüllen.']},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': [],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/abcd12345/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.check_remove': ['on'],
        'mailrule.0.quelle_domain': [''],
        'mailrule.0.quelle_localpart': ['postmaster'],
        'mailrule.1.quelle_domain': [''],
        'mailrule.1.quelle_localpart': [''],
        'name': [''],
        'pass_field': ['a'],
        'password_confirmal': [''],
        'user': ['']})
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'POST', GET, POST)
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.'],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],},
                    'data': MultiValueDict({'mailrule.0.quelle_domain': [''], 'kunden_name': ['sluka'], 'mailrule.0.quelle_localpart': ['postmaster'], 'pass_field': ['a'], 'mailrule.0.check_remove': [True], 'mailrule.1.quelle_localpart': [''], 'mailrule.1.quelle': [None], 'mailrule.0.quelle_subdomain': [None], 'mailrule.0.quelle': [None], 'mailrule.1.quelle_subdomain': [None], 'mailrule.1.quelle_domain': [''], 'password_confirmal': [''], 'user': [''], 'mailrule.1.check_remove': [False], 'name': [''], 'force_create':[False], 'auto_password': [False]}),
                    'edit_inline': True,
                    'error_dict': { 'name': ['Bitte dieses Feld ausfüllen.'],
                                    'password_confirmal': ['Bitte das Passwort zur \xc3\x9cberprüfung zus\xc3\xa4tzlich in das Best\xc3\xa4tigungsfeld eingeben.'],
                                    'user': ['Bitte dieses Feld ausfüllen.']},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': [],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'asdasd.de',
                            'mailrule.0.quelle_localpart': 'postmaster',
                            'mailrule.0.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': [],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

        # --------------------------------------------------------------------
        # GET /mailadmin/portal/
        response, context = runner.get_response('/mailadmin/portal/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.search.MailboxQuickSearchForm object>'},
        'kunden_name': None,
        'mailbox_rules': {},
        'mailboxes': [],
        'messages': [],
        'noquery': True,
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'search_params': '',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'asdasd.de',
                            'mailrule.0.quelle_localpart': 'postmaster',
                            'mailrule.0.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': [],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/abcd12345/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': ['postmaster'],
        'mailrule.1.quelle_domain': ['noris.de'],
        'mailrule.1.quelle_localpart': ['rara'],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['abcd12345']})
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/abcd12345/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'asdasd.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrule.1.quelle_domain': ["Die Domain 'noris.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'asdasd.de',
                            'mailrule.0.quelle_localpart': 'postmaster',
                            'mailrule.0.quelle_subdomain': None,
                            'mailrule.1.quelle_domain': 'noris.de',
                            'mailrule.1.quelle_localpart': 'rara',
                            'mailrule.1.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/mailbox/abcd12345/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.check_remove': ['on'],
        'mailrule.0.quelle_domain': ['asdasd.de'],
        'mailrule.0.quelle_localpart': ['postmaster'],
        'mailrule.1.check_remove': ['on'],
        'mailrule.1.quelle_domain': ['noris.de'],
        'mailrule.1.quelle_localpart': ['rara'],
        'mailrule.2.quelle_domain': ['lly.de'],
        'mailrule.2.quelle_localpart': ['kartoffelkartoffel'],
        'name': ['Pieter P\xc3\xa4rr'],
        'pass_field': [''],
        'password_confirmal': [''],
        'user': ['abcd12345']})
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/mailbox/abcd12345/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context,
            {'form': {'_inline_collections': Ellipsis,
                    'advisory_dict': {'mailrule.0.quelle_domain': ["Die Domain 'lly.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."],
                                      'mailrules': ['Es ist noch keine Absenderadresse f\xc3\xbcr das Webmail-Interface konfiguriert.\n\nWenn Sie das Webmail-Interface nutzen m\xc3\xb6chten, tragen Sie bitte die Absenderadresse manuell ein, indem Sie sich mit den Zugangsdaten auf <a href="https://mail.noris.net">https://mail.noris.net</a> anmelden und sie dann unter Optionen / "Pers\xc3\xb6nliche Informationen" / E-Mail-Adresse eingeben.'],
                                      'pass_field': ['Das Passwort ist recht kurz.']},
                    'data': {'kunden_name': 'sluka',
                            'mailrule.0.quelle_domain': 'lly.de',
                            'mailrule.0.quelle_localpart': 'kartoffelkartoffel',
                            'mailrule.0.quelle_subdomain': None,
                            'name': 'Pieter P\xc3\xa4rr',
                            'user': 'abcd12345'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Ihre Eingaben wurden gesichert.'],
            'object': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

    def test_staff_delete(self):
        # --------------------------------------------------------------------
        # GET /mailadmin/delete-mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/delete-mailbox/abcd12345/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'kunden_name': 'sluka',
        'mailbox': '<Person: abcd12345, Pieter P\xc3\xa4rr>',
        'mailbox_is_deleteable': True,
        'mailrules': ['<Mailrule: (virt) kartoffelkartoffel@lly.de -> abcd12345>'],
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailrule/167/
        response, context = runner.get_response('/mailadmin/mailrule/166/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {'quelle_domain': ["Die Domain 'lly.de' ist bei noris network nicht registriert (kein Datenbankeintrag)."]},
                'data': {'form_is_readonly': '',
                        'kunden_name': 'sluka',
                        'quelle_domain': 'lly.de',
                        'quelle_localpart': 'kartoffelkartoffel',
                        'quelle_subdomain': None,
                        'rule_type': 'virt',
                        'virt_ziele': 'abcd12345'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.mailadmin.forms.mailrule2.MailruleChangeManipulator2 object>'},
        'kunden_name': 'sluka',
        'messages': [],
        'object': '<Mailrule: (virt) kartoffelkartoffel@lly.de -> abcd12345>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /mailadmin/delete-mailbox/abcd12345/
        response, context = runner.get_response('/mailadmin/delete-mailbox/abcd12345/', 'POST', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': '/mailadmin/portal/sluka/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /mailadmin/portal/sluka/
        response, context = runner.get_response('/mailadmin/portal/sluka/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {'domain_title': None,
        'cust_search_form': '<kundebunt.mailadmin.forms.search.KundeQuickSearchForm object>',
        'domains': [],
        'get_new_mailbox_url': 'create-mailbox/',
        'kunden': ['<Kunde: sluka>'],
        'kunden_name': 'sluka',
        'mailbox_count': 0L,
        'mailbox_rules': {},
        'mailboxes': [],
        'mailrule_count': 1L,
        'messages': [],
        'no_domains': False,
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rules': ['<Mailrule: (smtp_route_mx) sluka.de -> mx.sluka.de>'],
        'single_kunde': True,
        'too_many_domains': False,
        'too_many_mailboxes': False,
        'too_many_rules': False,
        'user': '<User: fany>'})
