# -*- encoding: utf-8 -*-

from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.tests.fixtures import testclasses, base_setup

runner = None

def setup_module(module):
    global runner
    runner = base_setup.setup_module(module)

class TestAsFany(testclasses.AsFany):
    @staticmethod
    def get_runner():
        return runner

    def test_mailbox_domain(self):
        """Die Domains in einer Mailbox standen fälschlicherweise immer auf der ersten Domain"""
        # --------------------------------------------------------------------
        # POST /mailadmin/create-mailbox/sluka/
        GET = MultiValueDict({})
        POST = MultiValueDict({'kunden_name': ['sluka'],
        'mailrule.0.quelle_domain': ['unf.ug'],
        'mailrule.0.quelle_localpart': ['bla'],
        'name': ['bla bla'],
        'pass_field': ['bla'],
        'password_confirmal': ['bla']})
        response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
        from pprint import pprint
        pprint(context)
        assert runner.check_response(response, {'status_code': 302, 'cookies': SimpleCookie(''), 'location': '/mailadmin/mailbox/slu1/'})
        # --------------------------------------------------------------------
        # GET /mailadmin/mailbox/slu1/
        response, context = runner.get_response('/mailadmin/mailbox/slu1/', 'GET', {}, {})
        assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
        assert runner.check_context(response, context, {
            'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {'pass_field': ['Das Passwort ist recht kurz.']},
            'data': {'kunden_name': 'sluka',
                   'mailrule.0.quelle_domain': 'unf.ug',
                   'mailrule.0.quelle_localpart': 'bla',
                   'mailrule.0.quelle_subdomain': '',
                   'name': 'bla bla',
                   'user': 'slu1'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxChangeManipulator object>'},
            'kunden_name': 'sluka',
            'messages': ['Es kann noch bis zu zehn Minuten dauern, bis die \xc3\x84nderung aktiv wird.', 'Der Datensatz wurde angelegt.', ],
            'new_mailbox_hint': None,
            'object': '<Person: slu1, bla bla>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Gro\xc3\x9f- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',            'user': '<User: fany>'})

    def teardown_mailbox_domain(self):
        models.Person.objects.get(name='bla bla').delete()
