from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from django.test.utils import setup_test_environment
from kundebunt import testutils
from kundebunt.testutils.t_repr import t_repr
from kundebunt.popkern import updatelog
from kundebunt.tests.fixtures import base_setup, testclasses

runner = None

def setup_module(module):
    global runner
    settings.LANGUAGE_CODE='de'
    base_setup.setup_database(always_createdb=False)
    runner = testutils.TestRunner()
    setup_test_environment()

def test_login_empty():
    """Alle Eingabefelder leer"""
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': [''],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {'password': ['Bitte dieses Feld ausfüllen.'],
                            'username': ['Bitte dieses Feld ausfüllen.']},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
    'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
    'internal': False,
    'messages': [],
    'next': '/mailadmin/create-mailbox/sluka/',
    'person': None,
    'releasenotes': Ellipsis,
    'user': '<django.contrib.auth.models.AnonymousUser object>'})

def test_login_empty_password():
    """Beliebiger Benutzer, Passwort leer"""
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': [''],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['abc']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {'password': ['Bitte dieses Feld ausfüllen.'],
                            'username': ['Bitte einen g\xc3\xbcltigen Benutzernamen und ein Passwort eingeben. Beide Felder ber\xc3\xbccksichtigen die Gro\xc3\x9f-/Kleinschreibung.']},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
    'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
    'releasenotes': Ellipsis,
    'internal': False,
    'messages': [],
    'next': '/mailadmin/create-mailbox/sluka/',
    'person': None,
    'user': '<django.contrib.auth.models.AnonymousUser object>'})

def test_login_empty_user():
    """Beliebiges Passwort, Benutzer leer"""
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': ['abc'],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {'username': ['Bitte dieses Feld ausfüllen.']},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
    'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
    'releasenotes': Ellipsis,
    'internal': False,
    'messages': [],
    'next': '/mailadmin/create-mailbox/sluka/',
    'person': None,
    'user': '<django.contrib.auth.models.AnonymousUser object>'})
    # --------------------------------------------------------------------

def test_login_wrong_user():
    """Nicht existierender Benutzername"""
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': ['abc'],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['abc']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {'username': ['Bitte einen g\xc3\xbcltigen Benutzernamen und ein Passwort eingeben. Beide Felder ber\xc3\xbccksichtigen die Gro\xc3\x9f-/Kleinschreibung.']},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
    'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
    'releasenotes': Ellipsis,
    'internal': False,
    'messages': [],
    'next': '/mailadmin/create-mailbox/sluka/',
    'person': None,
    'user': '<django.contrib.auth.models.AnonymousUser object>'})

def test_login_password_case():
    """Richtiges Passwort, aber in Kleinbuchstaben"""
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': ['hidden'],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['checkts']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {'username': ['Bitte einen g\xc3\xbcltigen Benutzernamen und ein Passwort eingeben. Beide Felder ber\xc3\xbccksichtigen die Gro\xc3\x9f-/Kleinschreibung.']},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
    'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
    'releasenotes': Ellipsis,
    'internal': False,
    'messages': [],
    'next': '/mailadmin/create-mailbox/sluka/',
    'person': None,
    'user': '<django.contrib.auth.models.AnonymousUser object>'})

class TestWithoutServiceAssociation(testclasses.WithoutServiceAssociation):
    def test_cannot_login(self):
        # GET vorher noetig, damit der Cookie-Test klappt.
        # --------------------------------------------------------------------
        # GET /auth/login/
        response, context = runner.get_response('/auth/login/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=73389c3b004e96fbe1a1f8761b8d0c86;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': '<django.utils.datastructures.MergeDict object>',
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
        'app_path': '/auth/login/?next=',
        'messages': [],
        'releasenotes': Ellipsis,
        'internal': False,
        'next': '',
        'person': None,
        'user': '<django.contrib.auth.models.AnonymousUser object>'})
        # --------------------------------------------------------------------
        # POST /auth/login/
        GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
        POST = MultiValueDict({'password': ['HIDDEN'],
        'post_data': [''],
        'this_is_the_login_form': ['1'],
        'username': ['checkts']})
        response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
                'advisory_dict': {},
                'data': '<django.utils.datastructures.MergeDict object>',
                'edit_inline': True,
                'error_dict': {'username': ['Bitte einen g\xc3\xbcltigen Benutzernamen und ein Passwort eingeben. Beide Felder ber\xc3\xbccksichtigen die Gro\xc3\x9f-/Kleinschreibung.']},
                'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
        'app_path': '/auth/login/?next=%2Fmailadmin%2Fcreate-mailbox%2Fsluka%2F',
        'releasenotes': Ellipsis,
        'internal': False,
        'messages': [],
        'next': '/mailadmin/create-mailbox/sluka/',
        'person': None,
        'user': '<django.contrib.auth.models.AnonymousUser object>'})

    def test_managed_by(self):
        from kundebunt.popkern.models import Person, Kunde
        checkts = Person.objects.get(user='checkts')
        kunden = Kunde.objects.managed_by(checkts.id)
        assert not kunden.exists()

class TestNoServiceAssociation(TestWithoutServiceAssociation):
    def test_cannot_login(self):
        super(TestNoServiceAssociation,self).test_cannot_login()

def test_login_works():
    """Korrekter Anmeldeversuch"""
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({'next': ['/mailadmin/create-mailbox/sluka/']})
    POST = MultiValueDict({'password': ['HIDDEN'],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': ['checkts']})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'location': '/mailadmin/create-mailbox/sluka/',
    'status_code': 302})

    # --------------------------------------------------------------------
    # GET /mailadmin/create-mailbox/sluka/
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'GET', {}, {})
    assert runner.check_response(response, {'status_code': 200, 'cookies': SimpleCookie('')})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': {'kunden_name': 'sluka'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.mailadmin.forms.mailbox.MailboxAddManipulator object>'},
    'messages': [],
    'person': '<Person: checkts, Herr Martin H. Sluka>',
    'quelle_localpart_help': 'Bei der E-Mail-Adresse wird nicht zwischen Groß- und Kleinschreibung unterschieden. Ist der Teil vor der Domain leer, wird die gesamte Domain weitergeleitet.',
    'user': '<User: checkts>'})

def test_managed_by():
    from kundebunt.popkern.models import Person, Kunde
    checkts = Person.objects.get(user='checkts')
    kunden = Kunde.objects.managed_by(checkts.id)
    assert kunden.exists()

def test_logout():
    # --------------------------------------------------------------------
    # GET /auth/logout/
    response, context = runner.get_response('/auth/logout/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=feb07e272abc85daae92f8c7e372ca09;'),
    'status_code': 200})
    # Anmerkung: Cookies werden aus dem Testbrowser nicht entfernt.
    # --------------------------------------------------------------------
    # POST /mailadmin/create-mailbox/sluka/
    GET = MultiValueDict({})
    POST = MultiValueDict({'kunden_name': ['sluka'],
    'mailrule.0.quelle_domain': [''],
    'mailrule.0.quelle_localpart': [''],
    'name': [''],
    'pass_field': [''],
    'password_confirmal': ['']})
    response, context = runner.get_response('/mailadmin/create-mailbox/sluka/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(''),
    'location': '/auth/login/?next=/mailadmin/create-mailbox/sluka/',
    'status_code': 302})

class TestWithoutServiceAssociationAgain(TestWithoutServiceAssociation):
    """Inzwischen wurde eine auth_user angelegt. Sicherstellen, dass
    Login trotzdem nicht geht, wenn kein Service-Flag gesetzt."""
    def test_cannot_login(self):
        runner.remove_cookies()
        super(TestWithoutServiceAssociationAgain, self).test_cannot_login()



