# -*- encoding: UTF-8 -*-

from pprint import pprint
from Cookie import SimpleCookie
from django.core import management
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.popkern import models
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup

runner = None

def setup_module(module=None):
    global runner, fremde_adresse
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')
    fremde_adresse = models.Adresse.objects.create(id=999, ort="Blahausen", land=models.Land.objects.get(name="Deutschland"))

def test_create_address():
    """Da noch keine Adresse für die Person existiert, muss sie neu angelegt werden.
    """
    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u'N\xfcrnberg'],
    u'pager': [u'5678'],
    u'plz': [u'91000'],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u'Sluka-Weg 5.14'],
    u'timestamp': [u'2003-05-21 11:27'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': u'Deutschland',
                    'name': u'Herr Martin H. Sluka',
                    'ort': u'N\xfcrnberg',
                    'pager': u'5678',
                    'plz': u'91000',
                    'pwuse': u'ftp,www,service',
                    'strasse': u'Sluka-Weg 5.14',
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

def test_delete_address():
    """Alle Adressfelder sind leer, die Adresse muss entfernt werden. Aber nur diese ...
    """
    checkts_adresse = models.Person.objects.get(user='checkts').adresse

    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u''],
    u'pager': [u'5678'],
    u'plz': [u''],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u''],
    u'timestamp': [u'2007-11-21 11:57'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': None,
                    'name': u'Herr Martin H. Sluka',
                    'ort': None,
                    'pager': u'5678',
                    'plz': None,
                    'pwuse': u'ftp,www,service',
                    'strasse': None,
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    assert(models.Adresse.objects.get(id=fremde_adresse.id))
    assert(not models.Adresse.objects.filter(id=checkts_adresse.id).exists())


def test_no_delete():
    """Eine Adresse, die auch an eine andere Person vergeben ist, wird beim
    Editieren mit Leerfeldern angegeben. Jetzt darf die Adresse nicht gelöscht
    werden.
    """
    # Erst mal eine Adresse neu anlegen.
    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u'N\xfcrnberg'],
    u'pager': [u'5678'],
    u'plz': [u'91000'],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u'Sluka-Weg 5.14'],
    u'timestamp': [u'2007-11-21 11:57'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': u'Deutschland',
                    'name': u'Herr Martin H. Sluka',
                    'ort': u'N\xfcrnberg',
                    'pager': u'5678',
                    'plz': u'91000',
                    'pwuse': u'ftp,www,service',
                    'strasse': u'Sluka-Weg 5.14',
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    # diese Adresse auch an andere Person vergeben.
    alte_adresse = models.Person.objects.get(user='checkts').adresse
    fany = models.Person.objects.get(user='fany')
    fany.adresse = alte_adresse
    fany.save()

    # und jetzt eine Person wieder ändern.
    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u''],
    u'pager': [u'5678'],
    u'plz': [u''],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u''],
    u'timestamp': [u'2007-11-21 11:58'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': None,
                    'name': u'Herr Martin H. Sluka',
                    'ort': None,
                    'pager': u'5678',
                    'plz': None,
                    'pwuse': u'ftp,www,service',
                    'strasse': None,
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    # die alte Adresse muss es noch geben.
    assert(models.Person.objects.get(user='fany').adresse == alte_adresse)
    # und `checkts` hat keine Adresse mehr.
    assert(models.Person.objects.get(user='checkts').adresse is None)


def test_split_address():
    """Eine Adresse wird an mehrere Personen vergeben. Beim Editieren muss die
    Adresse für die andere Person erhalten bleiben.
    """

    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u'Nürnberg'],
    u'pager': [u'5678'],
    u'plz': [u'91000'],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u'Sluka-Weg 5.14'],
    u'timestamp': [u'2003-05-21 11:27'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': u'Deutschland',
                    'name': u'Herr Martin H. Sluka',
                    'ort': u'Nürnberg',
                    'pager': u'5678',
                    'plz': u'91000',
                    'pwuse': u'ftp,www,service',
                    'strasse': u'Sluka-Weg 5.14',
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    # diese Adresse auch an andere Person vergeben.
    alte_adresse = models.Person.objects.get(user='checkts').adresse
    fany = models.Person.objects.get(user='fany')
    fany.adresse = alte_adresse
    fany.save()

    # Wenn die Adresse unverändert bleibt, wird dieselbe Adresse nach wie vor
    # beiden Personen zugewiesen.
    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung2'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u''],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u'Nürnberg'],
    u'pager': [u'5678'],
    u'plz': [u'91000'],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u'Sluka-Weg 5.14'],
    u'timestamp': [u'2003-05-21 11:27'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung2',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': u'Deutschland',
                    'name': u'Herr Martin H. Sluka',
                    'ort': u'Nürnberg',
                    'pager': u'5678',
                    'plz': u'91000',
                    'pwuse': u'ftp,www,service',
                    'strasse': u'Sluka-Weg 5.14',
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    assert(models.Person.objects.get(user='checkts').adresse==alte_adresse)
    assert(models.Person.objects.get(user='fany').adresse==alte_adresse)

    # Jetzt wird die Adresse geändert:

    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u'Ungarn'],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u'Budapest'],
    u'pager': [u'5678'],
    u'plz': [u''],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u''],
    u'timestamp': [u'2007-11-21 12:03'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'location': '/kunde/sluka/person/3381/',
    'status_code': 302})
    # --------------------------------------------------------------------
    # GET /kunde/sluka/person/3381/
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'abt': u'Entwicklung',
                    'email': u'bernd.sluka@checkts.net',
                    'fax': u'1234',
                    'fon': u'1111',
                    'homedir': None,
                    'id': 3381L,
                    'kunde': u'sluka',
                    'land': u'Ungarn',
                    'name': u'Herr Martin H. Sluka',
                    'ort': u'Budapest',
                    'pager': u'5678',
                    'plz': u'',
                    'pwuse': u'ftp,www,service',
                    'strasse': u'',
                    'timestamp': Ellipsis,
                    'uremip': None,
                    'user': u'checkts'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': ['Ihre Eingaben wurden gesichert.'],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

    # die alte Adresse muss es noch geben:
    assert(models.Person.objects.get(user='fany').adresse.ort == u'Nürnberg')
    # und `checkts` hat eine andere Adresse:
    assert(models.Person.objects.get(user='checkts').adresse != alte_adresse)
    assert(models.Person.objects.get(user='checkts').adresse.ort == u'Budapest')


def test_errors():
    """Testet die Reaktion auf Fehleingaben
    """
    # --------------------------------------------------------------------
    # POST /kunde/sluka/person/3381/
    GET = MultiValueDict({})
    POST = MultiValueDict({u'abt': [u'Entwicklung'],
    u'email': [u'bernd.sluka@checkts.net'],
    u'fax': [u'1234'],
    u'fon': [u'1111'],
    u'homedir': [u''],
    u'id': [u'3381'],
    u'kunde': [u'sluka'],
    u'land': [u'Ungarn'],
    u'name': [u'Herr Martin H. Sluka'],
    u'ort': [u''],
    u'pager': [u'5678'],
    u'plz': [u''],
    u'pwuse': [u'ftp,www,service'],
    u'strasse': [u'Sluka-Weg 5.14.23'],
    u'timestamp': [u'2007-11-21 12:03'],
    u'uremip': [u''],
    u'user': [u'checkts']})
    response, context = runner.get_response(u'/kunde/sluka/person/3381/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=270312bd63b92e6dda99c6d3409d985e;'),
    'status_code': 200})
    assert runner.check_context(response, context, {
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'fax': [u'1234'], u'timestamp': [Ellipsis], u'ort': [u''], u'plz': [u''], u'user': [u'checkts'], u'strasse': [u'Sluka-Weg 5.14.23'], u'pager': [u'5678'], u'id': [u'3381'], u'homedir': [u''], u'land': [u'Ungarn'], u'name': [u'Herr Martin H. Sluka'], u'uremip': [u''], u'abt': [u'Entwicklung'], u'kunde': [u'sluka'], u'pwuse': [u'ftp,www,service'], u'fon': [u'1111'], u'email': [u'bernd.sluka@checkts.net']}),
            'edit_inline': True,
            'error_dict': {'ort': [u'Wenn eine Stra\xdfe, eine PLZ oder ein Land eingegeben wird, bitte auch den Ort angeben.']},
            'manipulator': '<kundebunt.kunde.forms.PersonForm object>'},
    'id': '3381',
    'messages': [],
    'object': '<Person: checkts, Herr Martin H. Sluka>',
 'person': '<Person: fany, Herr Martin H. Sluka>',
 'user': '<User: fany>'})


def test_fremde_adresse():
    """Die 'fremde Adresse' muss es noch immer geben
    """
