# -*- encoding: UTF-8 -*-

"""Testdurchlauf durch die Kundenübersicht, am Beispiel von hugi
"""
from pprint import pprint
from Cookie import SimpleCookie
from django.core import management
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')
    from django.db.models.loading import load_app
    print load_app("kundebunt.tests")
    management.call_command('loaddata', 'hugi.json', verbosity=99)
    print "loaded (or not?)"


def test_search():
    """Testet die Suche nach Kunde 'h*'
    """
    # --------------------------------------------------------------------
    # GET /kunde/
    response, context = runner.get_response(u'/kunde/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'search': '*'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundenSucheForm object>'},
    'keine_treffer': True,
    'messages': [],
    'mit_suche': MultiValueDict({}),
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'treffer_listen': [],
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/
    GET = MultiValueDict({u'search': [u'h*']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'SERVICE_URL': '',
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({u'search': ['h*']}),
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.kunde.forms.KundenSucheForm object>'},
        'keine_treffer': False,
        'messages': [],
        'mit_suche': MultiValueDict({u'search': ['h*']}),
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'treffer_listen': ["<TrefferListe(<class 'kundebunt.kunde.forms.KundenNameTreffer'>): [<Kunde: hugi>]",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.KundenAliasTreffer'>): []",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.DomainTreffer'>): [<Domainkunde: hugicam.de>]",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.IPAddressTreffer'>): []",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.IPHostnameTreffer'>): []",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.MailruleTreffer'>): [<Mailrule: (virt) hauptmann@drei-auf-der-schaukel.de -> ingo@noris.de>, <Mailrule: (virt) hella.rottach@thilo-rottach.de -> tro6>, <Mailrule: (virt) hilde@vach.noris.de -> hilde>, <Mailrule: (virt) hugi@bitte.net -> ingo@noris.net>, <Mailrule: (virt) hugi@imp.de -> ingo@noris.net>]",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.PersonenUserTreffer'>): [<Person: hilde, Hildegard Kraupa>, <Person: hugi, Herr Ingo Kraupa>]",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.PersonenEmailTreffer'>): [<Person: tro6, Hella Rottach>, <Person: hilde, Hildegard Kraupa>, <Person: noris network N\xc3\xbcrnberg>, <Person: noris.net Hostmaster>]",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.HardwareIdTreffer'>): []",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.NicHandleTreffer'>): []",
                            "<TrefferListe(<class 'kundebunt.kunde.forms.PersonenNameTreffer'>): [<Person: silke, Frau Silke Herzog>, <Person: tro6, Hella Rottach>, <Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>, <Person: ingmar, Herr Ingmar Saal>, <Person: ingo, Herr Ingo Kraupa>, <Person: hugi, Herr Ingo Kraupa>, <Person: Herr Ingo Kraupa>, <Person: Herr Markus Tapprich>, <Person: fany, Herr Martin H. Sluka>, <Person: checkts, Herr Martin H. Sluka>, <Person: vogel-kellner, Herr Michael Vogel-Kellner>, <Person: lumpatweb, Herr Patrik Lumma>, <Person: stoffel, Herr Stefan Keller>, <Person: thilo, Herr Thilo Rottach>, <Person: werner, Herr Werner Kraupa>, <Person: hilde, Hildegard Kraupa>, <Person: ig4test, Hostwatch>, <Person: noris.net Hostmaster>]"],
        'user': '<User: fany>'})


def test_hugi_mitunter():
    """Kundenübersicht zu 'hugi' mit Unterkunden
    """
    # --------------------------------------------------------------------
    # GET /kunde/hugi/
    response, context = runner.get_response(u'/kunde/hugi/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'abgelaufen': '',
    'accounts': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: prager, Familie Prager>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: imp, test>',
                '<Person: rp, Relay-Party>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: babsi>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: testing>',
                '<Person: karin, Karin Link>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: sinus154>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: zfhelden>'],
    'accounts_unvollstaendig': True,
    'anzahl_ips': 2L,
    'anzahl_personen': 24,
    'anzahl_tickets': 0,
    'ap_technik': None,
    'ap_vertrieb': '<Person: family, norisMA>',
    'domains': ['<Domainkunde: bitte.net>',
                '<Domainkunde: thilo-rottach.de>',
                '<Domainkunde: drei-auf-der-schaukel.de>',
                '<Domainkunde: imp.de>',
                '<Domainkunde: relay-party.org>',
                '<Domainkunde: vach.noris.de>',
                '<Domainkunde: lumpat.de>',
                '<Domainkunde: philharmonie-marchfeld.at>',
                '<Domainkunde: godaplaum.de>',
                '<Domainkunde: flow-forum.de>',
                '<Domainkunde: hugicam.de>',
                '<Domainkunde: improware.de>',
                '<Domainkunde: nbg.sub.org>',
                '<Domainkunde: parkbank.de>',
                '<Domainkunde: rp2002.relay-party.org>',
                '<Domainkunde: ultravista.de>',
                '<Domainkunde: xn--gesff-lua.de>',
                '<Domainkunde: xn--li-eka.de>',
                '<Domainkunde: xn--tff-sna.de>'],
    'domains_unvollstaendig': True,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundeOverviewForm object>'},
    'hardware': ['<Hardware: 5075 Hetzner DS9000 (test.bitte.net) [#D003839] @ RZ3, C01, HE 7+4>',
                '<Hardware: 993 Rennix 1HE-Server (muschel.noris.net) [#D000015] @ RZ3, B01, HE 37+1>'],
    'hardware_unvollstaendig': False,
    'hat_unterkunden': True,
    'ips': ['<Ipkunde: 213.95.10.2>', '<Ipkunde: 213.95.21.16>'],
    'ips_unvollstaendig': False,
    'kunde_id': 8L,
    'kunden_name': u'hugi',
    'messages': [],
    'mit_unterkunden_value': 'on',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>'],
    'personen_unvollstaendig': True,
    'prio': None,
    'prio_class': None,
    'ticket_query': None,
    'ueberkunde': None,
    'unterkunden': ['<Kunde: trottach>', '<Kunde: vach>'],
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/
    GET = MultiValueDict({u'mit_unterkunden': [u'on'], u'dummy': [u'']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'abgelaufen': '',
    'accounts': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: prager, Familie Prager>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: imp, test>',
                '<Person: rp, Relay-Party>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: babsi>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: testing>',
                '<Person: karin, Karin Link>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: sinus154>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: zfhelden>'],
    'accounts_unvollstaendig': True,
    'anzahl_ips': 2L,
    'anzahl_personen': 24,
    'anzahl_tickets': 0,
    'ap_technik': None,
    'ap_vertrieb': '<Person: family, norisMA>',
    'domains': ['<Domainkunde: bitte.net>',
                '<Domainkunde: thilo-rottach.de>',
                '<Domainkunde: drei-auf-der-schaukel.de>',
                '<Domainkunde: imp.de>',
                '<Domainkunde: relay-party.org>',
                '<Domainkunde: vach.noris.de>',
                '<Domainkunde: lumpat.de>',
                '<Domainkunde: philharmonie-marchfeld.at>',
                '<Domainkunde: godaplaum.de>',
                '<Domainkunde: flow-forum.de>',
                '<Domainkunde: hugicam.de>',
                '<Domainkunde: improware.de>',
                '<Domainkunde: nbg.sub.org>',
                '<Domainkunde: parkbank.de>',
                '<Domainkunde: rp2002.relay-party.org>',
                '<Domainkunde: ultravista.de>',
                '<Domainkunde: xn--gesff-lua.de>',
                '<Domainkunde: xn--li-eka.de>',
                '<Domainkunde: xn--tff-sna.de>'],
    'domains_unvollstaendig': True,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundeOverviewForm object>'},
    'hardware': ['<Hardware: 5075 Hetzner DS9000 (test.bitte.net) [#D003839] @ RZ3, C01, HE 7+4>',
                '<Hardware: 993 Rennix 1HE-Server (muschel.noris.net) [#D000015] @ RZ3, B01, HE 37+1>'],
    'hardware_unvollstaendig': False,
    'hat_unterkunden': True,
    'ips': ['<Ipkunde: 213.95.10.2>', '<Ipkunde: 213.95.21.16>'],
    'ips_unvollstaendig': False,
    'kunde_id': 8L,
    'kunden_name': u'hugi',
    'messages': [],
    'mit_unterkunden_value': 'on',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>'],
    'personen_unvollstaendig': True,
    'prio': None,
    'prio_class': None,
    'ticket_query': None,
    'ueberkunde': None,
    'unterkunden': ['<Kunde: trottach>', '<Kunde: vach>'],
    'user': '<User: fany>'})

def test_hugi_personen():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'on']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'on']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>',
                '<Person: buettner, DIM>',
                '<Person: prager, Familie Prager>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: Ingo Kraupa US-NIC>',
                '<Person: stoffel, Herr Stefan Keller>',
                '<Person: ingo, Herr Ingo Kraupa>',
                '<Person: Herr Ingo Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: noris, noris network AG>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: Herr Markus Tapprich>',
                '<Person: vogel-kellner, Herr Michael Vogel-Kellner>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: Zahnarzt Dr. M. Quilez>',
                '<Person: babsi>',
                '<Person: testing>',
                '<Person: ultra>'],
    'sortier_spalte': 'name',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'contact',
                u'general',
                u'service2',
                u'tech-c',
                u'trouble',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/contact/
    GET = MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'name']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/contact/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': u'contact',
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'name']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>'],
    'sortier_spalte': u'name',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'contact',
                u'general',
                u'service2',
                u'tech-c',
                u'trouble',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'email']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'email']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: babsi>',
                '<Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: noris, noris network AG>',
                '<Person: ingo, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: Herr Markus Tapprich>',
                '<Person: Zahnarzt Dr. M. Quilez>',
                '<Person: prager, Familie Prager>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: stoffel, Herr Stefan Keller>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: vogel-kellner, Herr Michael Vogel-Kellner>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: Ingo Kraupa US-NIC>',
                '<Person: ultra>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: buettner, DIM>',
                '<Person: Herr Ingo Kraupa>',
                '<Person: testing>'],
    'sortier_spalte': u'email',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'contact',
                u'general',
                u'service2',
                u'tech-c',
                u'trouble',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'email']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'email']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: babsi>',
                '<Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: noris, noris network AG>',
                '<Person: ingo, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: Herr Markus Tapprich>',
                '<Person: Zahnarzt Dr. M. Quilez>',
                '<Person: prager, Familie Prager>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: stoffel, Herr Stefan Keller>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: vogel-kellner, Herr Michael Vogel-Kellner>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: Ingo Kraupa US-NIC>',
                '<Person: ultra>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: buettner, DIM>',
                '<Person: Herr Ingo Kraupa>',
                '<Person: testing>'],
    'sortier_spalte': u'email',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'contact',
                u'general',
                u'service2',
                u'tech-c',
                u'trouble',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'user']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'on'], u'order': [u'user']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: babsi>',
                '<Person: buettner, DIM>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: ingo, Herr Ingo Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: noris, noris network AG>',
                '<Person: prager, Familie Prager>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: stoffel, Herr Stefan Keller>',
                '<Person: testing>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: vogel-kellner, Herr Michael Vogel-Kellner>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: Ingo Kraupa US-NIC>',
                '<Person: Herr Markus Tapprich>',
                '<Person: Zahnarzt Dr. M. Quilez>',
                '<Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>',
                '<Person: Herr Ingo Kraupa>'],
    'sortier_spalte': u'user',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'contact',
                u'general',
                u'service2',
                u'tech-c',
                u'trouble',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})

def test_hugi_accounts():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/
    response, context = runner.get_response(u'/kunde/hugi/accounts/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True, 'suche': '*'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: babsi>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: imp, test>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: karin, Karin Link>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: prager, Familie Prager>',
                '<Person: rp, Relay-Party>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: sinus154>',
                '<Person: testing>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: zfhelden>'],
    'sortier_spalte': 'user',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/ppp/
    GET = MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'user']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/accounts/ppp/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
    'filter_spalte': u'ppp',
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'user']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: babsi>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: rp, Relay-Party>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>'],
    'sortier_spalte': u'user',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/www/
    GET = MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'user']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/accounts/www/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
    'filter_spalte': u'www',
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'user']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: goda, Frau Goda Plaum>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: imp, test>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: prager, Familie Prager>',
                '<Person: rp, Relay-Party>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: ultra>'],
    'sortier_spalte': u'user',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/
    GET = MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'name']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/accounts/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'name']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: tro3, Adriana Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: prager, Familie Prager>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: karin, Karin Link>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: milli, Milli Vanilli>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: rp, Relay-Party>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: tro2, Sabina Ille>',
                '<Person: pf654, Stefan Keller>',
                '<Person: imp, test>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: babsi>',
                '<Person: ncp-test>',
                '<Person: sinus154>',
                '<Person: testing>',
                '<Person: ultra>',
                '<Person: zfhelden>'],
    'sortier_spalte': u'name',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/
    GET = MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'email']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/accounts/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'True'], u'order': [u'email']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: tro3, Adriana Rottach>',
                '<Person: babsi>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro5, Gast>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: tro6, Hella Rottach>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: imp, test>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: rp, Relay-Party>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: karin, Karin Link>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: milli, Milli Vanilli>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: prager, Familie Prager>',
                '<Person: tro2, Sabina Ille>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: pf654, Stefan Keller>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: ultra>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: testing>',
                '<Person: sinus154>',
                '<Person: ncp-test>',
                '<Person: zfhelden>'],
    'sortier_spalte': u'email',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/
    response, context = runner.get_response(u'/kunde/hugi/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'abgelaufen': '',
    'accounts': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: prager, Familie Prager>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: imp, test>',
                '<Person: rp, Relay-Party>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: babsi>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: testing>',
                '<Person: karin, Karin Link>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: sinus154>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: zfhelden>'],
    'accounts_unvollstaendig': True,
    'anzahl_ips': 2L,
    'anzahl_personen': 24,
    'anzahl_tickets': 0,
    'ap_technik': None,
    'ap_vertrieb': '<Person: family, norisMA>',
    'domains': ['<Domainkunde: bitte.net>',
                '<Domainkunde: thilo-rottach.de>',
                '<Domainkunde: drei-auf-der-schaukel.de>',
                '<Domainkunde: imp.de>',
                '<Domainkunde: relay-party.org>',
                '<Domainkunde: vach.noris.de>',
                '<Domainkunde: lumpat.de>',
                '<Domainkunde: philharmonie-marchfeld.at>',
                '<Domainkunde: godaplaum.de>',
                '<Domainkunde: flow-forum.de>',
                '<Domainkunde: hugicam.de>',
                '<Domainkunde: improware.de>',
                '<Domainkunde: nbg.sub.org>',
                '<Domainkunde: parkbank.de>',
                '<Domainkunde: rp2002.relay-party.org>',
                '<Domainkunde: ultravista.de>',
                '<Domainkunde: xn--gesff-lua.de>',
                '<Domainkunde: xn--li-eka.de>',
                '<Domainkunde: xn--tff-sna.de>'],
    'domains_unvollstaendig': True,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundeOverviewForm object>'},
    'hardware': ['<Hardware: 5075 Hetzner DS9000 (test.bitte.net) [#D003839] @ RZ3, C01, HE 7+4>',
                '<Hardware: 993 Rennix 1HE-Server (muschel.noris.net) [#D000015] @ RZ3, B01, HE 37+1>'],
    'hardware_unvollstaendig': False,
    'hat_unterkunden': True,
    'ips': ['<Ipkunde: 213.95.10.2>', '<Ipkunde: 213.95.21.16>'],
    'ips_unvollstaendig': False,
    'kunde_id': 8L,
    'kunden_name': u'hugi',
    'messages': [],
    'mit_unterkunden_value': 'on',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: vach, Werner Hans Kraupa>'],
    'personen_unvollstaendig': True,
    'prio': None,
    'prio_class': None,
    'ticket_query': None,
    'ueberkunde': None,
    'unterkunden': ['<Kunde: trottach>', '<Kunde: vach>'],
    'user': '<User: fany>'})

def test_hugi_personen_ohne_unter():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: hugi, Herr Ingo Kraupa>',
                '<Person: Herr Dipl.-Ing. G. L. B\xc3\xbcttner>',
                '<Person: buettner, DIM>',
                '<Person: prager, Familie Prager>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: ig4test, Hostwatch>',
                '<Person: Ingo Kraupa US-NIC>',
                '<Person: stoffel, Herr Stefan Keller>',
                '<Person: ingo, Herr Ingo Kraupa>',
                '<Person: Herr Ingo Kraupa>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: noris, noris network AG>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: Herr Markus Tapprich>',
                '<Person: vogel-kellner, Herr Michael Vogel-Kellner>',
                '<Person: Zahnarzt Dr. M. Quilez>',
                '<Person: testing>',
                '<Person: ultra>'],
    'sortier_spalte': 'name',
    'spalten': [u'--',
                u':',
                u'bill-c',
                u'general',
                u'service2',
                u'tech-c',
                'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})

def test_hugi_accounts_ohne_unter():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/
    response, context = runner.get_response(u'/kunde/hugi/accounts/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True, 'suche': '*'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: babsi>',
                '<Person: goda, Frau Goda Plaum>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: imp, test>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: karin, Karin Link>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: prager, Familie Prager>',
                '<Person: rp, Relay-Party>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: sinus154>',
                '<Person: testing>',
                '<Person: thilo, Herr Thilo Rottach>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>',
                '<Person: ultra>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: zfhelden>'],
    'sortier_spalte': 'user',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/accounts/
    GET = MultiValueDict({u'suche': [u'*']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/accounts/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/accounts/',
'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'suche': [u'*']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/hugi/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: goda, Frau Goda Plaum>',
                '<Person: hugi, Herr Ingo Kraupa>',
                '<Person: ig4test, Hostwatch>',
                '<Person: imp, test>',
                '<Person: ingmar, Herr Ingmar Saal>',
                '<Person: karin, Karin Link>',
                '<Person: lumpatweb, Herr Patrik Lumma>',
                '<Person: milli, Milli Vanilli>',
                '<Person: ncp-test>',
                '<Person: pf10, Patrick Guelat>',
                '<Person: pf654, Stefan Keller>',
                '<Person: prager, Familie Prager>',
                '<Person: rp, Relay-Party>',
                '<Person: silke, Frau Silke Herzog>',
                '<Person: sinus154>',
                '<Person: testing>',
                '<Person: ultra>',
                '<Person: zfhelden>'],
    'sortier_spalte': 'user',
    'spalten': [u'dialin',
                u'ftp',
                u'mail',
                u'mysql',
                u'ppp',
                u'readonly',
                u'tdsl-ilk',
                u'tdsl-zisp',
                u'www',
                'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})

def test_trottach():
    # --------------------------------------------------------------------
    # GET /kunde/trottach/
    response, context = runner.get_response(u'/kunde/trottach/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'abgelaufen': '',
    'accounts': ['<Person: thilo, Herr Thilo Rottach>',
                '<Person: tro1, Thilo Rottach>',
                '<Person: tro2, Sabina Ille>',
                '<Person: tro3, Adriana Rottach>',
                '<Person: tro4, Jessica Rottach>',
                '<Person: tro5, Gast>',
                '<Person: tro6, Hella Rottach>',
                '<Person: tro7, Daniel Albu>',
                '<Person: tro8, Thilo Rottach>'],
    'accounts_unvollstaendig': False,
    'anzahl_ips': 0L,
    'anzahl_personen': 1,
    'anzahl_tickets': 0,
    'ap_technik': None,
    'ap_vertrieb': None,
    'domains': ['<Domainkunde: thilo-rottach.de>'],
    'domains_unvollstaendig': False,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundeOverviewForm object>'},
    'hardware': [],
    'hardware_unvollstaendig': False,
    'hat_unterkunden': False,
    'ips': [],
    'ips_unvollstaendig': False,
    'kunde_id': 1713L,
    'kunden_name': u'trottach',
    'messages': [],
    'mit_unterkunden_value': '',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: thilo, Herr Thilo Rottach>'],
    'personen_unvollstaendig': False,
    'prio': None,
    'prio_class': None,
    'ticket_query': None,
    'ueberkunde': '<Kunde: hugi>',
    'unterkunden': [],
    'user': '<User: fany>'})

def test_vach():
    # --------------------------------------------------------------------
    # GET /kunde/vach/
    response, context = runner.get_response(u'/kunde/vach/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'abgelaufen': '',
    'accounts': ['<Person: babsi>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>',
                '<Person: hilde, Hildegard Kraupa>'],
    'accounts_unvollstaendig': False,
    'anzahl_ips': 0L,
    'anzahl_personen': 4,
    'anzahl_tickets': 0,
    'ap_technik': None,
    'ap_vertrieb': None,
    'domains': ['<Domainkunde: vach.noris.de>'],
    'domains_unvollstaendig': False,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.KundeOverviewForm object>'},
    'hardware': [],
    'hardware_unvollstaendig': False,
    'hat_unterkunden': False,
    'ips': [],
    'ips_unvollstaendig': False,
    'kunde_id': 459L,
    'kunden_name': u'vach',
    'messages': [],
    'mit_unterkunden_value': '',
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: werner, Herr Werner Kraupa>',
                '<Person: vach, Werner Hans Kraupa>'],
    'personen_unvollstaendig': True,
    'prio': None,
    'prio_class': None,
    'ticket_query': None,
    'ueberkunde': '<Kunde: hugi>',
    'unterkunden': [],
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/vach/personen/
    GET = MultiValueDict({u'mit_unterkunden': [u'']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/vach/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/vach/personen/',
'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'mit_unterkunden': [u'']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': False,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'vach',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/vach/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: werner, Herr Werner Kraupa>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: babsi>'],
    'sortier_spalte': 'name',
    'spalten': [u'--', u':', u'contact', u'trouble', 'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/vach/accounts/
    response, context = runner.get_response(u'/kunde/vach/accounts/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/vach/accounts/',
'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': {'mit_unterkunden': True, 'suche': '*'},
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': False,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'vach',
    'messages': [],
    'modus': 'accounts',
    'other_url': u'/kunde/vach/personen/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: babsi>',
                '<Person: hilde, Hildegard Kraupa>',
                '<Person: vach, Werner Hans Kraupa>',
                '<Person: werner, Herr Werner Kraupa>'],
    'sortier_spalte': 'user',
    'spalten': [u'mail', u'ppp', 'dienste'],
    'titel': u'Benutzerkonten zu',
    'user': '<User: fany>'})

def test_hugi_domains():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/domains/
    GET = MultiValueDict({u'mit_unterkunden': [u'on']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/domains/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'domains': ['<Domainkunde: philharmonie-marchfeld.at>',
                '<Domainkunde: drei-auf-der-schaukel.de>',
                '<Domainkunde: flow-forum.de>',
                '<Domainkunde: godaplaum.de>',
                '<Domainkunde: hugicam.de>',
                '<Domainkunde: imp.de>',
                '<Domainkunde: improware.de>',
                '<Domainkunde: lumpat.de>',
                '<Domainkunde: vach.noris.de>',
                '<Domainkunde: parkbank.de>',
                '<Domainkunde: thilo-rottach.de>',
                '<Domainkunde: ultravista.de>',
                '<Domainkunde: xn--gesff-lua.de>',
                '<Domainkunde: xn--li-eka.de>',
                '<Domainkunde: xn--tff-sna.de>',
                '<Domainkunde: bitte.net>',
                '<Domainkunde: relay-party.org>',
                '<Domainkunde: rp2002.relay-party.org>',
                '<Domainkunde: nbg.sub.org>'],
    'form': '<kundebunt.kunde.forms.MitUnterkundenForm object>',
    'hat_unterkunden': True,
    'kunden_name': u'hugi',
    'messages': [],
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/domains/
    GET = MultiValueDict({u'dummy': [u'']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/domains/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'domains': ['<Domainkunde: philharmonie-marchfeld.at>',
                '<Domainkunde: drei-auf-der-schaukel.de>',
                '<Domainkunde: flow-forum.de>',
                '<Domainkunde: godaplaum.de>',
                '<Domainkunde: hugicam.de>',
                '<Domainkunde: imp.de>',
                '<Domainkunde: improware.de>',
                '<Domainkunde: lumpat.de>',
                '<Domainkunde: parkbank.de>',
                '<Domainkunde: ultravista.de>',
                '<Domainkunde: xn--gesff-lua.de>',
                '<Domainkunde: xn--li-eka.de>',
                '<Domainkunde: xn--tff-sna.de>',
                '<Domainkunde: bitte.net>',
                '<Domainkunde: relay-party.org>',
                '<Domainkunde: rp2002.relay-party.org>',
                '<Domainkunde: nbg.sub.org>'],
    'form': '<kundebunt.kunde.forms.MitUnterkundenForm object>',
    'hat_unterkunden': True,
    'kunden_name': u'hugi',
    'messages': [],
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

def test_hugi_ips():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/ips/
    GET = MultiValueDict({u'mit_unterkunden': [u'on']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/ips/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': '<kundebunt.kunde.forms.MitUnterkundenForm object>',
    'hat_unterkunden': True,
    'ips': ['<Ipkunde: 213.95.10.2>', '<Ipkunde: 213.95.21.16>'],
    'kunden_name': u'hugi',
    'messages': [],
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})
    # --------------------------------------------------------------------
    # GET /kunde/hugi/ips/
    GET = MultiValueDict({u'dummy': [u'']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/ips/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'form': '<kundebunt.kunde.forms.MitUnterkundenForm object>',
    'hat_unterkunden': True,
    'ips': ['<Ipkunde: 213.95.10.2>', '<Ipkunde: 213.95.21.16>'],
    'kunden_name': u'hugi',
    'messages': [],
    'person': '<Person: fany, Herr Martin H. Sluka>',
    'user': '<User: fany>'})

def test_hugi_personen_suche():
    # --------------------------------------------------------------------
    # GET /kunde/hugi/personen/
    GET = MultiValueDict({u'quick': [u''], u'suche': [u't*']})
    POST = MultiValueDict({})
    response, context = runner.get_response(u'/kunde/hugi/personen/', 'GET', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=249bf641db58deb1ce4f1722a986d8e8;'),
    'status_code': 200})
    assert runner.check_context(response, context, {'base_url': u'/kunde/hugi/personen/',
    'filter_spalte': None,
    'form': {'_inline_collections': None,
            'advisory_dict': {},
            'data': MultiValueDict({u'quick': [u''], u'suche': [u't*']}),
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<kundebunt.kunde.forms.PersonenForm object>'},
    'hat_unterkunden': True,
    'icon_base': '/kundebunt/static/icons/dienst',
    'kunden_name': u'hugi',
    'messages': [],
    'modus': 'dienste',
    'other_url': u'/kunde/hugi/accounts/',
    u'person': '<Person: fany, Herr Martin H. Sluka>',
    'personen': ['<Person: Herr Markus Tapprich>',
                 '<Person: testing>'],
    'sortier_spalte': 'name',
    'spalten': [u'--', 'flags'],
    'titel': u'Personen zu',
    'user': '<User: fany>'})