# -*- encoding: UTF-8 -*-

"""F_
Testet die Detailanzeige und Änderungen von Hardware, die nicht auf Ajax basieren.
Hier wird nur grob getestet, das meiste wird in test_hardware_panels erledigt.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.tests.fixtures.hardware import *

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')


class TestHardware(HardwareFixture):
    class TestWartungsvertrag(WartungsvertragFixture):
        @classmethod
        def setup_class(self):
            WartungsvertragFixture.setup_class()
            from kundebunt.popkern import models
            from django import db
            cursor = db.connection.cursor()
            cursor.execute("alter table wartungsvertrag_hardware auto_increment=1")

        @classmethod
        def teardown_class(self):
            from kundebunt.popkern import models
            models.WartungsvertragHardware.objects.all().delete()
            WartungsvertragFixture.teardown_class()

        @classmethod
        def test_create_failure(self):
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/create/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/create/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'beginn': Ellipsis},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ende': [''], 'wartungsvertrag': [''], 'beginn': ['']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ende': [None], 'wartungsvertrag': [None], 'beginn': [None]}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Bitte dieses Feld ausf\xc3\xbcllen.'],
                                    'wartungsvertrag': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ende': [''], 'wartungsvertrag': [''], 'beginn': ['2007-01-32']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ende': [None], 'wartungsvertrag': [None], 'beginn': [None]}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Ung\xc3\xbcltiges Datum: Der Tag ist au\xc3\x9ferhalb des zul\xc3\xa4ssigen Bereichs'],
                                    'wartungsvertrag': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2007-01-01'],
            'ende': ['2006-01-01'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ende': ['datetime.date(2006, 1, 1)'], 'wartungsvertrag': ['<Wartungsvertrag HP Gips Support>'], 'beginn': ['datetime.date(2007, 1, 1)']}),
                    'edit_inline': True,
                    'error_dict': {'ende': ["Das \xc3\xbcbliche Konzept von 'Beginn' und 'Ende' sieht vor, dass der Beginn vor dem Ende liegt. Sind hier vielleicht versehentlich Beginn und Ende vertauscht?"]},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})

        def test_create_success(self):
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2007-01-01'],
            'ende': ['2007-12-31'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/1/wartungsvertrag/1/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/1/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/1/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: hp_ap, Herr H. P.>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/1/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-01 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2007-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv1_',
            'in_panel': False,
            'messages': ['Der Datensatz wurde angelegt.'],
            'object': '<WartungsvertragHardware #1, 2007-01-01 bis 2007-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/1/
            response, context = runner.get_response('/hardware/1/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'copy_url': '/hardware/copy/1/',
            'enthaltene_hardware': ['<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'eigentuemer': None,
                            'enthalten_in': None,
                            'hardware_id': 'D000001',
                            'id': 1L,
                            'info': None,
                            'ip': 'eins',
                            'ivnr': '000001',
                            'klasse': None,
                            'kunde': 'POP',
                            'lieferant': None,
                            'name': 'Fubrikator 001',
                            'rack': 'rack1',
                            'rz': 'RZ1',
                            'seriennr': 'A1',
                            'standort': None,
                            'status': None,
                            'typ': None,
                            'verantwortlich': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
            'id': '1',
            'id_prefix': 'hw1_',
            'in_panel': False,
            'messages': [],
            'object': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'rack_id': 1L,
            'user': '<User: fany>',
            'wartungsvertraege': ['<WartungsvertragHardware #1, 2007-01-01 bis 2007-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>']})

        def test_copy(self):
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/copy/1/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/copy/1/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'copying': True,
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-01 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2007-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragCopyForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/copy/1/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2008-01-01'],
            'ende': ['2008-12-31'],
            'wartungsvertrag': ['Dell Granit Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/copy/1/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/1/wartungsvertrag/2/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/2/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/2/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/2/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2008-01-01 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '2008-12-31 00:00',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv2_',
            'in_panel': False,
            'messages': ['Der Datensatz wurde angelegt.'],
            'object': '<WartungsvertragHardware #2, 2008-01-01 bis 2008-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/copy/2/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/copy/2/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'copying': True,
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2008-01-01 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '2008-12-31 00:00',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragCopyForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wvnew1_',
            'in_panel': False,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/copy/2/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2006-01-01'],
            'ende': ['2006-12-31'],
            'wartungsvertrag': ['Dell Granit Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/copy/2/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/1/wartungsvertrag/3/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/3/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/3/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/3/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2006-01-01 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '2006-12-31 00:00',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv3_',
            'in_panel': False,
            'messages': ['Der Datensatz wurde angelegt.'],
            'object': '<WartungsvertragHardware #3, 2006-01-01 bis 2006-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/1/
            response, context = runner.get_response('/hardware/1/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'copy_url': '/hardware/copy/1/',
            'enthaltene_hardware': ['<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'eigentuemer': None,
                            'enthalten_in': None,
                            'hardware_id': 'D000001',
                            'id': 1L,
                            'info': None,
                            'ip': 'eins',
                            'ivnr': '000001',
                            'klasse': None,
                            'kunde': 'POP',
                            'lieferant': None,
                            'name': 'Fubrikator 001',
                            'rack': 'rack1',
                            'rz': 'RZ1',
                            'seriennr': 'A1',
                            'standort': None,
                            'status': None,
                            'typ': None,
                            'verantwortlich': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
            'id': '1',
            'id_prefix': 'hw1_',
            'in_panel': False,
            'messages': [],
            'object': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'rack_id': 1L,
            'user': '<User: fany>',
            'wartungsvertraege': ['<WartungsvertragHardware #2, 2008-01-01 bis 2008-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
                                '<WartungsvertragHardware #1, 2007-01-01 bis 2007-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
                                '<WartungsvertragHardware #3, 2006-01-01 bis 2006-12-31, zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>']})

        def test_edit(self):
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/3/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ansprechpartner_email': ['support@dell.local'],
            'ansprechpartner_fon': [''],
            'ansprechpartner_name': ['Herr Dell'],
            'beginn': ['2006-01-02'],
            'beschreibung': ['Dell ... Support ... Blablabla'],
            'ende': [''],
            'sla': ['1x1'],
            'wartungsvertrag': ['Dell Granit Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/3/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/1/wartungsvertrag/3/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/3/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/3/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {
            'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/3/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2006-01-02 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv3_',
            'in_panel': False,
            'messages': ['Ihre Eingaben wurden gesichert.'],
            'object': '<WartungsvertragHardware #3, 2006-01-02 bis , zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})

        def test_edit_failure(self):
            # --------------------------------------------------------------------
            # POST /hardware/1/wartungsvertrag/3/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ansprechpartner_email': ['support@dell.local'],
            'ansprechpartner_fon': [''],
            'ansprechpartner_name': ['Herr Dell'],
            'beginn': [''],
            'beschreibung': ['Dell ... Support ... Blablabla'],
            'ende': [''],
            'sla': ['1x1'],
            'wartungsvertrag': ['Dell Granit Support']})
            response, context = runner.get_response('/hardware/1/wartungsvertrag/3/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/3/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ansprechpartner_name': ['Herr Dell'], 'beginn': [None], 'beschreibung': ['Dell ... Support ... Blablabla'], 'ende': [None], 'wartungsvertrag': ['<Wartungsvertrag Dell Granit Support>'], 'ansprechpartner_email': ['support@dell.local'], 'sla': ['1x1'], 'ansprechpartner_fon': ['']}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv3_',
            'in_panel': False,
            'messages': [],
            'object': '<WartungsvertragHardware #3, 2006-01-02 bis , zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/1/wartungsvertrag/3/
            response, context = runner.get_response('/hardware/1/wartungsvertrag/3/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '/hardware/1/wartungsvertrag/copy/3/',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2006-01-02 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'id_prefix': 'wv3_',
            'in_panel': False,
            'messages': [],
            'object': '<WartungsvertragHardware #3, 2006-01-02 bis , zu 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})

        def test_panel_create_success(self):
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/create/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/create/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'beginn': Ellipsis},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2007-01-01'],
            'ende': [''],
            'wartungsvertrag': ['Dell Granit Support']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/panel/2/wartungsvertrag/4/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/4/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/4/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: dell_ap, Herr Dell>',
            'copy_url': '-javascript-',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2007-01-01 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wv4_',
            'in_panel': True,
            'messages': ['Der Datensatz wurde angelegt.'],
            'object': '<WartungsvertragHardware #4, 2007-01-01 bis , zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/
            response, context = runner.get_response('/hardware/panel/2/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'copy_url': '-javascript-',
            'enthaltene_hardware': [],
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'eigentuemer': None,
                            'enthalten_in': None,
                            'hardware_id': 'D000002',
                            'id': 2L,
                            'info': None,
                            'ip': 'zwei',
                            'ivnr': '000002',
                            'klasse': None,
                            'kunde': 'POP',
                            'lieferant': None,
                            'name': 'Enoraix 002',
                            'rack': 'rack2',
                            'rz': 'RZ2',
                            'seriennr': 'B2',
                            'standort': None,
                            'status': None,
                            'typ': None,
                            'verantwortlich': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
            'id': '2',
            'id_prefix': 'hw2_',
            'in_panel': True,
            'messages': [],
            'object': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'rack_id': 4L,
            'user': '<User: fany>',
            'wartungsvertraege': ['<WartungsvertragHardware #4, 2007-01-01 bis , zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>']})
            
        def test_panel_copy_success(self):
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/copy/4/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/copy/4/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'copying': True,
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': 'support@dell.local',
                            'ansprechpartner_fon': None,
                            'ansprechpartner_name': 'Herr Dell',
                            'beginn': '2007-01-01 00:00',
                            'beschreibung': 'Dell ... Support ... Blablabla',
                            'ende': '',
                            'sla': '1x1',
                            'wartungsvertrag': '<Wartungsvertrag Dell Granit Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragCopyForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/copy/4/
            GET = MultiValueDict({})
            POST = MultiValueDict({'beginn': ['2007-01-01'],
            'ende': ['2007-12-31'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/copy/4/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/panel/2/wartungsvertrag/5/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/5/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: hp_ap, Herr H. P.>',
            'copy_url': '-javascript-',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-01 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2007-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wv5_',
            'in_panel': True,
            'messages': ['Der Datensatz wurde angelegt.'],
            'object': '<WartungsvertragHardware #5, 2007-01-01 bis 2007-12-31, zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/5/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ansprechpartner_email': [''],
            'ansprechpartner_fon': ['+49 911 999'],
            'ansprechpartner_name': ['Herr H. P.'],
            'beginn': ['2007-01-02'],
            'beschreibung': ['HP ... auch Support ... Blablabla'],
            'ende': ['2007-12-31'],
            'sla': ['8x8'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/panel/2/wartungsvertrag/5/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/5/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: hp_ap, Herr H. P.>',
            'copy_url': '-javascript-',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-02 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2007-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wv5_',
            'in_panel': True,
            'messages': ['Ihre Eingaben wurden gesichert.'],
            'object': '<WartungsvertragHardware #5, 2007-01-02 bis 2007-12-31, zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})

        def test_panel_edit_failure(self):
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/5/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ansprechpartner_email': [''],
            'ansprechpartner_fon': ['+49 911 999'],
            'ansprechpartner_name': ['Herr H. P.'],
            'beginn': [''],
            'beschreibung': ['HP ... auch Support ... Blablabla'],
            'ende': [''],
            'sla': ['8x8'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: hp_ap, Herr H. P.>',
            'copy_url': '-javascript-',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ansprechpartner_name': ['Herr H. P.'], 'beginn': [None], 'beschreibung': ['HP ... auch Support ... Blablabla'], 'ende': [None], 'wartungsvertrag': ['<Wartungsvertrag HP Gips Support>'], 'ansprechpartner_email': [''], 'sla': ['8x8'], 'ansprechpartner_fon': ['+49 911 999']}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wv5_',
            'in_panel': True,
            'messages': [],
            'object': '<WartungsvertragHardware #5, 2007-01-02 bis 2007-12-31, zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            
        def test_panel_edit_success(self):
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/5/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ansprechpartner_email': [''],
            'ansprechpartner_fon': ['+49 911 999'],
            'ansprechpartner_name': ['Herr H. P.'],
            'beginn': ['2007-01-02'],
            'beschreibung': ['HP ... auch Support ... Blablabla'],
            'ende': ['2008-12-31'],
            'sla': ['8x8'],
            'wartungsvertrag': ['HP Gips Support']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'location': '/hardware/panel/2/wartungsvertrag/5/',
            'status_code': 302})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/5/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/5/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'ansprechpartner': '<Person: hp_ap, Herr H. P.>',
            'copy_url': '-javascript-',
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-02 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2008-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragChangeForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wv5_',
            'in_panel': True,
            'messages': ['Ihre Eingaben wurden gesichert.'],
            'object': '<WartungsvertragHardware #5, 2007-01-02 bis 2008-12-31, zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/
            response, context = runner.get_response('/hardware/panel/2/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'copy_url': '-javascript-',
            'enthaltene_hardware': [],
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'eigentuemer': None,
                            'enthalten_in': None,
                            'hardware_id': 'D000002',
                            'id': 2L,
                            'info': None,
                            'ip': 'zwei',
                            'ivnr': '000002',
                            'klasse': None,
                            'kunde': 'POP',
                            'lieferant': None,
                            'name': 'Enoraix 002',
                            'rack': 'rack2',
                            'rz': 'RZ2',
                            'seriennr': 'B2',
                            'standort': None,
                            'status': None,
                            'typ': None,
                            'verantwortlich': None},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
            'id': '2',
            'id_prefix': 'hw2_',
            'in_panel': True,
            'messages': [],
            'object': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'rack_id': 4L,
            'user': '<User: fany>',
            'wartungsvertraege': ['<WartungsvertragHardware #4, 2007-01-01 bis , zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
                                '<WartungsvertragHardware #5, 2007-01-02 bis 2008-12-31, zu 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>']})

        def test_panel_copy_failure(self):
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/copy/5/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/copy/5/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'copying': True,
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'ansprechpartner_email': None,
                            'ansprechpartner_fon': '+49 911 999',
                            'ansprechpartner_name': 'Herr H. P.',
                            'beginn': '2007-01-02 00:00',
                            'beschreibung': 'HP ... auch Support ... Blablabla',
                            'ende': '2008-12-31 00:00',
                            'sla': '8x8',
                            'wartungsvertrag': '<Wartungsvertrag HP Gips Support>'},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragCopyForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/copy/5/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ende': [''], 'wartungsvertrag': ['Dell Granit Support'], 'beginn': ['']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/copy/5/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'copying': True,
            'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ende': [None], 'wartungsvertrag': ['<Wartungsvertrag Dell Granit Support>'], 'beginn': [None]}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragCopyForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # GET /hardware/panel/2/wartungsvertrag/create/
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/create/', 'GET', {}, {})
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': {'beginn': Ellipsis},
                    'edit_inline': True,
                    'error_dict': {},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            # --------------------------------------------------------------------
            # POST /hardware/panel/2/wartungsvertrag/create/
            GET = MultiValueDict({})
            POST = MultiValueDict({'ende': [''], 'wartungsvertrag': [''], 'beginn': ['']})
            response, context = runner.get_response('/hardware/panel/2/wartungsvertrag/create/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=7e4757cfa8850aca7b166cceca6ebfe8;'),
            'status_code': 200})
            assert runner.check_context(response, context, {'form': {'_inline_collections': None,
                    'advisory_dict': {},
                    'data': MultiValueDict({'ende': [None], 'wartungsvertrag': [None], 'beginn': [None]}),
                    'edit_inline': True,
                    'error_dict': {'beginn': ['Bitte dieses Feld ausf\xc3\xbcllen.'],
                                    'wartungsvertrag': ['Bitte dieses Feld ausf\xc3\xbcllen.']},
                    'manipulator': '<kundebunt.hardware.forms.HWWartungsvertragAddForm object>'},
            'hardware': '<Hardware: 2 Enoraix 002 (zwei) [#D000002] @ RZ2, rack2, HE 5+2>',
            'id_prefix': 'wvnew2_',
            'in_panel': True,
            'messages': [],
            'person': '<Person: fany, Herr Martin H. Sluka>',
            'user': '<User: fany>'})
            
            
