# -*- encoding: UTF-8 -*-

"""
Testet die verschiedenen Suchmöglichkeiten für Hardware.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.tests.fixtures.hardware import *

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')


class TestHardware(HardwareFixture):
    def test_suche_alles(self):
        """Anzeige aller Hardware im Panel"""
        # --------------------------------------------------------------------
        # GET /hardware/
        response, context = runner.get_response('/hardware/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'location': 'search',
        'status_code': 301})
        # --------------------------------------------------------------------
        # GET /hardware/search
        response, context = runner.get_response('/hardware/search', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(''),
        'location': 'http://127.0.0.1:8000/hardware/search/',
        'status_code': 301})
        # --------------------------------------------------------------------
        # GET /hardware/search/
        response, context = runner.get_response('/hardware/search/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'aktiv': '*',
                        'eigentuemer': '*',
                        'hardware_id': '*',
                        'info': '*',
                        'ip': '*',
                        'ivnr': '*',
                        'klasse': '*',
                        'kunde': '*',
                        'lieferant': '*',
                        'mit_unterkunden': True,
                        'name': '*',
                        'rack': '*',
                        'rz': '*',
                        'seriennr': '*',
                        'standort': '*',
                        'status': '*',
                        'typ': '*',
                        'verantwortlich': '*'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWSearchForm object>'},
        'in_panel': False,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/search/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'name': ['*'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/hardware/panel/search/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': '<django.utils.datastructures.MergeDict object>',
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWSearchForm object>'},
        'in_panel': True,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr":"000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})

    def test_leerstrings(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': [''],
        'hardware_id': [''],
        'info': [''],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': [''],
        'lieferant': [''],
        'name': [''],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': [''],
        'rz': [''],
        'seriennr': [''],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, ]})


    def test_suche_hardware_id(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*001'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['-'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_suche_ivnr(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*2'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['-'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_suche_name(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*3*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['-'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['-'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})


    def test_suche_ip(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.0.0'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.0.0/24'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr":"000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.0.0/16'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 3, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.128/17'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.0.*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['eins'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['-'],
        'ivnr': ['-'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})


    def test_suche_kunde(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['1'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['dadad'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['sluka'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*Sluka'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['checkts'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['1'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['-'],
        'klasse': ['*'],
        'kunde': ['-'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})

    def test_suche_verantwortlich(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['fany']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['-']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 3, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*5'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['-']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})

    def test_suche_eigentuemer(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['fany'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['-'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})

    def test_suche_standort(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['-'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['-'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['-'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['fany'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_suche_rack(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['-'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*1'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})

    def test_suche_rz(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['RZ2'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['-'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 2, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_suche_ivnr(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['ab hier !!!'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['000001'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['-'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*1*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})

    def test_suche_info(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['-'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*!*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*%*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['w*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_suche_typ(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['-'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['6'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['11'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})

    def test_suche_klasse(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['1'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['-'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['3'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})

    def test_suche_lieferant(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['-'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['2'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['31'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})

    def test_suche_status(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['-'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['1'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 0, "data": []})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['5'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['-'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}]})

    class TestWithInactiveHardware(WithInactiveHardware):
        def test_suche_aktiv(self):
            # --------------------------------------------------------------------
            # POST /popkern/data/hardware/
            GET = MultiValueDict({})
            POST = MultiValueDict({'aktiv': ['egal'],
            'eigentuemer': ['*'],
            'hardware_id': ['*'],
            'info': ['*'],
            'ip': ['*'],
            'ivnr': ['*'],
            'klasse': ['*'],
            'kunde': ['*'],
            'lieferant': ['*'],
            'more': ['on'],
            'name': ['*'],
            'page': ['1'],
            'pageSize': ['25'],
            'rack': ['*'],
            'rz': ['*'],
            'seriennr': ['*'],
            'sortColumn': [''],
            'sortDir': [''],
            'standort': ['*'],
            'status': ['*'],
            'typ': ['*'],
            'verantwortlich': ['*']})
            response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
            'status_code': 200})
            assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
            # --------------------------------------------------------------------
            # POST /popkern/data/hardware/
            GET = MultiValueDict({})
            POST = MultiValueDict({'aktiv': ['nur_aktiv'],
            'eigentuemer': ['*'],
            'hardware_id': ['*'],
            'info': ['*'],
            'ip': ['*'],
            'ivnr': ['*'],
            'klasse': ['*'],
            'kunde': ['*'],
            'lieferant': ['*'],
            'more': ['on'],
            'name': ['*'],
            'page': ['1'],
            'pageSize': ['25'],
            'rack': ['*'],
            'rz': ['*'],
            'seriennr': ['*'],
            'sortColumn': [''],
            'sortDir': [''],
            'standort': ['*'],
            'status': ['*'],
            'typ': ['*'],
            'verantwortlich': ['*']})
            response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
            assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
            'status_code': 200})
            assert runner.check_datasource(response, {"total_count": 4, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})

    def test_order_hardware_id(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['1'],
        'sortDir': ['ASC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id":   "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['1'],
        'sortDir': ['DESC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, ]})

    def test_order_name(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['3'],
        'sortDir': ['ASC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['3'],
        'sortDir': ['DESC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST'
        , GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002","ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})

    def test_order_ip(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['4'],
        'sortDir': ['ASC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['4'],
        'sortDir': ['DESC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

    def test_order_kunde(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['5'],
        'sortDir': ['ASC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "ivnr": "000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "ivnr": "000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP","id": "2"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "ivnr": "000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4"}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "ivnr": "000005","standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5"}, {"name": "Deusexmachina 003", "ip": "","hardware_id": "", "ivnr": "", "standort": "fany", "kunde": "sluka", "id": "3"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['5'],
        'sortDir': ['DESC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "ivnr": "", "standort": "fany", "kunde": "sluka", "id": "3"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "ivnr": "000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "ivnr": "000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "ivnr": "000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4"}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "ivnr": "000005", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5"}]})

    def test_order_standort(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['6'],
        'sortDir': ['ASC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': ['6'],
        'sortDir': ['DESC'],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=51d7958df460e2f962422a7747352418;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 5, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}, {"name": "Enoraix 002", "ip": "zwei", "hardware_id": "D000002", "standort": "RZ2, rack2, HE 5+2", "kunde": "POP", "id": "2", "ivnr": "000002"}, {"name": "Caesar 004", "ip": "drei", "hardware_id": "D000004", "standort": "RZ1, rack2, HE 7+2", "kunde": "POP", "id": "4", "ivnr": "000004"}, {"name": "Fubrikator 001", "ip": "eins", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1", "ivnr": "000001"}, {"name": "Deusexmachina 003", "ip": "", "hardware_id": "", "standort": "fany", "kunde": "sluka", "id": "3", "ivnr": ""}]})

