    
# -*- encoding: UTF-8 -*-

"""
Testet die Detail-Panels (Ajax) für Hardware.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.tests.fixtures.hardware import *

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')


class TestHardware(HardwareFixture):

    def test_autocompletions(self):
        # --------------------------------------------------------------------
        # GET /popkern/data/ipkunde/
        GET = MultiValueDict({'query': ['eins']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/popkern/data/ipkunde/', 'GET', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"data": [{"name": "eins"}]})


    def test_display_panel(self):
        # --------------------------------------------------------------------
        # GET /hardware/panel/1/
        response, context = runner.get_response('/hardware/panel/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000001',
                        'id': 1L,
                        'info': None,
                        'ip': 'eins',
                        'ivnr': '000001',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': 'A1',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        assert runner.body_contains_link(response, "javascript:ResultGridLoader.showDetails(5, 'Brunsbüttel 005')")
        assert runner.body_contains_link(response, "https://intra.office.noris.de/cgi-bin/technik/housing-db/db.cgi?action=edit_hw;hw=1")
        assert runner.body_contains_link(response, "https://intra.office.noris.de/cgi-bin/technik/housing-db/db.cgi?action=show_rack;rack=1")
        # --------------------------------------------------------------------
        # GET /hardware/panel/5/
        response, context = runner.get_response('/hardware/panel/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': None,
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel 005',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})        # --------------------------------------------------------------------
        # GET /hardware/panel/3/
        response, context = runner.get_response('/hardware/panel/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': None,
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': '<Person: fany, Herr Martin H. Sluka>',
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware: 3 Deusexmachina 003 @ fany>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})        # --------------------------------------------------------------------
        # GET /hardware/panel/5/
        response, context = runner.get_response('/hardware/panel/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': None,
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel 005',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        
    def test_edit_errors(self):
        # --------------------------------------------------------------------
        # POST /hardware/panel/3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['fany'],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': ['wichtig!'],
        'ip': ['eins'],
        'ivnr': ['000001'],
        'klasse': ['2'],
        'kunde': ['wally'],
        'lieferant': ['KK Computer'],
        'name': [''],
        'rack': [''],
        'rz': [''],
        'seriennr': ['B2'],
        'standort': ['fany'],
        'status': ['1'],
        'typ': ['5'],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/3/', 'POST', GET, POST)
        pprint(context)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {'seriennr': ['Die gleiche Serien-Nr. gibt es bei <a href="javascript:ResultGridLoader.showDetails(2, \'Enoraix 002\')">dieser Hardware</a>. Kann nat\xc3\xbcrlich Zufall sein ...']},
                'data': MultiValueDict({'status': [1], 'verantwortlich': [None], 'ip': ['eins'], 'standort': ['<Person: fany, Herr Martin H. Sluka>'], 'lieferant': ['KK Computer'], 'typ': [5], 'id': [None], 'info': ['wichtig!'], 'enthalten_in': [''], 'name': [''], 'hardware_id': ['D000001'], 'ivnr': ['000001'], 'rz': [''], 'seriennr': ['B2'], 'klasse': [2], 'aktiv': [None], 'kunde': ['wally'], 'eigentuemer': ['<Person: fany, Herr Martin H. Sluka>'], 'rack': ['']}),
                'edit_inline': True,
                'error_dict': {'hardware_id': ['Die hardware_id ist bereits f\xc3\xbcr <a href="javascript:ResultGridLoader.showDetails(1, \'Fubrikator 001\')">diese Hardware</a> vergeben.'],
                                'ip': ['Die IP "eins" ist bereits an <a href="javascript:ResultGridLoader.showDetails(1, \'Fubrikator 001\')">diese Hardware</a> vergeben.'],
                                'ivnr': ['Die Inventar-Nr. ist bereits f\xc3\xbcr <a href="javascript:ResultGridLoader.showDetails(1, \'Fubrikator 001\')">diese Hardware</a> vergeben.'],
                                'name': ['Bitte dieses Feld ausfüllen.']},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware: 3 Deusexmachina 003 @ fany>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
class TestHardware2(HardwareFixture):
    def test_edit_ok(self):
        # --------------------------------------------------------------------
        # POST /hardware/panel/3/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['3050'],
        'enthalten_in': [''],
        'hardware_id': [''],
        'info': ['wichtig!'],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Deusexmachina 003'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['C3'],
        'standort': ['3050 (Blabla)'],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['fany']})
        response, context = runner.get_response('/hardware/panel/3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'location': '/hardware/panel/3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/3/
        response, context = runner.get_response('/hardware/panel/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=3f2b68a3bfc821d057a2090508735019;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
            'copy_url': '-javascript-',
            'wartungsvertraege': [],
            'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': None,
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig!',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': '<Person: fany, Herr Martin H. Sluka>',
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 3 Deusexmachina 003 @ fany>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        
def TestHardware3(HardwareFixture):
    def test_edit_ip(self):
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': ['zwei'],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({'status': [None], 'verantwortlich': [''], 'ip': ['zwei'], 'standort': [''], 'lieferant': [None], 'typ': [None], 'info': [''], 'enthalten_in': [''], 'name': ['Fubrikator 001'], 'hardware_id': ['D000001'], 'ivnr': ['000001'], 'rz': ['RZ1'], 'seriennr': ['A1'], 'klasse': [None], 'aktiv': [None], 'kunde': ['POP'], 'eigentuemer': [''], 'rack': ['rack1']}),
                'edit_inline': True,
                'error_dict': {'ip': ['Die IP "zwei" ist bereits an <a href="javascript:ResultGridLoader.showDetails(2, \'Enoraix 002\')">diese Hardware</a> vergeben.']},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware:     1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': ['192.168.3.8'],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'location': '/hardware/panel/1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/1/
        response, context = runner.get_response('/hardware/panel/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000001',
                        'info': '',
                        'ip': '192.168.3.8',
                        'ivnr': '000001',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': 'A1',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware:     1 Fubrikator 001 (192.168.3.8) [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['192.168.3.*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 001", "ip": "192.168.3.8", "hardware_id": "D000001", "standort": "RZ1, rack1, HE 0+5", "kunde": "POP", "id": "1"}]})
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': [''],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'location': '/hardware/panel/1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/1/
        response, context = runner.get_response('/hardware/panel/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000001',
                        'info': '',
                        'ip': None,
                        'ivnr': '000001',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': 'A1',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware:     1 Fubrikator 001 [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': ['256.0.0.0'],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({'status': [None], 'verantwortlich': [''], 'ip': ['256.0.0.0'], 'standort': [''], 'lieferant': [None], 'typ': [None], 'info': [''], 'enthalten_in': [''], 'name': ['Fubrikator 001'], 'hardware_id': ['D000001'], 'ivnr': ['000001'], 'rz': ['RZ1'], 'seriennr': ['A1'], 'klasse': [None], 'aktiv': [None], 'kunde': ['POP'], 'eigentuemer': [''], 'rack': ['rack1']}),
                'edit_inline': True,
                'error_dict': {'ip': ['"256.0.0.0" ist nicht in der Datenbank eingetragen. Bitte entweder eine vorhandene numerische IP-Adresse (z.B. "1.2.3.4") oder einen in die Datenbank eingetragenen FQDN eingeben. ']},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware:     1 Fubrikator 001 [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': ['256..'],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({'status': [None], 'verantwortlich': [''], 'ip': ['256..'], 'standort': [''], 'lieferant': [None], 'typ': [None], 'info': [''], 'enthalten_in': [''], 'name': ['Fubrikator 001'], 'hardware_id': ['D000001'], 'ivnr': ['000001'], 'rz': ['RZ1'], 'seriennr': ['A1'], 'klasse': [None], 'aktiv': [None], 'kunde': ['POP'], 'eigentuemer': [''], 'rack': ['rack1']}),
                'edit_inline': True,
                'error_dict': {'ip': ['"256.." ist nicht in der Datenbank eingetragen. Bitte entweder eine vorhandene numerische IP-Adresse (z.B. "1.2.3.4") oder einen in die Datenbank eingetragenen FQDN eingeben. ']},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': [],
        'object': '<Hardware:     1 Fubrikator 001 [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/1/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': [''],
        'hardware_id': ['D000001'],
        'info': [''],
        'ip': ['eins'],
        'ivnr': ['000001'],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': [''],
        'name': ['Fubrikator 001'],
        'rack': ['rack1'],
        'rz': ['RZ1'],
        'seriennr': ['A1'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/1/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'location': '/hardware/panel/1/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/1/
        response, context = runner.get_response('/hardware/panel/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=cea7984be474bf8e4d14fb83dc09f783;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware:     5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000001',
                        'info': '',
                        'ip': 'eins',
                        'ivnr': '000001',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': 'A1',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware:     1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})

class TestHardware4(HardwareFixture):
    def test_copy_create(self):
        # --------------------------------------------------------------------
        # GET /hardware/panel/copy/1/
        response, context = runner.get_response('/hardware/panel/copy/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'copying': True,
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'ek_waehrung': 'EUR',
                        'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': '',
                        'id': '',
                        'info': None,
                        'ip': '',
                        'ivnr': '',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': '',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWCopyForm object>'},
        'id_prefix': 'hwnew_',
        'in_panel': True,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/panel/create/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'ek_waehrung': ['EUR'],
        'hardware_id': ['D000006'],
        'info': [''],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['POP'],
        'lieferant': ['KK Computer'],
        'name': ['Fubrikator 006'],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': ['1'],
        'typ': [''],
        'verantwortlich': ['fany (Herr Martin H. Sluka)']})
        response, context = runner.get_response('/hardware/panel/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'location': '/hardware/panel/6/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/6/
        response, context = runner.get_response('/hardware/panel/6/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {'standort': ['Die Hardware hat noch keinen Standort. Das wird der Buchhaltung nicht gefallen.']},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000006',
                        'id': 6L,
                        'info': '',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Fubrikator 006',
                        'rack': None,
                        'rz': None,
                        'seriennr': None,
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '6',
        'id_prefix': 'hw6_',
        'in_panel': True,
        'messages': [Ellipsis, Ellipsis],
        'object': '<Hardware: 6 Fubrikator 006 [#D000006]>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*6'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Fubrikator 006", "ip": "", "hardware_id": "D000006", "standort": "", "kunde": "POP", "id": "6", "ivnr": ""}]})

    def teardown_class(self):
        from kundebunt.popkern import models
        models.Hardware.objects.filter(pk=6).delete()
        super(self, TestHardware4).teardown_class()



class TestHardware5(HardwareFixture):
    def test_special_chars(self):
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*\xc3\xbc*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel 005", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
        # --------------------------------------------------------------------
        # POST /hardware/panel/5/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': ['    1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5'],
        'hardware_id': [''],
        'info': [''],
        'ip': ['vier'],
        'ivnr': ['000005'],
        'klasse': ['3'],
        'kunde': ['POP'],
        'lieferant': ['KK Computer'],
        'name': ['Brunsb\xc3\xbcttel&Co <005>'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['E5'],
        'standort': [''],
        'status': [''],
        'typ': ['6'],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/5/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'location': '/hardware/panel/5/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/5/
        response, context = runner.get_response('/hardware/panel/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': '',
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel&Co <005>',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel&Co <005> (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /hardware/panel/copy/5/
        response, context = runner.get_response('/hardware/panel/copy/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'copying': True,
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'ek_waehrung': 'EUR',
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': '',
                        'id': '',
                        'info': '',
                        'ip': '',
                        'ivnr': '',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel&Co <005>',
                        'rack': None,
                        'rz': None,
                        'seriennr': '',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWCopyForm object>'},
        'id_prefix': 'hwnew_',
        'in_panel': True,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*&*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel&amp;Co &lt;005&gt;", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
        # --------------------------------------------------------------------
        # POST /hardware/panel/5/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': ['    1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5'],
        'hardware_id': [''],
        'info': [''],
        'ip': ['vier'],
        'ivnr': ['000005'],
        'klasse': ['3'],
        'kunde': ['POP'],
        'lieferant': ['KK Computer'],
        'name': ['Brunsb\xc3\xbcttel%Co <005>'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['E5'],
        'standort': [''],
        'status': [''],
        'typ': ['6'],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/panel/5/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'location': '/hardware/panel/5/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/panel/5/
        response, context = runner.get_response('/hardware/panel/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '-javascript-',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': '',
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel%Co <005>',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': True,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel%Co <005> (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /popkern/data/hardware/
        GET = MultiValueDict({})
        POST = MultiValueDict({'aktiv': ['nur_aktiv'],
        'eigentuemer': ['*'],
        'hardware_id': ['*'],
        'info': ['*'],
        'ip': ['*'],
        'ivnr': ['*'],
        'klasse': ['*'],
        'kunde': ['*'],
        'lieferant': ['*'],
        'more': ['on'],
        'name': ['*%*'],
        'page': ['1'],
        'pageSize': ['25'],
        'rack': ['*'],
        'rz': ['*'],
        'seriennr': ['*'],
        'sortColumn': [''],
        'sortDir': [''],
        'standort': ['*'],
        'status': ['*'],
        'typ': ['*'],
        'verantwortlich': ['*']})
        response, context = runner.get_response('/popkern/data/hardware/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=05fda4c8ff3d78834b3f3a2850808333;'),
        'status_code': 200})
        assert runner.check_datasource(response, {"total_count": 1, "data": [{"name": "Brunsbüttel%Co &lt;005&gt;", "ip": "vier", "hardware_id": "", "standort": "in: D000001 (RZ1, rack1, HE 0+5)", "kunde": "POP", "id": "5", "ivnr": "000005"}]})
