# -*- encoding: UTF-8 -*-

"""
Testet, ob sich jemand Unbefugtes einloggen kann.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.tests.fixtures.hardware import *

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'checkts')

class TestWithHardware(HardwareFixture):
    def test_login_secure(self):
        # --------------------------------------------------------------------
        # GET /hardware/search/
        response, context = runner.get_response('/hardware/search/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/hardware/search/',
        'status_code': 403})
        # --------------------------------------------------------------------
        # GET /hardware/panel/search/
        response, context = runner.get_response('/hardware/panel/search/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/hardware/panel/search/',
        'status_code': 403})
        # --------------------------------------------------------------------
        # GET /hardware/1/
        response, context = runner.get_response('/hardware/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/hardware/1/',
        'status_code': 403})
        # --------------------------------------------------------------------
        # GET /hardware/copy/1/
        response, context = runner.get_response('/hardware/copy/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/hardware/copy/1/',
        'status_code': 403})
        # --------------------------------------------------------------------
        # GET /hardware/create/
        response, context = runner.get_response('/hardware/create/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/hardware/create/',
        'status_code': 403})
        # --------------------------------------------------------------------
        # GET /popkern/data/hardware/
        GET = MultiValueDict({'name': ['*']})
        POST = MultiValueDict({})
        response, context = runner.get_response('/popkern/data/hardware/', 'GET', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=857a6ecfdac1151f765d6dead137c511;'),
        'location': '/auth/login/?next=/popkern/data/hardware/',
        'status_code': 403})
