# -*- encoding: UTF-8 -*-

"""F_
Testet die Detailanzeige und Änderungen von Hardware, die nicht auf Ajax basieren.
Hier wird nur grob getestet, das meiste wird in test_hardware_panels erledigt.
"""

from pprint import pprint
from Cookie import SimpleCookie
from django.conf import settings
from django.http import HttpRequest
from django.utils.datastructures import MultiValueDict
from kundebunt.testutils.t_repr import t_repr
from kundebunt.tests.fixtures import base_setup, testclasses
from kundebunt.tests.fixtures.hardware import *

runner = None

def setup_module(module=None):
    global runner
    runner = base_setup.setup_module(module)
    base_setup.login(runner, 'fany')


class TestHardware(HardwareFixture):

    def test_display(self):
        # --------------------------------------------------------------------
        # GET /hardware/1/
        response, context = runner.get_response('/hardware/1/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=653bc99554d595b456425f5c2855b647;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': ['<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>'],
        'copy_url': '/hardware/copy/1/',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': None,
                        'hardware_id': 'D000001',
                        'id': 1L,
                        'info': None,
                        'ip': 'eins',
                        'ivnr': '000001',
                        'klasse': None,
                        'kunde': 'POP',
                        'lieferant': None,
                        'name': 'Fubrikator 001',
                        'rack': 'rack1',
                        'rz': 'RZ1',
                        'seriennr': 'A1',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '1',
        'id_prefix': 'hw1_',
        'in_panel': False,
        'messages': [],
        'object': '<Hardware: 1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': 1L,
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # GET /hardware/5/
        response, context = runner.get_response('/hardware/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=653bc99554d595b456425f5c2855b647;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '/hardware/copy/5/',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': None,
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel 005',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': None,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': False,
        'messages': [],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
    def test_edit(self):
        # --------------------------------------------------------------------
        # POST /hardware/5/
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': [''],
        'enthalten_in': ['    1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5'],
        'hardware_id': [''],
        'info': [''],
        'ip': ['vier'],
        'ivnr': ['000005'],
        'klasse': ['3'],
        'kunde': ['POP'],
        'lieferant': ['KK Computer'],
        'name': ['Brunsb\xc3\xbcttel 005'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['E5'],
        'standort': [''],
        'status': ['5'],
        'typ': ['6'],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/5/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=653bc99554d595b456425f5c2855b647;'),
        'location': '/hardware/5/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/5/
        response, context = runner.get_response('/hardware/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=653bc99554d595b456425f5c2855b647;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'enthaltene_hardware': [],
        'copy_url': '/hardware/copy/5/',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 5L,
                        'info': '',
                        'ip': 'vier',
                        'ivnr': '000005',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel 005',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'E5',
                        'standort': None,
                        'status': 5L,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '5',
        'id_prefix': 'hw5_',
        'in_panel': False,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 5 Brunsb\xc3\xbcttel 005 (vier) @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})
        
    def test_copy(self):
        # --------------------------------------------------------------------
        # GET /hardware/copy/5/
        response, context = runner.get_response('/hardware/copy/5/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=653bc99554d595b456425f5c2855b647;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'copying': True,
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'datum_lieferung': Ellipsis,
                        'eigentuemer': None,
                        'ek_waehrung': 'EUR',
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': '',
                        'id': '',
                        'info': '',
                        'ip': '',
                        'ivnr': '',
                        'klasse': 3L,
                        'kunde': 'POP',
                        'lieferant': 'KK Computer',
                        'name': 'Brunsb\xc3\xbcttel 005',
                        'rack': None,
                        'rz': None,
                        'seriennr': '',
                        'standort': None,
                        'status': 5L,
                        'typ': 6L,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWCopyForm object>'},
        'id_prefix': 'hwnew_',
        'in_panel': False,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})

    def test_create_errors(self):
        # --------------------------------------------------------------------
        # POST /hardware/create/
        GET = MultiValueDict({})
        POST = MultiValueDict({'artikelbezeichnung': [''],
        'buch_notiz': [''],
        'datum_bestellung': ['x'],
        'datum_lieferung': ['2007-04'],
        'eigentuemer': [''],
        'ek_waehrung': [''],
        'ek_kunde': ['2'],
        'ek_pop': [''],
        'hardware_id': ['D'],
        'info': [''],
        'ip': ['123'],
        'ivnr': ['2'],
        'klasse': [''],
        'kostenstelle': [''],
        'kunde': [''],
        'lieferant': [''],
        'name': [''],
        'originalpreis': ['5'],
        'rabatt': [''],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': [''],
        'typ': [''],
        'verantwortlich': [''],
        'vk_kunde': ['']})
        response, context = runner.get_response('/hardware/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d69d71ee6d64812653a622da0e2fe5fa;'),
        'status_code': 200})
        assert runner.check_context(response, context, {
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({'status': [None], 'verantwortlich': [None], 'ip': ['123'], 'rabatt': [None], 'artikelbezeichnung': [''], 'standort': [None], 'enthalten_in': [None], 'lieferant': [''], 'ticket': [None], 'typ': [None], 'id': [None], 'ek_kunde': ['2,00'], 'name': [''], 'info': [''], 'buch_notiz': [''], 'datum_bestellung': [None], 'vk_kunde': [None], 'ek_pop': [None], 'hardware_id': ['D'], 'datum_lieferung': [None], 'ivnr': ['2'], 'rz': [None], 'originalpreis': ['5,00'], 'kostenstelle': [''], 'seriennr': [''], 'klasse': [None], 'aktiv': [None], 'kunde': [''], 'eigentuemer': [None], 'rack': [None], 'ek_waehrung': ['']}),
                'edit_inline': True,
                'error_dict': {'datum_bestellung': ['Bitte ein g\xc3\xbcltiges Datum im Format JJJJ-MM-TT eingeben.'],
                                'datum_lieferung': ['Bitte ein g\xc3\xbcltiges Datum im Format JJJJ-MM-TT eingeben.'],
                                'ek_waehrung': ['Bitte dieses Feld ausfüllen.'],
                                'hardware_id': [u'Falsches Format! Eine Hardware-ID beginnt mit einem D, gefolgt von exakt 6 Ziffern.'],
                                'ivnr': [u'Falsches Format! Eine Inventarnummer besteht aus 6 oder 7 Ziffern.'],
                                'originalpreis': ['Mit den Einkaufspreisen stimmt etwas nicht. Es muss gelten: Originalpreis - Rabatt = EK POP + EK Kunde'],
                                'ip': ['"123" ist nicht in der Datenbank eingetragen. Bitte entweder eine vorhandene numerische IP-Adresse (z.B. "1.2.3.4") oder einen in die Datenbank eingetragenen FQDN eingeben. '],
                                'kunde': ['Bitte dieses Feld ausfüllen.'],
                                'name': ['Bitte dieses Feld ausfüllen.'],
                                'ticket': ['Bitte dieses Feld ausfüllen.']},
                'manipulator': '<kundebunt.hardware.forms.HWAddForm object>'},
        'id_prefix': 'hwnew_',
        'in_panel': False,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})

class TestWithHardware2(HardwareFixture):
    def test_create_success(self):
        # --------------------------------------------------------------------
        # POST /hardware/create/
        GET = MultiValueDict({})
        POST = MultiValueDict({'artikelbezeichnung': ['Testbla Extrafein Sorte B'],
        'buch_notiz': ['Keine'],
        'datum_bestellung': ['2007-04-01'],
        'datum_lieferung': ['2007-04-27'],
        'eigentuemer': ['fany'],
        'ek_waehrung': ['EUR'],
        'ek_kunde': ['300'],
        'ek_pop': ['97.01'],
        'enthalten_in': ['1'],
        'hardware_id': ['D100001'],
        'info': [''],
        'ip': [''],
        'ivnr': ['1000001'],
        'klasse': [''],
        'kostenstelle': ['kunde'],
        'kunde': [''],
        'lieferant': [''],
        'name': ['Testblabla extrafein'],
        'originalpreis': ['398'],
        'rabatt': ['0,99'],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': ['1'],
        'typ': [''],
        'verantwortlich': ['fany'],
        'vk_kunde': ['398,84']})
        response, context = runner.get_response('/hardware/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d69d71ee6d64812653a622da0e2fe5fa;'),
        'status_code': 200})
        assert runner.check_context(response, context, {
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': MultiValueDict({'status': [None], 'verantwortlich': ['<Person: fany, Herr Martin H. Sluka>'], 'ip': [''], 'rabatt': ['0,99'], 'artikelbezeichnung': ['Testbla Extrafein Sorte B'], 'standort': [None], 'enthalten_in': ['1'], 'lieferant': [''], 'ticket': [1], 'typ': [None], 'id': [None], 'ek_kunde': ['300,00'], 'name': ['Testblabla extrafein'], 'info': [''], 'buch_notiz': ['Keine'], 'datum_bestellung': ['datetime.date(2007, 4, 1)'], 'vk_kunde': ['398,84'], 'ek_pop': ['97,01'], 'hardware_id': ['D100001'], 'datum_lieferung': ['datetime.date(2007, 4, 27)'], 'ivnr': ['1000001'], 'rz': [None], 'originalpreis': ['398,00'], 'kostenstelle': ['kunde'], 'seriennr': [''], 'klasse': [None], 'aktiv': [None], 'kunde': [''], 'eigentuemer': ['<Person: fany, Herr Martin H. Sluka>'], 'rack': [None], 'ek_waehrung': ['EUR']}),
                'edit_inline': True,
                'error_dict': {'kunde': ['Bitte dieses Feld ausfüllen.']},
                'manipulator': '<kundebunt.hardware.forms.HWAddForm object>'},
        'id_prefix': 'hwnew_',
        'in_panel': False,
        'messages': [],
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'user': '<User: fany>'})
        # --------------------------------------------------------------------
        # POST /hardware/create/
        GET = MultiValueDict({})
        POST = MultiValueDict({'artikelbezeichnung': ['Testbla Extrafein Sorte B'],
        'buch_notiz': ['Keine'],
        'datum_bestellung': ['2007-04-01'],
        'datum_lieferung': ['2007-04-27'],
        'eigentuemer': ['fany (Herr Martin H. Sluka)'],
        'ek_waehrung': ['EUR'],
        'ek_kunde': ['300,00'],
        'ek_pop': ['97,01'],
        'enthalten_in': ['1'],
        'hardware_id': ['D100001'],
        'info': [''],
        'ip': [''],
        'ivnr': ['1000001'],
        'klasse': [''],
        'kostenstelle': ['kunde'],
        'kunde': ['wally'],
        'lieferant': [''],
        'name': ['Testblabla extrafein'],
        'originalpreis': ['398,00'],
        'rabatt': ['0,99'],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': ['1'],
        'typ': [''],
        'verantwortlich': ['fany (Herr Martin H. Sluka)'],
        'vk_kunde': ['398,84']})
        response, context = runner.get_response('/hardware/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d69d71ee6d64812653a622da0e2fe5fa;'),
        'location': '/hardware/6/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/6/
        response, context = runner.get_response('/hardware/6/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d69d71ee6d64812653a622da0e2fe5fa;'),
        'status_code': 200})
        assert runner.check_context(response, context, {
        'enthaltene_hardware': [],
        'copy_url': '/hardware/copy/6/',
        'wartungsvertraege': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {
                        'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': 'D100001',
                        'id': 6L,
                        'info': '',
                        'ip': None,
                        'ivnr': '1000001',
                        'klasse': None,
                        'kunde': 'wally',
                        'lieferant': None,
                        'name': 'Testblabla extrafein',
                        'rack': None,
                        'rz': None,
                        'seriennr': None,
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '6',
        'id_prefix': 'hw6_',
        'in_panel': False,
        'messages': ['Die E-Mail mit Daten für die Buchhaltung wurde erfolgreich versandt (To: mir@noris.de, mir+1@noris.de, Subject: Lieferung: #1 | 2007-04-01 | Testbla Extrafein Sorte B)',
                    'Der Datensatz wurde angelegt.'],
        'object': '<Hardware: 6 Testblabla extrafein [#D100001] @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>'})

    def teardown_class(self):
        from kundebunt.popkern import models
        models.Hardware.objects.filter(pk=6).delete()
        super(self, TestWithHardware2).teardown_class()


def TestWithHardware3(HardwareFixture):

    def teardown_class(self):
        from kundebunt.popkern import models
        models.Hardware.objects.filter(id__in=(6,7)).delete()
        super(self, TestWithHardware2).teardown_class()

    def test_einbau_verantwortlicher(self):
        """RT #340798, Vererbung des Verantwortlichen bei Einbau
        """
        # --------------------------------------------------------------------
        # POST /hardware/3/
        # - enthalten_in auf Hw mit Verantwortlichem setzen löst keine Vererbung
        #   aus, wenn die Hardware bereits einen Verantwortlichen hat.
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['fany (Herr Martin H. Sluka)'],
        'enthalten_in': ['4'],
        'hardware_id': [''],
        'id': ['3'],
        'info': ['wichtig'],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Deusexmachina 003'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['C3'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['fany (Herr Martin H. Sluka)']})
        response, context = runner.get_response('/hardware/3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/3/
        response, context = runner.get_response('/hardware/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6aea38c>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6aea04c>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6aea50c>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/3/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': '4 Caesar 004 (drei) [#D004] @ RZ1, rack2, HE 7+2',
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': False,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 3 Deusexmachina 003 @ in: D004 (RZ1, rack2, HE 7+2)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})
        # --------------------------------------------------------------------
        # POST /hardware/3/
        # - Solange enthalten_in nicht verändert wird, wird auch keine Vererbung ausgelöst.
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['fany (Herr Martin H. Sluka)'],
        'enthalten_in': ['4 Caesar 004 (drei) [#D004] @ RZ1, rack2, HE 7+2'],
        'hardware_id': [''],
        'id': ['3'],
        'info': ['wichtig'],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Deusexmachina 003'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['C3'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/3/
        response, context = runner.get_response('/hardware/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6a8aeec>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a8afcc>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a8a06c>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/3/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': '4 Caesar 004 (drei) [#D004] @ RZ1, rack2, HE 7+2',
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': False,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 3 Deusexmachina 003 @ in: D004 (RZ1, rack2, HE 7+2)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})
        # --------------------------------------------------------------------
        # POST /hardware/3/
        # - Setzen von enthalten_in auf ein Hardware ohne Verantwortlichen löst
        #   auch keine Vererbung aus.
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['fany (Herr Martin H. Sluka)'],
        'enthalten_in': ['1'],
        'hardware_id': [''],
        'id': ['3'],
        'info': ['wichtig'],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Deusexmachina 003'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['C3'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/3/
        response, context = runner.get_response('/hardware/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6a75b2c>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a7526c>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a75ecc>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/3/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': '1 Fubrikator 001 (eins) [#D000001] @ RZ1, rack1, HE 0+5',
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': None},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': False,
        'messages': ['Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 3 Deusexmachina 003 @ in: D000001 (RZ1, rack1, HE 0+5)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})
        # --------------------------------------------------------------------
        # POST /hardware/3/
        # - Jetzt sind alle Bedingungen für Vererbung erfüllt.
        GET = MultiValueDict({})
        POST = MultiValueDict({'eigentuemer': ['fany (Herr Martin H. Sluka)'],
        'enthalten_in': ['4'],
        'hardware_id': [''],
        'id': ['3'],
        'info': ['wichtig'],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Deusexmachina 003'],
        'rack': [''],
        'rz': [''],
        'seriennr': ['C3'],
        'standort': [''],
        'status': [''],
        'typ': [''],
        'verantwortlich': ['']})
        response, context = runner.get_response('/hardware/3/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/3/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/3/
        response, context = runner.get_response('/hardware/3/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6aeafac>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6aeab2c>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6aea12c>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/3/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': '<Person: fany, Herr Martin H. Sluka>',
                        'enthalten_in': '4 Caesar 004 (drei) [#D004] @ RZ1, rack2, HE 7+2',
                        'hardware_id': None,
                        'id': 3L,
                        'info': 'wichtig',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Deusexmachina 003',
                        'rack': None,
                        'rz': None,
                        'seriennr': 'C3',
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '3',
        'id_prefix': 'hw3_',
        'in_panel': False,
        'messages': ['Der Verantwortliche wurde automatisch von der enthaltenden Hardware übernommen.',
                    'Ihre Eingaben wurden gesichert.'],
        'object': '<Hardware: 3 Deusexmachina 003 @ in: D004 (RZ1, rack2, HE 7+2)>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})
        # --------------------------------------------------------------------
        # POST /hardware/create/
        # - Anlegen von eingebauter Hardware darf keine Vererbung auslösen,
        #   wenn dabei ein Verantwortlicher eingebaut wird.
        GET = MultiValueDict({})
        POST = MultiValueDict({'artikelbezeichnung': [''],
        'buch_notiz': [''],
        'datum_bestellung': [''],
        'datum_lieferung': [''],
        'eigentuemer': [''],
        'ek_kunde': [''],
        'ek_pop': [''],
        'ek_waehrung': ['EUR'],
        'enthalten_in': ['3'],
        'hardware_id': [''],
        'info': [''],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kostenstelle': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Neu, eingebaut'],
        'originalpreis': [''],
        'rabatt': [''],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': ['1'],
        'typ': [''],
        'verantwortlich': ['checkts'],
        'vk_kunde': ['']})
        response, context = runner.get_response('/hardware/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/6/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/6/
        response, context = runner.get_response('/hardware/6/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6a8404c>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a8402c>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a840ac>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/6/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': None,
                        'enthalten_in': '3 Deusexmachina 003 @ in: D004 (RZ1, rack2, HE 7+2)',
                        'hardware_id': None,
                        'id': 6L,
                        'info': '',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Neu, eingebaut',
                        'rack': None,
                        'rz': None,
                        'seriennr': None,
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: checkts, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '6',
        'id_prefix': 'hw6_',
        'in_panel': False,
        'messages': ['Die E-Mail mit Daten f\xc3\xbcr die Buchhaltung wurde erfolgreich versandt (To: mir@noris.de, mir+1@noris.de, Subject: Lieferung: #1)',
                    'Der Datensatz wurde angelegt.'],
        'object': '<Hardware: 6 Neu, eingebaut @ in: #3 (in: D004 (RZ1, rack2, HE 7+2))>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})
        # --------------------------------------------------------------------
        # POST /hardware/create/
        # - Anlegen von Hardware mit Vererbung.
        GET = MultiValueDict({})
        POST = MultiValueDict({'artikelbezeichnung': [''],
        'buch_notiz': [''],
        'datum_bestellung': [''],
        'datum_lieferung': [''],
        'eigentuemer': [''],
        'ek_kunde': [''],
        'ek_pop': [''],
        'ek_waehrung': ['EUR'],
        'enthalten_in': ['3'],
        'hardware_id': [''],
        'info': [''],
        'ip': [''],
        'ivnr': [''],
        'klasse': [''],
        'kostenstelle': [''],
        'kunde': ['sluka'],
        'lieferant': [''],
        'name': ['Neu, eingebaut, Vererbung'],
        'originalpreis': [''],
        'rabatt': [''],
        'seriennr': [''],
        'standort': [''],
        'status': [''],
        'ticket': ['1'],
        'typ': [''],
        'verantwortlich': [''],
        'vk_kunde': ['']})
        response, context = runner.get_response('/hardware/create/', 'POST', GET, POST)
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'location': '/hardware/7/',
        'status_code': 302})
        # --------------------------------------------------------------------
        # GET /hardware/7/
        response, context = runner.get_response('/hardware/7/', 'GET', {}, {})
        assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=d08e7f823a03226c7969ccf7f40d4bd5;'),
        'status_code': 200})
        assert runner.check_context(response, context, {'block': '<Block Node: content. Contents: [<Text Node: \'\n<h1>\'>, <django.templatetags.noris_extra.NaviTextNode object at 0xb6a6624c>, <Text Node: \'</h1>\n<form method="post"\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a661ec>, <Text Node: \'\n\'>, <django.template.loader_tags.ConstantIncludeNode object at 0xb6a660cc>, <Text Node: \'\n</form>\n\n\'>, <If node>, <Text Node: \'\n\n\'>]>',
        'copy_url': '/hardware/copy/7/',
        'enthaltene_hardware': [],
        'form': {'_inline_collections': None,
                'advisory_dict': {},
                'data': {'eigentuemer': None,
                        'enthalten_in': '3 Deusexmachina 003 @ in: D004 (RZ1, rack2, HE 7+2)',
                        'hardware_id': None,
                        'id': 7L,
                        'info': '',
                        'ip': None,
                        'ivnr': None,
                        'klasse': None,
                        'kunde': 'sluka',
                        'lieferant': None,
                        'name': 'Neu, eingebaut, Vererbung',
                        'rack': None,
                        'rz': None,
                        'seriennr': None,
                        'standort': None,
                        'status': None,
                        'typ': None,
                        'verantwortlich': '<Person: fany, Herr Martin H. Sluka>'},
                'edit_inline': True,
                'error_dict': {},
                'manipulator': '<kundebunt.hardware.forms.HWChangeForm object>'},
        'id': '7',
        'id_prefix': 'hw7_',
        'in_panel': False,
        'messages': ['Der Verantwortliche wurde automatisch von der enthaltenden Hardware übernommen.',
                    'Die E-Mail mit Daten f\xc3\xbcr die Buchhaltung wurde erfolgreich versandt (To: mir@noris.de, mir+1@noris.de, Subject: Lieferung: #1)',
                    'Der Datensatz wurde angelegt.'],
        'object': '<Hardware: 7 Neu, eingebaut, Vererbung @ in: #3 (in: D004 (RZ1, rack2, HE 7+2))>',
        'person': '<Person: fany, Herr Martin H. Sluka>',
        'rack_id': None,
        'user': '<User: fany>',
        'wartungsvertraege': []})