# -*- encoding: utf-8 -*-

"""Serializer to create json fixtures"""
from django.core.serializers.json import Serializer
from kundebunt.popkern.fields import CharDescriptorField

class KundebuntJSONSerializer(Serializer):
    """Der mit Django mitgelieferte Serializer scheitert an CharDescriptorFields,
    weil das halt im Prinzip ein ForeignKey ist, aber halt doch keiner (siehe
    Klasse CharDescriptorField).
    """
    def handle_field(self, obj, field):
        if isinstance(field, CharDescriptorField):
            val = getattr(obj, field.attname)
            if val is not None:
                val = ord(val)
            self._current[field.name] = val
        else:
            super(KundebuntJSONSerializer, self).handle_field(obj, field)

def serialize_json(queryset, **options):
    serializer = KundebuntJSONSerializer()
    serializer.serialize(queryset, **options)
    return serializer.getvalue()
