#!/usr/bin/python
# -*- encoding: utf-8 -*-

"""sets up a small test database
"""

import datetime, sys, os
from MySQLdb import OperationalError
from django import db
from django.core.management import call_command
from django.conf import settings
from django.test.utils import setup_test_environment
from kundebunt import testutils

def setup_module(module):
    #assert settings.VIEW_TEST
    settings.LANGUAGE_CODE='de'
    setup_database(always_createdb=False)
    runner = testutils.TestRunner()
    from django.db import connection
    cursor = connection.cursor()
    cursor.execute("alter table mailrules auto_increment=164")
    cursor.execute("alter table person auto_increment=3083")
    cursor.execute("alter table updatelog auto_increment=1")
    setup_test_environment()
    #cursor.execute("insert into kundemail (dienst, kunde, person) values (18, 744,3381)")
    #cursor.execute("insert into kundemail (dienst, kunde, person) values (19, 1014,3381)")
    #cursor.execute("update person set kunde=1 where user='checkts'")
    login(runner, 'checkts')
    return runner

def setup_database(always_createdb=False):
    """erzeugt die DB, wenn nötig, oder verwirft alle existierenden Daten, und
    fügt dann ein Minimum an Testdaten ein.
    """
    from django.db import transaction
    if always_createdb or not test_db_seems_valid():
        createdb()
    settings.DATABASE_NAME = settings.TEST_DATABASE_NAME
    cursor = db.connection.cursor()
    db.connection.connection.autocommit(1)
    cursor.execute("select count(*) from kunde")
    count = cursor.fetchone()[0]
    if count > 50:
        print "Zuviele Kunden. Das sieht mir nicht nach einer Testdatenbank aus."
        abort_test()
    data=__import__('kundebunt.tests.fixtures.base_setup_data','','',[''])
    MODEL_DATA = [ data.KUNDE_DATA, data.OPEN_XCHANGE_LOG_DATA, data.OPEN_XCHANGE_DATA,
                   data.LAND_DATA, data.ADRESSE_DATA, data.PERSON_DATA, data.DIENST_DATA,
                   data.KUNDEMAIL_DATA, data.DOMAINKUNDE_DATA, data.MAILRULE_DATA,
                   data.DB_TABELLE_DATA,data.UPDATELOG_SPALTEN_DATA, data.UPDATELOG_DATA,
                   data.AUTH_MESSAGE_DATA,
                   data.RZ_DATA, data.RACK_DATA, data.IPKUNDE_DATA, data.HARDWARE_DATA,
                   data.WARTUNGSVERTRAG_DATA, data.WARTUNGSVERTRAG_HARDWARE_DATA,
                   data.UUCPKUNDE_DATA
                 ]
    print "truncating tables ..."
    transaction.enter_transaction_management()
    cursor.execute("update kunde set hauptperson=null, billc=null, adminc=null, ap_technik=null, ap_vertrieb=null")
    cursor.execute("update person set mperson=null")
    for table, initial_data, more_data in reversed(MODEL_DATA):
        print "truncating %s ..." % table
        try:
            cursor.execute("truncate %s" % table)
        except (db.IntegrityError, OperationalError):
            print "truncate %s failed, trying ..." % table
            try:
                cursor.execute("delete from %s order by id desc" % table)
                print "delete worked. Wow, what a database."
            except (db.IntegrityError, OperationalError):
                print "Didn't work. Let's find the culprit."
                cursor.execute("select id from %d order by id desc" % table)
                for (p,) in cursor.fetchall():
                    try:
                        cursor.execute("delete from %s where id=%d" % (table, p))
                    except (db.IntegrityError, OperationalError):
                        print "deleting %s #%d failed, making a new database (sigh)." % (table, p)
                        db.connection.connection.commit()
                        createdb()
                        return
        db.connection.connection.commit()
            
    print "filling minimal table data ..."
    for model, initial_data, more_data in MODEL_DATA:
        print model
        insert_data(model, initial_data)
        transaction.commit()
    transaction.leave_transaction_management()

def test_db_seems_valid():
    old_database_name = settings.DATABASE_NAME
    settings.DATABASE_NAME = settings.TEST_DATABASE_NAME
    try:
        cursor = db.connection.cursor()
    except:
        settings.DATABASE_NAME = old_database_name
        return False
    try:
        cursor.execute("select count(*) from descr")
        count = cursor.fetchone()[0]
        assert count == 1127
        cursor.execute("select count(*) from kunde")
        count = cursor.fetchone()[0]
        assert count > 0
        db.connection.close()
        settings.DATABASE_NAME = old_database_name
        return True
    except:
        db.connection.close()
        settings.DATABASE_NAME = old_database_name
        return False


def createdb():
    """Erzeugt eine neue Test-Datenbank. Außerdem werden die Tabellen angelegt,
    die Deskriptoren befüllt und der User-Eintrag für den Adminzugang erzeugt.
    """
    from StringIO import StringIO
    from django.contrib.auth.models import User

    if settings.DATABASE_ENGINE == "sqlite3":
        settings.DATABASE_NAME = ":memory:"
    else:
        cursor = db.connection.cursor()
        try:
            db.connection.connection.autocommit(1)
        except:
            pass
        try:
            cursor.execute("CREATE DATABASE %s CHARACTER SET latin1" % settings.TEST_DATABASE_NAME)
        except Exception, e:

            sys.stderr.write("Got an error creating the test database: %s\n" % e)
            if settings.TEST_DATABASE_NAME.startswith('test_'):
                confirm = "yes"
            else:
                confirm = raw_input("It appears the test database, %s, already exists. Type 'yes' to delete it, or 'no' to cancel: " % settings.TEST_DATABASE_NAME)
            if confirm == 'yes':
                cursor.execute("DROP DATABASE %s" % settings.TEST_DATABASE_NAME)
                cursor.execute("CREATE DATABASE %s CHARACTER SET latin1" % settings.TEST_DATABASE_NAME)
            else:
                abort_test()
    db.connection.close()
    settings.DATABASE_NAME = settings.TEST_DATABASE_NAME

    print "creating descr tables"
    descr_data=__import__('kundebunt.tests.fixtures.base_descr_data','','',[''])

    create_descr_tables()
    insert_data("descr_typ", descr_data.DESCRTYP_DATA)
    insert_data("descr", descr_data.DESCR_DATA)

    call_command( "syncdb", interactive = False )
    admin=User(username="mir", is_staff=True, is_superuser=True)
    admin.set_password("mir")
    admin.save()


def abort_test():
    try:
        db.connection.close()
    except:
        pass
    settings.DATABASE_NAME = ''
    sys.stderr.write("Tests cancelled.\n")
    os.abort()


def insert_data(table, data):
    """Fügt eine Liste von Records (dicts) per direktes INSERT ein."""
    if not data:
        return
    cursor = db.connection.cursor()
    fields = data[0].keys()
    print "inserting into %s, %d records" % (table, len(data))
    sql = "insert into %s (%s) values (%s)" % (table, ",".join(fields), ",".join(["%s"] * len(fields)))
    cursor.cursor.executemany(sql,[[row[k] for k in fields] for row in data])


def create_descr_tables():
    """Anlegen der Tabellen für die Deskriptoren.
    Dies muss vor dem Importieren von models geschehen, ansonsten sind die Caches für die
    Deskriptoren kaputt.
    """
    cursor = db.connection.cursor()
    for sql in DESCR_SCHEMA_SQL:
        cursor.execute(sql)


DESCR_SCHEMA_SQL = [
"""CREATE TABLE descr (
    id integer NOT NULL PRIMARY KEY,
    typ integer NOT NULL,
    descr integer NOT NULL,
    idchar varchar(1),
    bla varchar(90) NOT NULL,
    gruppe integer NOT NULL,
    infotext varchar(255),
    timestamp datetime,
    KEY(descr)
);
""",
"""CREATE TABLE descr_typ (
    id integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    name varchar(30) NOT NULL UNIQUE,
    info varchar(255) NULL,
    timestamp datetime
);
"""
]


def login(runner, username):
    """Holt sich mit dem TestRunner `runner` eine neue Session und loggt sich ein."""
    from Cookie import SimpleCookie
    from django.utils.datastructures import MultiValueDict

    # fetch session test cookie
    # --------------------------------------------------------------------
    # GET /auth/login/
    response, context = runner.get_response('/auth/login/', 'GET', {}, {})
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=c10d55840264c42728a362856b32c4e5;'), 'status_code': 200})
    assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            'advisory_dict': {},
            'data': '<django.utils.datastructures.MergeDict object>',
            'edit_inline': True,
            'error_dict': {},
            'manipulator': '<django.contrib.auth.forms.AuthenticationForm object>'},
        'app_path': '/auth/login/?next=',
        'releasenotes': Ellipsis,
        'internal': Ellipsis,
        'messages': [],
        'next': '',
        'person': Ellipsis,
        'kunden_name': Ellipsis,
        'user': Ellipsis})
    # --------------------------------------------------------------------
    # POST /auth/login/
    GET = MultiValueDict({})
    POST = MultiValueDict({'password': ['HIDDEN'],
    'post_data': [''],
    'this_is_the_login_form': ['1'],
    'username': [username]})
    response, context = runner.get_response('/auth/login/', 'POST', GET, POST)
    assert runner.check_response(response, {'cookies': SimpleCookie(' sessionid=ae369bc2136a294d1a0de5fd3fe887ee;'),
    'location': '/mailadmin/portal/',
    'status_code': 302})
    #assert runner.check_context(response, context, {'form': {'_inline_collections': Ellipsis,
            #'advisory_dict': {},
            #'data': MultiValueDict({'username': [username], 'post_data': [''], 'password': ['HIDDEN'], 'this_is_the_login_form': ['1']}),
            #'edit_inline': True,
            #'error_dict': {},
            #'manipulator': '<kundebunt.kunde_auth.views.PersonAuthenticationForm object>'},
    #'messages': [],
    #'next': '',
    #'person': Ellipsis,
    #'site_name': Ellipsis,
    #'user': '<User: %s>' % username})


if __name__=='__main__':
    setup_module()
