# -*- encoding: UTF-8 -*-
# kundebunt main settings

from ConfigParser import RawConfigParser, NoSectionError, NoOptionError
from decimal import Decimal
import re

SITE_ID = 1

# ETAGS bringen nix.
USE_ETAGS = False

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

STATIC_URLS = r"^/(kundebunt-static|yui-noris|yui-ext-noris)/.*"

TEST_URL_FILTER='^/(auth|mailadmin|releasenotes|popkern|hardware|kunde)/'
TEST_DATASOURCE_URLS='^/popkern/data/'

# installed submodules
INSTALLED_APPS = ('kundebunt.popkern',
                  'kundebunt.kunde_auth',
                  'kundebunt.mailadmin',
                  'kundebunt.releasenotes',
                  'kundebunt.hardware',
                  'kundebunt.history',
                  'kundebunt.kunde',
                  'kundebunt.otrs',
                  'kundebunt.user',
                  'kundebunt.testutils',
                  'kundebunt.validator',
                  'kundebunt.serverstats',
                  'kundebunt.acct',
                  #'kundebunt.tests',  # for fixture loading only ...

                  'django.contrib.sessions',
                  'django.contrib.admin',
                  'django.contrib.contenttypes',
                  'django.contrib.auth',
                  'django.contrib.sites',
                  'django.contrib.webdesign',
                  'django.contrib.humanize',

                  'itscales.apps.perf',
)

# Local time zone for this installation. All choices can be found here:
# http://www.postgresql.org/docs/current/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
TIME_ZONE = 'CET'

# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'de'

LANGUAGES = (
    ('de', ('German')),
    ('en', ('English')),
)


# Make this unique, and don't share it with anybody.
SECRET_KEY = 'z^fqm18q7zf8b_x^exy$vh^15u5=z33n4#3h^u2rvnb$6mpr4('

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'kundebunt.contrib.virtual_app_directories.load_template_source',
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.core.template.loaders.eggs.load_template_source',
)

MIDDLEWARE_CLASSES = (
    "kundebunt.popkern.middleware.PrintTracebackMiddleware",
    "kundebunt.popkern.middleware.SQLLogMiddleware",
    #"kundebunt.popkern.middleware.CacheStaticPagesMiddleware",
    "django.middleware.http.ConditionalGetMiddleware",
    "django.middleware.common.CommonMiddleware",
    "kundebunt.popkern.middleware.NoCachingMiddleware",
    # YUI harmoniert noch nicht mit xml-content-type
    # "kundebunt.popkern.middleware.XHTMLContentTypeMiddleware",
    "kundebunt.validator.middleware.ValidatorMiddleware",
    "kundebunt.contrib.csrf.middleware.CsrfMiddleware",
    "kundebunt.popkern.middleware.XNorisPathMiddleware",
    "kundebunt.testutils.middleware.TestGhostWriter",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.locale.LocaleMiddleware",
    "kundebunt.kunde_auth.middleware.AuthenticationMiddleware",
    "kundebunt.kunde_auth.middleware.NoStaffMiddleware",
    "django.middleware.transaction.TransactionMiddleware",
    "kundebunt.popkern.updatelog.UpdatelogMiddleware",
    "kundebunt.popkern.navigation.NavigationMiddleware",
    "itscales.apps.perf.middleware.Perf",
    "django.middleware.doc.XViewMiddleware",
)

TEMPLATE_CONTEXT_PROCESSORS = (
    "django.core.context_processors.auth",
    #"django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "kundebunt.kunde_auth.context_processors.person",
    "kundebunt.popkern.navigation.navigation_context_processor",
    "kundebunt.popkern.version_context_processor.processor",
)

AUTHENTICATION_BACKENDS = ('kundebunt.kunde_auth.auth_backend.PersonAuthBackend',)

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates".
    # Always use forward slashes, even on Windows.
)

CACHE_BACKEND = 'kundebunt.popkern.atomic_file_cache:///var/cache/kundebunt/django-cache?max_entries=3000'


INDEX_LIMIT=30

SESSION_COOKIE_AGE=3600  # 1 Stunde. Siehe RT #313232
SESSION_EXPIRE_AT_BROWSER_CLOSE=True
SESSION_COOKIE_DOMAIN='.noris.net'
SESSION_COOKIE_SECURE=True
SESSION_SAVE_EVERY_REQUEST=True

SERVER_EMAIL = 'mir+django@noris.de'
#YUI harmoniert noch nicht mit xml-content-type
#DEFAULT_CONTENT_TYPE = 'application/xhtml+xml'

VALIDATOR_APP_VALIDATORS = {
    'text/html': '/usr/bin/validate',
    'application/xhtml+xml': '/usr/bin/validate',
}

VALIDATOR_APP_IGNORE_PATHS = (
    '/hardware/panel/',
    '/kundebunt/hardware/panel',
    '/user/download',
    '/kundebunt/user/download'
)

PERSONEN_DIENSTE = ("contact", "mitarbeiter", "service", "trouble", "dns-contect", ("monitor", "monitor_mail", "monitor_sms", "monitor_voice", "monitor_access"), ("zone", "tech-c", "admin-c", "zone-c", "bill-c"))
                    
PERSONEN_FLAGS = ("pop", "login", "mail", "www", "ftp", ("einwahl", "ppp", "dialin", "dialout", "callingback", "novjhc", "noauth"))

# request paths where staff logins are allowed even on
# the external servers (www1/www2)
STAFF_ALLOWED_PATHS = re.compile(r"^/download(/.*|$)|^/user/download/.*")


###########################################################
# get settings from installation settings file

config = RawConfigParser()
config.read('/etc/kundebunt/settings.ini')

DATABASE_USER = config.get('database', 'DATABASE_USER')
DATABASE_PASSWORD = config.get('database', 'DATABASE_PASSWORD')
DATABASE_HOST = config.get('database', 'DATABASE_HOST')
DATABASE_PORT = config.get('database', 'DATABASE_PORT')
DATABASE_ENGINE = config.get('database', 'DATABASE_ENGINE')
DATABASE_NAME = config.get('database', 'DATABASE_NAME')
TEST_DATABASE_NAME = config.get('database', 'TESTSUITE_DATABASE_NAME')

SECRET_KEY = config.get('secrets','SECRET_KEY')
# CSRF_MIDDLEWARE_SECRET = config.get('secrets', 'CSRF_MIDDLEWARE_SECRET')
RELEASENOTES_SYNC_SECRET = config.get('secrets', 'RELEASENOTES_SYNC_SECRET')
RELEASENOTES_SYNC_URL = config.get('secrets', 'RELEASENOTES_SYNC_URL')

SESSION_COOKIE_DOMAIN = config.get('cookies','SESSION_COOKIE_DOMAIN')
SESSION_COOKIE_SECURE = config.getboolean('cookies','SESSION_COOKIE_SECURE')

DEBUG = config.getboolean('debug','DEBUG')
TEMPLATE_DEBUG = config.getboolean('debug','TEMPLATE_DEBUG')
VIEW_TEST = config.getboolean('debug', 'VIEW_TEST')
INTERNAL_IPS = tuple(config.get('debug', 'INTERNAL_IPS').split())
if config.getboolean('debug', 'SKIP_CSRF_MIDDLEWARE'):
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('CsrfMiddleware')])
if not config.getboolean('debug', 'USE_TEST_GHOST_WRITER_MIDDLEWARE'):
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('TestGhostWriter')])
USE_PERFMON = config.getboolean('debug','USE_PERFMON')
if not USE_PERFMON:
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('.Perf')])
    INSTALLED_APPS = tuple([x for x in list(INSTALLED_APPS)
                                  if not x.endswith('.perf')])
USE_VALIDATOR = config.getboolean('debug', 'USE_VALIDATOR')
if not USE_VALIDATOR:
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('.ValidatorMiddleware')])
    INSTALLED_APPS = tuple([x for x in list(INSTALLED_APPS)
                                  if not x.endswith('.validator')])
if not DEBUG:
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not (x.endswith('.CacheStaticPagesMiddleware')
                                          or x.endswith('.SQLLogMiddleware'))])

SERVER_EMAIL = config.get('email', 'SERVER_EMAIL')
EMAIL_HOST = config.get('email', 'EMAIL_HOST')

try:
    ADMINS = tuple(config.items('error mail'))
except NoSectionError:
    pass

try:
    MANAGERS = tuple(config.items('404 mail'))
    SEND_BROKEN_LINK_EMAILS = True
except NoSectionError:
    pass

DNS_TIMEOUT = config.getint('timeouts', 'DNS_TIMEOUT')
DNS_LIFETIME = config.getint('timeouts', 'DNS_LIFETIME')

NEW_HW_MAIL = config.get('email', 'NEW_HW_MAIL').split()
TICKET_MAIL = config.get('email', 'TICKET_MAIL')

urldict = dict(config.items('urls'))
RT_URL = urldict['rt']
BASE_URL = urldict.get('base', '')
SECURE_LOGIN = urldict.get('secure_login', 'https://secure.noris.net/kundebunt/kunde/,DanaInfo=intra.office.noris.de,SSL+')
SERVICE_URL = urldict.get('service', '')
WIKI_URL = urldict.get('wiki', 'https://intra.office.noris.de/wiki/index.php')
HOUSING_DB_URL = urldict.get('housing_db', 'https://intra.office.noris.de/cgi-bin/technik/housing-db/db.cgi')
NAGIOS_URL = urldict.get('nagios', 'https://monitor.noris.net/nagios/cgi-bin')
TICKET_URL = urldict.get('ticket', '/otrs/index.pl?Action=AgentTicketZoom&TicketNumber=%d')
OTRS_CUSTOMER_URL = urldict.get('otrs_customer', '/otrs/customer.pl')

try:
    STAGING = config.get('style', 'STAGING')
    ADD_SERVICE_LINKS = config.getboolean('style', 'ADD_SERVICE_LINKS')
except NoSectionError:
    STAGING = config.get('debug', 'STAGING')
    ADD_SERVICE_LINKS = True
if STAGING != "ext":
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not (x.endswith('.NoStaffMiddleware'))])

try:
    OPEN_XCHANGE_OPTIONS = config.get('xchange', 'options').split()
    OPEN_XCHANGE_COSTS = dict((k, Decimal(v)) for (k,v) in config.items('xchange costs'))
except NoSectionError:
    OPEN_XCHANGE_OPTIONS = None
    OPEN_XCHANGE_COSTS = None

################################################
# top level URLs

ROOT_URLCONF = 'kundebunt.urls'
MAILADMIN_ROOTURL = BASE_URL + '/mailadmin'
AUTH_ROOTURL = BASE_URL + '/auth'
POPKERN_ROOTURL = BASE_URL + '/popkern'
ICONS_ROOTURL = '/kundebunt-static/icons'
RELEASENOTES_ROOTURL= BASE_URL + '/releasenotes'
HARDWARE_ROOTURL = BASE_URL + '/hardware'
KUNDE_ROOTURL = BASE_URL + '/kunde'
HISTORY_ROOTURL = BASE_URL + '/history'
OTRS_ROOTURL = BASE_URL + '/otrsdata'
USER_ROOTURL = BASE_URL + '/user'
SERVERSTATS_ROOTURL = BASE_URL + '/stats/server'

################################################
# http authentication

try:
    WWW_AUTHENTICATION_REALM = config.get('http_auth', 'WWW_AUTHENTICATION_REALM')
    AUTHENTICATION_METHOD = 'http'
except NoSectionError:
    AUTHENTICATION_METHOD = 'cookie'

#################################################
# otrs
try:
    OTRS_PASSWORD = config.get('otrs', 'PASSWORD')
    OTRS_CLIENT_IPS = config.get('otrs', 'CLIENT_IPS').split()
except NoSectionError:
    OTRS_PASSWORD = None
    OTRS_CLIENT_IPS = []

#################################################
# serverstats
try:
    SERVERSTATS_REWRITE_GRAPH_URL = config.get('serverstats', 'REWRITE_GRAPH_URL')
    SERVERSTATS_HOSTLIST_CACHE_MIN = int(config.get('serverstats', 'HOSTLIST_CACHE_MIN'))
    SERVERSTATS_HOSTLIST_CACHE_MAX = int(config.get('serverstats', 'HOSTLIST_CACHE_MAX'))
    COLLECTD_LIST_URL = config.get('serverstats', 'COLLECTD_LIST_URL')
except NoSectionError:
    SERVERSTATS_REWRITE_GRAPH_URL = None
    SERVERSTATS_HOSTLIST_CACHE_MIN = 890
    SERVERSTATS_HOSTLIST_CACHE_MAX = 3600
    COLLECTD_LIST_URL = 'http://collect.noris.net/cgi-bin/collection3/bin/json.cgi'


#################################################
# history
try:
    ADD_CUSTOMER_HISTORY = config.getboolean("history", "add_customer_history")
except NoSectionError:
    ADD_CUSTOMER_HISTORY = False

# LDAP
if config.has_section('ldap'):
    try:
        LDAP_URL = config.get('ldap', 'url')
    except NoOptionError:
        LDAP_URL = 'ldap://ldap.office.noris.de'
    try:
        LDAP_STAFF_BASE = config.get('ldap', 'staff_base')
    except NoOptionError:
        LDAP_STAFF_BASE = 'ou=People,dc=noris,dc=de'
else:
    LDAP_URL = LDAP_STAFF_BASE = None

#################################################
# dienste
try:
    BILLING_DIENSTE = config.get("dienste", "BILLING").split()
except (NoSectionError, NoOptionError), err:
    BILLING_DIENSTE = ["support", "n8support", "consulting"]

#################################################
# komische POP-Konstanten, dokumentiert im Wiki
# unter  [Pop-Datenbank/Konfigurationsvariablen]
try:
    KUNDE_KONFIG = dict(config.items("KUNDE_KONFIG"))
except NoSectionError:
    KUNDE_KONFIG = dict(
        WDESCR='noris',
        DEFAULTKLASSE='noris')

##################################################
# Zuordnung Abteilung zu Betriebsteams
try:
    BETRIEBSTEAM = dict(config.items('betriebsteams'))
except NoSectionError:
    BETRIEBSTEAM = {
        u'technik, team it outsourcing': u'ITO',
        u'technik, team managed services munich': u'MSM',
        u'*': u'MSE'}

###########################################################
# configure logging
# currently only used for TestGhostWriter

import logging.config
from kundebunt.version import version
try:
    logging.shutdown()
    logging.config.fileConfig('/etc/kundebunt/logging.conf')
    logging.info('kundebunt: server instance started, version %s', version)
except:
    print "cannot read logging.conf, falling back to default logging configuration."

