import datetime, time, md5, urllib, urllib2
from itertools import chain

from django.conf import settings
from django import oldforms
from django.contrib.admin.views.main import change_list, add_stage, history, delete_stage, change_stage
from django.http import HttpResponsePermanentRedirect, Http404, HttpResponse, HttpResponseRedirect
from django.core import serializers
from django.shortcuts import render_to_response
from django.utils.translation import get_language, gettext
from django.template import RequestContext
from django.views.generic.create_update import update_object, create_object

from kundebunt import version
from kundebunt import popkern
from kundebunt.popkern.navigation import navi_url
from kundebunt.releasenotes.forms import ReleasenotesSearchForm, ReleasenotesAddForm, ReleasenotesChangeForm
from kundebunt.kunde_auth.decorators import service_flag_required, staff_only, check_readonly
from kundebunt.releasenotes import models

#@staff_only
#def index(request):
    #return render_to_response("releasenotes/releasenotes_index.html", {
        #'releasenotes': models.get_effective_notes(True),
        #'internal': True,
    #}, context_instance=RequestContext(request))

@staff_only
@check_readonly(allow_get=False)
def close_bugs(request, release, tickets):
    ticket_list = [int(s) for s in tickets.split(",")]
    #wrong_tickets = []
    #for ticket in ticket_list:
        #if not popkern.models.Ticket.objects.filter(id=int(ticket)).exists():
            #wrong_tickets.append(str(ticket))
    #if wrong_tickets:
        #return render_to_response("releasenotes/close_bugs_error.html", {
            #'tickets': ', '.join(wrong_tickets),
            #'release': release,
        #}, context_instance=RequestContext(request))
    releasenotes = models.Note.objects.filter(ticket__in=ticket_list, release_behoben__isnull=True)
    if len(releasenotes)==0:
        return render_to_response("releasenotes/close_bugs_error.html", {
            'tickets': tickets,
            'release': release,
            }, context_instance=RequestContext(request))

    if request.POST:
        # get release object
        version_tags = [int(s) for s in release.split("-")[0].split('.')]
        if len(version_tags)==4:
            (v1,v2,v3,v4) = version_tags
            release_obj, created = models.Release.objects.get_or_create(v1=v1, v2=v2, v3=v3, v4=v4)
        else:
            (v1,v2,v3) = version_tags
            release_obj, created = models.Release.objects.get_or_create(v1=v1, v2=v2, v3=v3, v4__isnull=True)
            release_obj.v4=None
        if created:
            release_obj.save()
        assert release_obj.id

        # change affected notes
        for ticket in ticket_list:
            try:
                note = models.Note.objects.get(ticket=ticket)
                if note.release_behoben_id == None:
                    note.release_behoben_id = release_obj.id
                    note.save()
                    request.user.message_set.create(
                        message=gettext("Meldung #%(ticket)d abgeschlossen: %(summary)s") % dict(ticket=ticket, summary=note.summary()))
            except models.Note.DoesNotExist:
                pass
        return HttpResponseRedirect(navi_url('releasenotes.index', {}, True))
    else:
        return render_to_response("releasenotes/close_bugs.html", {
            'release': release,
            'releasenotes': releasenotes,
            }, context_instance=RequestContext(request))

@staff_only
def index(request):
    manipulator = ReleasenotesSearchForm()
    if request.GET:
        data = request.GET
        notes = manipulator.search_results(request.GET)
        ticket_id = request.GET.get("ticket")
        if ticket_id and len(notes)==1:
            return HttpResponseRedirect(navi_url("releasenotes.edit_note", {"ticket": ticket_id}, True))
    else:
        data = {"current_only": "on"}
        notes = manipulator.search_results(data)
    context = RequestContext(request,
            {"form": oldforms.FormWrapper(manipulator, data, {}),
             "releasenotes": notes,
            })
    return render_to_response("releasenotes/staff_index.html", context_instance=context)

@staff_only
@check_readonly(allow_get=False)
def create_note(request):
    manipulator = ReleasenotesAddForm()
    return create_object(
        request,
        models.Note,
        template_name="releasenotes/releasenote.html",
        manipulator=manipulator,
        extra_context = {'current_release': models.current_release()},
        )

@staff_only
@check_readonly
def edit_note(request, ticket):
    note = models.Note.objects.select_related().get(ticket=ticket)
    manipulator = ReleasenotesChangeForm(note)
    return update_object(
        request,
        models.Note,
        template_name="releasenotes/releasenote.html",
        post_save_redirect=navi_url("releasenotes.edit_note", note.navi_context(), True),
        manipulator=manipulator,
        object_id = note.id,
        extra_context = {'current_release': models.current_release()},
        )

@staff_only
def admin_list(request, *kwargs):
    return change_list(request, 'releasenotes', *kwargs)

@staff_only
@check_readonly(allow_get=False)
def admin_add_stage(request, *kwargs):
    return add_stage(request, 'releasenotes', *kwargs)

@staff_only
def admin_history(request, *kwargs):
    return history(request, 'releasenotes', *kwargs)

@staff_only
@check_readonly(allow_get=False)
def admin_delete_stage(request, *kwargs):
    return delete_stage(request, 'releasenotes', *kwargs)

@staff_only
@check_readonly(allow_get=False)
def admin_change_stage(request, *kwargs):
    return change_stage(request, 'releasenotes', *kwargs)

@staff_only
def admin_redirect(request, url):
    return HttpResponsePermanentRedirect("%s/admin/%s" % (settings.RELEASENOTES_ROOTURL, url))



def database_epoch():
    from django.db import connection
    cursor = connection.cursor()
    cursor.execute('select unix_timestamp()')
    row, = cursor.fetchall()
    return row[0]

def sync_server(request):
    if not request.META.get('REMOTE_ADDR') in settings.INTERNAL_IPS:
        raise Http404
    signature = request.GET.get('signature', '')
    timestamp_str = request.GET.get('last_sync','0')
    if len(signature)>16 or len(timestamp_str)>16:
        raise Http404
    m = md5.new(settings.RELEASENOTES_SYNC_SECRET)
    m.update(timestamp_str)
    if signature != m.digest():
        print "bad sig"
        print len(timestamp_str), timestamp_str
        raise Http404
    timestamp = datetime.datetime.fromtimestamp(int(timestamp_str))
    new_timestamp = datetime.datetime.fromtimestamp(database_epoch())
    data = serializers.serialize("json", chain(
        models.Release.objects.filter(modified__gte=timestamp),
        models.Note.objects.filter(modified__gte=timestamp),
        models.NoteText.objects.filter(modified__gte=timestamp),
        [models.LastSync(id=1, timestamp=new_timestamp)]
        ))
    response = HttpResponse(data)
    return response

def start_sync(request, test=False):
    if request!=None and not request.META.get('REMOTE_ADDR') in settings.INTERNAL_IPS:
        raise Http404
    try:
        last_sync = int(time.mktime(models.LastSync.objects.get().timestamp.timetuple()))
    except models.LastSync.DoesNotExist:
        last_sync = 0
    signature = md5.new(settings.RELEASENOTES_SYNC_SECRET)
    signature.update(str(last_sync))
    print len(str(last_sync))
    url = ("%s?%s"  %
        (settings.RELEASENOTES_SYNC_URL,
         urllib.urlencode((('last_sync', str(last_sync)), ('signature', signature.digest())))))
    print url
    f = urllib2.urlopen(url)
    counter = 0
    objects = serializers.deserialize("json", f)
    for obj in objects:
        if test:
            print repr(obj.object)
        else:
            obj.save()
        if isinstance(obj.object, models.LastSync):
            next_sync = obj.object.timestamp
        counter += 1
    f.close()
    return HttpResponse("received %d objects, new timestamp is %s" % (counter, next_sync.ctime()), mimetype="text/plain")
