from django.conf.urls.defaults import *

#PARTS=dict(kunde=   r'(?P<kunden_name>[^/\s]+)',
           #mailrule=r'(?P<mailrule_id>[1-9]\d*)',
           #mailbox= r'(?P<mailbox_name>[a-z][-%.a-z0-9]*)',
           #ruletype=r'(?P<rule_type>[_a-z0-9]+)'
          #)

PARTS = dict(model=r'(note|release)',
             test=r'(?P<test>test/)?',
             release=r'(?P<release>[0-9.-]+)',
             tickets=r'(?P<tickets>\d+(?:,\d+)*)',
             ticket=r'(?P<ticket>[0-9]+)',
             )


urlpatterns = patterns('kundebunt.releasenotes.views',
    (r'^$', 'index'),
    (r'^create-note', 'create_note'),
    (r'^note/%(ticket)s' % PARTS, 'edit_note'),
    (r'^close-bugs/%(release)s/%(tickets)s/$' % PARTS, 'close_bugs'),
    (r'^sync-send/$', 'sync_server'),
    (r'^sync-start/%(test)s$' % PARTS, 'start_sync'),

    (r'^releasenotes/(?P<url>.*)/$', 'admin_redirect'),
    (r'^admin/%(model)s/$' % PARTS, 'admin_list'),
    (r'^admin/%(model)s/add/$' % PARTS, 'admin_add_stage'),
    (r'^admin/%(model)s/(.+)/history/$' % PARTS, 'admin_history'),
    (r'^admin/%(model)s/(.+)/delete/$' % PARTS, 'admin_delete_stage'),
    (r'^admin/%(model)s/(.+)/$' % PARTS, 'admin_change_stage'),
)
