import re
from django import http
from django.template import loader, RequestContext
from kundebunt.kunde_auth.decorators import with_service_association_webservice, staff_only_webservice
from datasources import *

"""Special views"""


def page_not_found(request):
    """
    404 handler, which looks for the requested URL in the redirects
    table, redirects if found, and displays 404 page if not redirected.

    Templates: `404.html`
    Context:
        request_path
            The path of the requested URL (e.g., '/app/pages/bad_page/')
    """
    context = {'request_path': request.path}
    referer = request.META.get('HTTP_REFERER')
    if referer:
        domain = http.get_host(request)
        context.update({'referer_is_given': True,
                       'referer_is_internal': _is_internal_request(domain, referer)})
    t = loader.get_template('popkern/404.html')
    return http.HttpResponseNotFound(t.render(RequestContext(request, context)))

def _is_internal_request(domain, referer):
    "Return true if the referring URL is the same domain as the current request"
    # Different subdomains are treated as different domains.
    return re.match("^https?://%s/" % re.escape(domain), referer)

@with_service_association_webservice
def domain_data(request, **kwargs):
    return DomainDataSource.serve_json(request, **kwargs)

@with_service_association_webservice
def wildcard_domain_data(request, **kwargs):
    return WildcardDomainDataSource.serve_json(request, **kwargs)

@with_service_association_webservice
def kunden_data(request):
    return KundenDataSource.serve_json(request)

@staff_only_webservice
def personen_data(request):
    return PersonDataSource.serve_json(request)

@staff_only_webservice
def rack_data(request):
    return RackDataSource.serve_json(request)

@staff_only_webservice
def rz_data(request):
    return RZDataSource.serve_json(request)

@staff_only_webservice
def hardware_data(request):
    return HardwareDataSource.serve_json_page(request)

@staff_only_webservice
def ipkunde_data(request):
    return IpkundeDataSource.serve_json(request)

@with_service_association_webservice
def land_data(request):
    return LaenderDataSource.serve_json(request)

@staff_only_webservice
def lieferanten(request):
    return DescriptorDataSource.serve_json(request, modelname='Hardware', fieldname='lieferant')

@staff_only_webservice
def wartungsvertrag_data(request):
    return WartungsvertragDataSource.serve_json(request)
