from django.conf.urls.defaults import *

PARTS=dict(kunde=   r'(?P<kunden_name>[a-zA-Z][-%.A-Za-z0-9]*)',
           mailrule=r'(?P<mailrule_id>[1-9]\d*)',
           mailbox= r'(?P<mailbox_name>[a-z][-%.a-z0-9]*)',
           ruletype=r'(?P<rule_type>[_a-z0-9]+)',
           kunde_id=r'(?P<kunde_id>[1-9]\d*)',
          )

urlpatterns = patterns('kundebunt.popkern.views',
    (r'^data/domains/(?:%(kunde_id)s/)?$' % PARTS,  'domain_data'),
    (r'^data/wildcard-domains/(?:%(kunde_id)s/)?$' % PARTS,  'wildcard_domain_data'),
    (r'^data/kunden/$',   'kunden_data'),
    (r'^data/personen/$', 'personen_data'),
    (r'^data/racks/',     'rack_data'),
    (r'^data/rz/',        'rz_data'),
    (r'^data/hardware/',  'hardware_data'),
    (r'^data/ipkunde/',   'ipkunde_data'),
    (r'^data/land/',      'land_data'),
    (r'^data/descr/Hardware/lieferant/', 'lieferanten'),
    (r'^data/wartungsvertrag/', 'wartungsvertrag_data'),
)
