from django.conf.urls.defaults import *

PARTS=dict(kunde=   r'(?P<kunden_name>[^/\s]+)',
           mailrule=r'(?P<mailrule_id>[1-9]\d*)',
           mailbox= r'(?P<mailbox_name>[a-z][-_%.a-z0-9]*)',
           ruletype=r'(?P<rule_type>[_a-z0-9]+)',
           as_csv=  r'(?P<as_csv>/csv|)',
           as_plain=  r'(?P<as_plain>/plain|)',
          )

urlpatterns = patterns('django.views.generic',
    (r'^$',                                     'simple.redirect_to', dict(url="portal")),
)

urlpatterns += patterns('kundebunt.mailadmin.views',
    (r'^mailrule-search%(as_csv)s%(as_plain)s/$' % PARTS,    'mailrule_search'),
    (r'^mailrule-qsearch%(as_csv)s%(as_plain)s/$' % PARTS,   'mailrule_qsearch'),
    (r'^mailbox-qsearch%(as_csv)s%(as_plain)s/$' % PARTS,    'mailbox_qsearch'),
    (r'^customer-qsearch/$',                    'kunde_qsearch'),
    (r'^portal/(?:%(kunde)s/)?$' % PARTS,       'portal'),
    (r'^create-mailbox/%(kunde)s/$' % PARTS,    'create_mailbox'),
    (r'^delete-mailbox/%(mailbox)s/$' % PARTS,  'delete_mailbox'),
    (r'^create-mailrule/%(kunde)s/(?:%(ruletype)s/)?$' % PARTS,
                                                'create_mailrule'),
    (r'^mailbox/%(mailbox)s/$' % PARTS,         'edit_mailbox'),
    (r'^mailrule/%(mailrule)s(?:/%(ruletype)s)?/$' % PARTS,
                                                'edit_mailrule'),
    (r'^delete-mailrule/%(mailrule)s/$' % PARTS,
                                                'delete_mailrule'),
    (r'^set-mailflag/%(mailbox)s' % PARTS,      'set_mailflag'),
    (r'^open-xchange/select/(?:%(kunde)s/)?$' % PARTS, 'open_xchange'),
    (r'^open-xchange/order/(?:%(kunde)s/)?$' % PARTS, 'open_xchange_bestellung'),
)
