# -*- encoding: UTF-8 -*-

from urllib import urlencode

from django.shortcuts import render_to_response
from django.template import RequestContext
from django.http import HttpResponse, HttpResponseRedirect
from django.utils.cache import add_never_cache_headers
from kundebunt.kunde_auth import LOGIN_URL, REDIRECT_FIELD_NAME
from django import oldforms
from django.contrib import auth
from django.contrib.auth.models import User
from django.core import validators
from django.conf import settings

from kundebunt.popkern.models import Person
from kundebunt.popkern.navigation import navi_url
import  django.contrib.auth.views as auth_views
from django.contrib.auth.forms import AuthenticationForm
import kundebunt.releasenotes.models
from kundebunt.kunde_auth import http_auth


#def login(request, template_name='kunde_auth/login.html'):
    #if settings.AUTHENTICATION_METHOD="form":
        #return login_by_form(request, template_name)
    #else:
        #return http_auth.basic_challenge()

def login(request, template_name='kunde_auth/login.html', redirect_to=None):
    "Displays the login form and handles the login action."
    internal = request.META.get('REMOTE_ADDR') in settings.INTERNAL_IPS
    manipulator = AuthenticationForm(request)
    login_url = navi_url("kunde_auth.login", {}, True)

    if redirect_to is None:
        if REDIRECT_FIELD_NAME in request.REQUEST:
            params = request.GET.copy()
            del params[REDIRECT_FIELD_NAME]
            if params:
                redirect_to = "%s?%s" % (request.REQUEST.get(REDIRECT_FIELD_NAME, ''), urlencode(params))
            else:
                redirect_to = request.REQUEST.get(REDIRECT_FIELD_NAME, '')
            if redirect_to and settings.BASE_URL and not redirect_to.startswith(settings.BASE_URL):
                # Wenn es eine Umleitung von service -> intra gibt, fehlt die BASE_URL ...
                redirect_to = settings.BASE_URL + redirect_to
        elif request.META.get('REDIRECT_STATUS')=='403':
            # kommt von einem FastCGIAccessChecker
            redirect_to = request.META.get('REDIRECT_URL', '')
        else:
            redirect_to = ''
    if settings.AUTHENTICATION_METHOD == "http":
        # redirect directly to the wanted url,
        # the decorators of the wanted url will present http login form.
        if not redirect_to or '://' in redirect_to or ' ' in redirect_to:
            redirect_to = navi_url("kunde", {}, True)
        return HttpResponseRedirect(redirect_to)
    if request.method=="POST":
        errors = manipulator.get_validation_errors(request.POST)
        if not errors:
            auth.logout(request)
            auth.login(request, manipulator.get_user())
            if not redirect_to or '://' in redirect_to or ' ' in redirect_to:
                if request.person.is_staff():
                    redirect_to = navi_url("kunde", {}, True)
                else:
                    redirect_to = navi_url("mailadmin", {}, True)
            return HttpResponseRedirect(redirect_to)
    else:
        errors = {}
    request.session.set_test_cookie()
    releasenotes = kundebunt.releasenotes.models.get_effective_notes(internal)
    return render_to_response(template_name, {
        'form': oldforms.FormWrapper(manipulator, request.REQUEST, errors),
        REDIRECT_FIELD_NAME: redirect_to,
        'releasenotes': releasenotes,
        'internal': internal,
        'app_path': "%s?%s" % (login_url, urlencode({REDIRECT_FIELD_NAME: redirect_to}))
    }, context_instance=RequestContext(request))

admin_login = login


def logout(request, next_page=None):
    response = auth_views.logout(request, next_page, 'kunde_auth/logged_out.html')
    if settings.AUTHENTICATION_METHOD == "http":
        response = http_auth.basic_challenge(response)
        response["Cache-Control"] = 'no-cache'
        response["ETag"] = ''
    return response 

def forbidden(request):
    next_url = request.GET.get(REDIRECT_FIELD_NAME)
    response = render_to_response('kunde_auth/forbidden.html',
            context_instance=RequestContext(request,
                {'login_url': LOGIN_URL,
                'login_url2': '%s?%s=%s' % (LOGIN_URL, REDIRECT_FIELD_NAME, next_url)}))
    response.status_code = 403
    return response

def check_service_access(request):
    """FastCGIAccessChecker - erlaubt den Zugriff, wenn die Person zur Session zu irgend einem
    Kunden eine service-Assoziierung hat. Andernfalls wird Status 403 zurückgegeben.
    In letzterm Fall wird dann sinnvollerweise über ein zu konfigurierendes Apache-ErrorDocument
    die Loginseite aufgerufen.
    """
    from kundebunt.kunde_auth.decorators import person_has_service_association
    if person_has_service_association(request.person):
        return HttpResponse(u"OK", content_type="text/plain")
    else:
        # Against specification, the apache forwards the content-length header
        # of response of the fastcgi access checker, so it should match the
        # final response (which is the login view, by ErrorDocument)
        response = login(request)
        response.status_code = 403
        return response
