from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth import login, logout
from django.conf import settings
from kundebunt.kunde_auth.http_auth import basic_authenticate, basic_challenge
from kundebunt.popkern.navigation import navi_url

class LazyUser(object):
    def __get__(self, request, obj_type=None):
        if not hasattr(request, '_cached_user'):
            from django.contrib.auth import get_user
            request._cached_user = get_user(request)
        return request._cached_user


class LazyPerson(object):
    def __get__(self, request, obj_type=None):
        if not hasattr(request, '_cached_person'):
            from django.contrib.auth import get_user
            from kundebunt.popkern.models import Person
            user = request.user
            if user==None:
                self._cached_person = None
            else:
                try:
                    self._cached_person = Person.objects.get(user=user.username)
                except (Person.DoesNotExist):
                    self._cached_person = None
        return self._cached_person


class AuthenticationMiddleware:
    def process_request(self, request):
        assert hasattr(request, 'session'), "Django session framework failed to initialize or has not been activated. Perhaps you only need to edit your MIDDLEWARE_CLASSES setting to insert 'django.contrib.sessions.middleware.SessionMiddleware'."
        request.__class__.user = LazyUser()
        request.__class__.person = LazyPerson()
        if settings.AUTHENTICATION_METHOD == 'http':
            auth_token = request.META.get('Authorization', None)
            if auth_token:
                user =  basic_authenticate(auth_token)
                if user is None:
                    # when logging out by http-auth, remove cookie, too
                    logout(request)
                else:
                    login(request, user)
            else:
                # Log the user out of the session as well
                logout(request)
        return None

class NoStaffMiddleware:
    """Verhindert jeglichen Zugriff von Mitarbeitern. Dieses Middleware wird
    nur auf dem externen Interface aktiviert (STAGE=="ext"), siehe settings.py.
    """
    def process_request(self, request):
        if (hasattr(request, "person")
                and request.person and request.person.is_staff()
                and not settings.STAFF_ALLOWED_PATHS.match(request.path)):
            response = render_to_response('kunde_auth/nostaff.html', context_instance=RequestContext(request, {'path': request.path, 'login_user': request.person.user, 'external_login_url': navi_url('external_login', {}, True), 'internal_login_url': navi_url('internal_login', {}, True), 'secure_login_url': navi_url('secure_login', {}, True)}))
            response.status_code = 403
            logout(request)
            return response
        else:
            return None
