"""Supporting http style authentication.
Based on http://www.djangosnippets.org/snippets/56/
"""

from django.contrib.auth import authenticate, login, logout
from django.conf import settings
from django.http import HttpResponse

def basic_challenge(response = None):
    """returns a http challenge"""
    if response is None:
        response = HttpResponse(_('<html><body><p>Passwort erforderlich.</p></body></html>'), mimetype="text/html")
    response['WWW-Authenticate'] = 'Basic realm="%s"' % settings.WWW_AUTHENTICATION_REALM
    response.status_code = 401
    return response

def basic_authenticate(authentication):
    # Taken from paste.auth
    (authmeth, auth) = authentication.split(' ',1)
    if 'basic' != authmeth.lower():
        return None
    auth = auth.strip().decode('base64')
    username, password = auth.split(':',1)
    return authenticate(username = username, password = password)

#class BasicAuthenticationMiddleware:
    #def process_request(self, request):
        #if settings.AUTHENTICATION_METHOD == 'http':
            #if request.META.has_key('HTTP_AUTHORIZATION'):
                #user =  basic_authenticate(request.META['HTTP_AUTHORIZATION'])
                #if user is None:
                    #return basic_challenge()
                #else:
                    #login(request, user)
            #else:
                ## If the user out of the session as well
                #logout(request)
                #return None
        #else:
            #return None
