"""Authentication backend"""

import datetime
from decorators import person_can_log_in
from django.conf import settings

class PersonAuthBackend:
    def authenticate(self, username=None, password=None):
        from kundebunt.popkern.models import Person
        from django.contrib.auth.models import User
        now = datetime.datetime.now()
        try:
            person = Person.objects.filter(user=username).get()
        except Person.DoesNotExist:
            person = None
        if person_can_log_in(person) and (
                settings.AUTHENTICATION_METHOD == 'http'
                or person.pass_field == password):
            try:
                user = User.objects.get(username=username)
                user.last_login = now
                user.save()
            except User.DoesNotExist:
                user = User(id=person.id, username=username, password='*',
                            is_staff=False, is_active=True, is_superuser=False,
                            date_joined=now, last_login=now)
                user.save()
            return user
        else:
            return None

    def get_user(self, user_id):
        from django.contrib.auth.models import User
        try:
            return User.objects.get(id=user_id)
        except User.DoesNotExist:
            return None

