# -*- encoding: UTF-8 -*-

"""Dies ist das Authentifizierungs-Modul für kundebunt, das Authentifizierung über Django-Kunde mit Kunde-Person verbindet.

Django bietet eine eigene Authentifizierung als Plugin an (contrib.auth), die auf einer handvoll zusätzlicher Tabellen beruht. Diese sind recht praktisch für Admin-Zugänge, deswegen wollte ich sie beibehalten. Für Kunden brauchen wir jedoch eine Authentifizierung, die auf der Tabelle ``Person`` basiert.

Daher sind beide Authentifizierungen nebeneinander möglich. Wer sich über (Django-) User anmeldet, wird als Admin betrachtet und kann sich eine Person heraussuchen, als die er tätig wird.

Die Middleware setzt folgende Variablen:

request.user: Ein django.contrib.auth.models.User-Objekt, das den Admin identifiziert. Ist andernfalls der "anonyme" User.
request.person: Ein kundebunt.mailadmn.models.Person-Objekt, das die aktive Person identifiziert. Ist andernfalls None.

Zum Testen der Berechtigung in Views stehen die decorators in ``decorators.py`` zur Verfügung, insbesondere:

    ``service_flag_required``: Testet, ob die angemeldete Person das Service-Flag gesetzt hat
    ``flag_required``: Allgemeinere Funktion, testet die Person auf beliebige Flags
"""


from django.conf import settings

LOGIN_URL = settings.BASE_URL + '/auth/login/'
REDIRECT_FIELD_NAME = 'next'
