from django.conf.urls.defaults import *

PARTS = dict(
            kunde_id=r'(?P<kunde_id>[1-9]\d*)',
            kunden_name=r'(?P<kunden_name>[^/]+)',
            person_id=r'(?P<person_id>[1-9]\d*)',
            filter_spalte=r'(?P<filter_spalte>[^/]+)',
        )

urlpatterns = patterns('kundebunt.kunde.views',
    (r'^$',                                     'kunden_suche'),
    (r'^%(kunden_name)s/$' % PARTS,             'overview'),
    (r'^%(kunde_id)s/id/$' % PARTS,             'overview_by_id'),
    (r'^%(kunden_name)s/unterkunden/$' % PARTS,  'unterkunden'),
    (r'^%(kunden_name)s/personen/$' % PARTS,     'personen'),
    (r'^%(kunden_name)s/personen/%(filter_spalte)s/$' % PARTS, 'personen'),
    (r'^%(kunden_name)s/accounts/$' % PARTS,     'accounts'),
    (r'^%(kunden_name)s/accounts/%(filter_spalte)s/$' % PARTS, 'accounts'),
    (r'^%(kunden_name)s/person/%(person_id)s/$' % PARTS,'person'),
    (r'^%(kunden_name)s/create-person/$' % PARTS,'create_person'),
    (r'^%(kunden_name)s/domains/$' % PARTS,      'domains'),
    (r'^%(kunden_name)s/ips/$' % PARTS,          'ips'),
    (r'^%(kunden_name)s/hardware/$' % PARTS,     'hardware'),
)

