# -*- encoding: utf-8 -*-

import datetime

from django.http import HttpResponse, Http404, HttpResponseRedirect
from django.template import loader, RequestContext
from django.shortcuts import render_to_response

from kundebunt.popkern import models
from kundebunt.kunde_auth.decorators import staff_only
from kundebunt.history.utils import *
from kundebunt import newforms

DELTA_CHOICES = ((0.125, _(u'3 Stunden')), (1, _(u'1 Tag')), (7, _(u'1 Woche')),
                 (31, _(u'1 Monat')), (184, _(u'6 Monate')), (731, _(u'2 Jahre')), (1827, _(u'5 Jahre')))

class HistoryForm(newforms.Form):
    start = newforms.DateTimeField(label=_(u"Historie bis"))
    max_count = newforms.DecimalField(label=_(u"Maximale Anzahl"))
    delta = newforms.DecimalField(
            label=_(u"Zeitraum"),
            widget=newforms.Select(
                choices=DELTA_CHOICES))
    kunde = newforms.IntegerField(widget=newforms.HiddenInput, required=False)

def get_history_form(get_data, cls=HistoryForm):
    data = {'start': datetime.date.today()+datetime.timedelta(1),
            'delta': 7,
            'max_count': 100,
            'mit_unterkunden': True,
            }
    data.update(get_data.items())
    form = cls(data)
    if float(data['delta']) not in (k for (k,v) in DELTA_CHOICES):
        form.fields["delta"] = newforms.DecimalField(label=_(u"Zeitraum (Tage)"))
    return form

class KundenHistoryForm(HistoryForm):
    mit_unterkunden = newforms.BooleanField(label=_(u"Unterkunden"), initial=True, required=False)


@staff_only
def kunde(request, kunden_name):
    try:
        kunde = models.Kunde.objects.get(name=kunden_name)
    except models.Kunde.DoesNotExist:
        raise Http404
    form = get_history_form(request.GET, cls=KundenHistoryForm)
    if form.is_valid():
        data = form.cleaned_data
        kunden = [kunde.id]
        if data["mit_unterkunden"]:
            kunden.extend(kunde.unterkunde.active().valuelist("id"))
        history = get_kunde_history(kunden=kunden, start=data["start"],
                                    delta=datetime.timedelta(float(data["delta"])),
                                    max_count=data["max_count"])
    else:
        history = []
    history=list(history)
    return render_to_response(
        "history/kunde.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history), "kunden_name": kunden_name,
             "is_single_object_history": False}))

@staff_only
def hardware(request, id):
    try:
        obj = models.Hardware.objects.get(id=id)
    except models.Hardware.DoesNotExist:
        obj = None
    form = get_history_form(request.GET)
    if form.is_valid():
        data = form.cleaned_data
        history = get_hardware_history(id=id, start=data["start"],
                                       delta=datetime.timedelta(float(data["delta"])),
                                       max_count=data["max_count"])
        if obj and data["start"] > datetime.datetime.now():
            history = [log for log in neue_werte(obj, history)]
        else:
            history=list(history)
    else:
        history = []
    return render_to_response(
        "history/hardware.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history),
             "kunden_name": obj and obj.kunde.name,
             "obj": obj,
             "hardware_db_id": id,
             "id": id,
             "is_single_object_history": True}))

@staff_only
def ipkunde(request, id):
    try:
        obj = models.Ipkunde.objects.get(id=id)
        kunde = obj.kunde
    except models.Ipkunde.DoesNotExist:
        obj = None
        kunde_id = request.GET.get("kunde", None)
        if kunde_id:
            try:
                kunde = models.Kunde.objects.get(id=kunde_id)
            except models.Kunde.DoesNotExist:
                kunde = None
        else:
            kunde = None
    form = get_history_form(request.GET)
    if form.is_valid():
        data = form.cleaned_data
        history = get_ipkunde_history(id=id, start=data["start"],
                                      kunde=kunde and kunde.id,
                                      delta=datetime.timedelta(float(data["delta"])),
                                      max_count=data["max_count"])
        if obj and data["start"] > datetime.datetime.now():
            history = [log for log in neue_werte(obj, history)]
        else:
            history=list(history)
    else:
        history = []
    return render_to_response(
        "history/ipkunde.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history),
             "kunden_name": kunde and kunde.name,
             "obj": obj,
             "hardware_db_id": id,
             "id": id,
             "is_single_object_history": True}))

@staff_only
def person(request, id):
    try:
        obj = models.Person.objects.get(id=id)
        kunde = obj.kunde
    except models.Person.DoesNotExist:
        obj = None
        kunde_id = request.GET.get("kunde", None)
        if kunde_id:
            try:
                kunde = models.Kunde.objects.get(id=kunde_id)
            except models.Kunde.DoesNotExist:
                kunde = None
        else:
            kunde = None
    form = get_history_form(request.GET)
    if form.is_valid():
        data = form.cleaned_data
        history = get_person_history(id=id, start=data["start"],
                                      kunde=kunde and kunde.id,
                                      delta=datetime.timedelta(float(data["delta"])),
                                      max_count=data["max_count"])
        if obj and data["start"] > datetime.datetime.now():
            history = [log for log in neue_werte(obj, history)]
        else:
            history=list(history)
    else:
        history = []
    return render_to_response(
        "history/person.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history),
             "kunden_name": kunde and kunde.name,
             "obj": obj,
             "hardware_db_id": id,
             "id": id,
             "person_id": id,
             "is_single_object_history": True}))

@staff_only
def mailrule(request, id):
    try:
        obj = models.Mailrule.objects.get(id=id)
        kunde = obj.kunde
    except models.Mailrule.DoesNotExist:
        obj = None
        kunde_id = request.GET.get("kunde", None)
        if kunde_id:
            try:
                kunde = models.Kunde.objects.get(id=kunde_id)
            except models.Kunde.DoesNotExist:
                kunde = None
        else:
            kunde = None
    form = get_history_form(request.GET)
    if form.is_valid():
        data = form.cleaned_data
        history = get_mailrule_history(id=id, start=data["start"],
                                      kunde=kunde and kunde.id,
                                      delta=datetime.timedelta(float(data["delta"])),
                                      max_count=data["max_count"])
        if obj and data["start"] > datetime.datetime.now():
            history = [log for log in neue_werte(obj, history)]
        else:
            history=list(history)
    else:
        history = []
    return render_to_response(
        "history/mailrules.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history),
             "kunden_name": kunde and kunde.name,
             "obj": obj,
             "id": id,
             "is_single_object_history": True}))
@staff_only
def generic(request, tabelle, id):
    form = get_history_form(request.GET)
    if form.is_valid():
        data = form.cleaned_data
        history = get_generic_history(tabelle=tabelle, id=id, start=data["start"],
                                       delta=datetime.timedelta(float(data["delta"])),
                                       max_count=data["max_count"])
    else:
        history = []
    history=list(history)
    return render_to_response(
        "history/generic.html",
        context_instance=RequestContext(
            request,
            {"form": form, "history": list(history),"id": id,
             "tabelle": tabelle,
             "is_single_object_history": True}))

    