# -*- encoding: utf-8 -*-

from itertools import islice
from django.db.models import ForeignKey
from django.utils.encoding import smart_unicode

from kundebunt.popkern.utils import merge_sorted, unique
from kundebunt.popkern.navigation import navi_url

_cls_for_table = _tablename = None

__all__ = ['get_kunde_history', 'get_hardware_history', 'get_generic_history', 'get_ipkunde_history',
           'get_person_history', 'get_mailrule_history', 'neue_werte']

class Found(Exception):
    pass

def _base_log_qset(start, delta):
    from kundebunt.popkern import models
    return models.Updatelog.objects.filter(timestamp__lte=start, timestamp__gte=start-delta)

def get_generic_history(tabelle, id, start, delta, max_count):
    from kundebunt.popkern import models
    qs = _base_log_qset(start, delta)
    if tabelle=="domain":
        tabelle = "domainkunde"
    return _get_history([qs.filter(db_tabelle=models.DbTabelle.objects.get(name=tabelle),
                                   wert=unicode(id),
                                   indexspalten__namen='id')],
                        max_count,
                        is_single_object_history=True,
                        start=start)

def get_hardware_history(id, start, delta, max_count):
    return get_generic_history(u"hardware", id, start, delta, max_count)
    #from kundebunt.popkern import models
    #qs = _base_log_qset(start, delta)
    #return _get_history([qs.filter(db_tabelle=models.DbTabelle.objects.get(name=u"hardware"), wert=id)],
                        #max_count,
                        #is_single_object_history=True)

def get_kunde_history(kunden, start, delta, max_count):
    from kundebunt.popkern import models
    qs = _base_log_qset(start, delta)
    kunden = [unicode(k) for k in kunden]
    return _get_history(
        [qs.filter(db_tabelle__name=u"kunde", wert__in=kunden),
         qs.filter(indexspalten__namen=u'kunde', wert__in=kunden),
        ],
        max_count,
        is_single_object_history=False,
        start=start,
        history_tabelle="kunde")

def get_ipkunde_history(id, kunde, start, delta, max_count):
    from kundebunt.popkern import models
    id = int(id)
    qs = _base_log_qset(start, delta)
    queries = [qs.filter(db_tabelle__name=u"ipkunde", wert=unicode(id), indexspalten__namen=u'id')]
    if kunde is not None:
        queries.append(qs.filter(db_tabelle__name=u"ipkunde", wert=unicode(kunde),
                                 indexspalten__namen=u'kunde'))
    return _get_history(
        queries,
        max_count,
        is_single_object_history=True,
        start=start,
        history_tabelle="kunde",
        post_filter = lambda log: log["pk"] and int(log["pk"])==id)

def get_person_history(id, kunde, start, delta, max_count):
    from kundebunt.popkern import models
    id = int(id)
    qs = _base_log_qset(start, delta)
    queries = [qs.filter(db_tabelle__name=u"person", wert=unicode(id), indexspalten__namen=u'id')]
    if kunde is not None:
        queries.append(qs.filter(db_tabelle__name=u"person", wert=unicode(kunde),
                                 indexspalten__namen=u'kunde'))
    return _get_history(
        queries,
        max_count,
        is_single_object_history=True,
        start=start,
        history_tabelle="person",
        post_filter = lambda log: log["pk"] and int(log["pk"])==id)

def get_mailrule_history(id, kunde, start, delta, max_count):
    from kundebunt.popkern import models
    id = int(id)
    qs = _base_log_qset(start, delta)
    queries = [qs.filter(db_tabelle__name=u"mailrules", wert=unicode(id), indexspalten__namen=u'id')]
    if kunde is not None:
        queries.append(qs.filter(db_tabelle__name=u"mailrules", wert=unicode(kunde),
                                 indexspalten__namen=u'kunde'))
    return _get_history(
        queries,
        max_count,
        is_single_object_history=True,
        start=start,
        history_tabelle="mailrules",
        post_filter = lambda log: log["pk"] and int(log["pk"])==id)

def _get_history(qset_list, count, is_single_object_history, start, history_tabelle=None, post_filter=None):
    from kundebunt.popkern import models
    kunde_columns = set([f.column for f in models.Kunde._meta.fields] + ['*', '-'])
    
    def helper(qset, count):
        global _cls_for_table, _tablename
        if _cls_for_table is None:
            _cls_for_table = {
                'kunde': models.Kunde,
                'domain': models.Domainkunde,
                'hardware': models.Hardware,
                'person': models.Person,
                'mailrules': models.Mailrule,
            }
            _tablename = {'domain': 'domainkunde'}
        
        qset = qset.order_by('-timestamp')[:count]
        for log in qset:
            kunde_id = None
            if log.dwert:
                werte = log.dwert.split(u'|')
            else:
                werte = []
            try:
                spalten = log.datenspalten.namen.split(u'|')
            except models.UpdatelogSpalten.DoesNotExist:
                spalten = [u'?'] * len(werte)
            tabelle = log.db_tabelle.name
            if (tabelle==u'kunde'
                    and spalten[0] not in kunde_columns
                   and models.DbTabelle.objects.filter(name__exact=_tablename.get(spalten[0],spalten[0])).exists()):
                # "related" log
                if werte:
                    pk = werte[0]
                else:
                    pk = None
                tabelle = spalten[0]
                if log.indexspalten.namen==u"id":
                    kunde_id = int(log.wert)
                try:
                    if pk and pk.isdigit():
                        logs2 = models.Updatelog.objects.filter(
                            person=log.person,
                            db_tabelle=models.DbTabelle.objects.get(name=_tablename.get(tabelle,tabelle)),
                            timestamp=log.timestamp,
                            )
                        for log2 in logs2:
                            if log2.dwert:
                                spalten2 = log2.datenspalten.namen.split(u'|')
                                werte2 = log2.dwert.split(u'|')
                                for s,w in zip(spalten2, werte2):
                                    if w.isdigit() and s == u'id' and int(w) == int(pk):
                                        spalten = spalten2
                                        werte = werte2
                                        log = log2
                                        raise Found()

                        # not found :-(
                        spalten = spalten[1:]
                        werte = werte[1:]
                    else:
                        pk = None
                except Found:
                    pass
            else:
                if u"id" in spalten:
                    pk = int(werte[spalten.index(u"id")])
                elif u"id" in log.indexspalten.namen.split(u'|'):
                    pk = int(log.wert.split(u'|')[log.indexspalten.namen.split(u'|').index(u"id")])
                else:
                    pk = None
            cls = _cls_for_table.get(tabelle)
            obj = display = url = None
            if u"pass" in spalten:
                werte[spalten.index(u"pass")] = u"*"
            if spalten and spalten[-1]==u'*':
                modus = '*'
                aktion = _(u'hinzugefügt')
                if cls and pk:
                    try:
                        obj = cls.objects.get(pk=pk)
                    except cls.DoesNotExist:
                        obj = None
                alte_werte = zip(spalten[:-1], werte)
            elif spalten and spalten[-1]==u'-':
                modus = '-'
                aktion = _(u'entfernt')
                alte_werte = zip(spalten[:-1], werte)
            else:
                modus = ''
                aktion = u'geändert'
                alte_werte = zip(spalten, werte)
                if cls and pk:
                    try:
                        obj = cls.objects.get(pk=pk)
                    except cls.DoesNotExist:
                        obj = None
            # Indexspalten auch übernehmen, soweit noch nicht in den Werten.
            if tabelle != u"kunde":
                for (ispalte, iwert) in zip(log.indexspalten.namen.split(u"|"), log.wert.split(u"|")):
                    if ispalte != "id" and ispalte not in spalten:
                        alte_werte.insert(0, (ispalte,iwert))
            if hasattr(cls,"Updatelog") and hasattr(cls.Updatelog, u"log_index"):
                log_spalte = cls.Updatelog.log_index
                try:
                    log_index = [v for (k,v) in alte_werte if k==log_spalte][0]
                except IndexError:
                    log_index = None
            else:
                log_index = pk
            if not is_single_object_history:
                # Namen anzeigen und zur History verlinken.
                if obj:
                    display = unicode(obj)
                if log_index and tabelle != history_tabelle:
                    delta = int((start - log.timestamp).days + 7.5)
                    if kunde_id is not None:
                        k_param = u";kunde=%s" % kunde_id
                    elif obj is not None and hasattr(obj, "kunde"):
                        k_param = u";kunde=%s" % obj.kunde.id
                    else:
                        for k,v in alte_werte:
                            if k=="kunde":
                                k_param = u";kunde=%s" % v
                                break
                        else:
                            k_param = u""
                    if pk is not None:
                        url = "%s?start=%s;delta=%s%s" % (navi_url("history.generic", {'tabelle': tabelle, 'id': pk}, True) , start, delta, k_param)
            data = dict(modus=modus, tabelle=tabelle, alte_werte=alte_werte,
                        timestamp=log.timestamp, user=log.person.user, display=display,
                        aktion=aktion, pk=pk, obj=obj, url=url, log_id=log.id)
            if post_filter is None or post_filter(data):
                yield data
    return islice(unique(merge_sorted([helper(qs, count) for qs in qset_list],
                                      key=lambda log: [-x for x in log["timestamp"].timetuple()])),
                  count)

def neue_werte(obj, history):
    last = {}
    for log in history:
        werte = []
        spalten = []
        add_mode = log["aktion"] == u"hinzugefügt"
        for spalte, alt in log["alte_werte"]:
            if alt == u"None":
                alt = u""
            spalte = spalte.lower()
            if spalte in spalten:
                werte.append((spalte, alt))
            else:
                spalten.append(spalte)
                if spalte in last:
                    if alt != last[spalte] or spalte==u"pass" or add_mode:
                        werte.append((spalte, alt, last[spalte]))
                elif hasattr(obj, spalte):
                    field = obj._meta.get_field(spalte)
                    att = getattr(obj, field.attname)
                    if isinstance(field, ForeignKey) and att:
                        neu = u"#%s: %s" % (att, smart_unicode(getattr(obj, spalte)))
                    else:
                        neu =smart_unicode(att, strings_only=True)
                    if neu != alt or spalte==u"pass" or add_mode:
                        werte.append((spalte, alt, neu))
                else:
                    werte.append((spalte, alt))
                last[spalte] = alt
        log["alte_werte"] = werte
        yield log
