from django.conf.urls.defaults import *

#PARTS=dict(kunde=   r'(?P<kunden_name>[^/\s]+)',
           #mailrule=r'(?P<mailrule_id>[1-9]\d*)',
           #mailbox= r'(?P<mailbox_name>[a-z][-%.a-z0-9]*)',
           #ruletype=r'(?P<rule_type>[_a-z0-9]+)'
          #)

PARTS = dict(id=r'(?P<id>[1-9]\d*)',
             first=r'(?P<first>[1-9]\d*)',
             last=r'(?P<last>[1-9]\d*)',
             level=r'(?P<level>[1-9]\d*)',
             parent=r'(?P<parent>[1-9]\d*)',
             wv_id=r'(?P<wv_id>[1-9]\d*)',
             hw_id=r'(?P<hw_id>D\d+)',
             )

urlpatterns = patterns('django.views.generic',
    (r'^$',                                     'simple.redirect_to', dict(url="search")),
)

urlpatterns += patterns('kundebunt.hardware.views',
    (r'^search/$',                     'hw_search'),
    (r'^panel/search/$',               'hw_search', {'in_panel': True}),
    (r'^%(hw_id)s/$' % PARTS,          'hw_edit_by_hardware_id'),
    (r'^%(id)s/$' % PARTS,             'hw_edit'),
    (r'^panel/%(id)s/$' % PARTS,       'hw_edit_panel'),
    (r'^create/$',                     'hw_create'),
    (r'^panel/create/$',               'hw_create_panel'),
    (r'^copy/%(id)s/$' % PARTS,       'hw_copy'),
    (r'^panel/copy/%(id)s/$' % PARTS,  'hw_copy_panel'),
    (r'^%(id)s/wartungsvertrag/create/$'
        % PARTS,                       'hw_wartungsvertrag_create'),
    (r'^panel/%(id)s/wartungsvertrag/create/$'
        % PARTS,                       'hw_wartungsvertrag_create_panel'),
    (r'^%(id)s/wartungsvertrag/%(wv_id)s/$'
        % PARTS,                       'hw_wartungsvertrag_edit'),
    (r'^panel/%(id)s/wartungsvertrag/%(wv_id)s/$'
        % PARTS,                       'hw_wartungsvertrag_edit_panel'),
    (r'^%(id)s/wartungsvertrag/copy/%(wv_id)s/$'
        % PARTS,                       'hw_wartungsvertrag_copy'),
    (r'^panel/%(id)s/wartungsvertrag/copy/%(wv_id)s/$'
        % PARTS,                        'hw_wartungsvertrag_copy_panel'),
    )
