entityList = new Array ();
charList   = new Array ();

/* Really important entities */
entityList.push ("&amp;");    charList.push (RegExp(/&/g)); /* This MUST be the first entity! */
entityList.push ("&gt;");     charList.push (RegExp(/>/g));
entityList.push ("&lt;");     charList.push (RegExp(/</g));

function encode_entities (str)
{
    for (var i = 0; (i < entityList.length) && (i < charList.length); i++)
    {
        str = str.replace(charList[i], entityList[i]);
    }
    return (str);
}


// read the {name: value}-dict from all form fields. Mostly copied from YAHOO.util.Connect.setForm
function get_field_values(formId)
{
    var data = {};
    var oForm;
    if(typeof formId == 'string'){
        oForm = document.getElementById(formId);
    }
    else if(typeof formId == 'object'){
        // Treat argument as an HTML form object.
        oForm = formId;
    }
    else{
        YAHOO.log('Unable to create form object ' + formId, 'warn', 'Connection');
        return;
    }

    var oElement, oName, oValue, oDisabled;
    var hasSubmit = false;

    // Iterate over the form elements collection to construct the
    // label-value pairs.
    for (var i=0; i<oForm.elements.length; i++){
        oElement = oForm.elements[i];
        oDisabled = oForm.elements[i].disabled;
        oName = oForm.elements[i].name;
        oValue = oForm.elements[i].value;

        // Do not submit fields that are disabled or
        // do not have a name attribute value.
        if(!oDisabled && oName)
        {
            switch (oElement.type)
            {
                case 'select-one':
                case 'select-multiple':
                    for(var j=0; j<oElement.options.length; j++){
                        if(oElement.options[j].selected){
                            if(window.ActiveXObject){
                                data[oName] = oElement.options[j].attributes['value'].specified?oElement.options[j].value:oElement.options[j].text;
                            }
                            else{
                                data[oName] = oElement.options[j].hasAttribute('value')?oElement.options[j].value:oElement.options[j].text;
                            }

                        }
                    }
                    break;
                case 'radio':
                case 'checkbox':
                    if(oElement.checked){
                        data[oName] = oValue;
                    }
                    break;
                case 'file':
                    // stub case as XMLHttpRequest will only send the file path as a string.
                case undefined:
                    // stub case for fieldset element which returns undefined.
                case 'reset':
                    // stub case for input type reset button.
                case 'button':
                    // stub case for input type button elements.
                    break;
                case 'submit':
                    if(hasSubmit == false){
                        data[oName] = oValue;
                        hasSubmit = true;
                    }
                    break;
                default:
                    data[oName] = oValue;
                    break;
            }
        }
    }
    return data;
}

var ResultGridLoader = {
init : function(){
    getEl('search_form').on('keypress', this.handle_form_keypress, this, true);
    this.seq = 1;
    this.tabPanels = new Object();
    dialog = null;
    layout = null;
    var schema = {
        root: 'data',
        id: 'id',
        fields: ['id', 'hardware_id', 'ivnr', 'name', 'ip', 'kunde', 'standort'],
        totalProperty: 'total_count'
    };
    dataModel = new YAHOO.ext.grid.JSONDataModel(schema);
    dataModel.initPaging(kundebunt_urls['popkern.hardware_data'], 25);
    dataModel.on("load", this.handle_grid_load);
    dataModel.on("loadexception", this.handle_load_failure);
    /*    dataModel.addListener('load', sm.selectFirstRow, sm, true);*/

    // the DefaultColumnModel expects this blob to define columns. It can be extended to provide
    // custom or reusable ColumnModels
    var colModel = new YAHOO.ext.grid.DefaultColumnModel([
                    {header: hwlang.col_id, hidden: true},
                    {header: hwlang.col_hw_id, width: 70, sortable: true},
                    {header: hwlang.col_ivnr, width: 70, sortable: true},
                    {header: hwlang.col_bezeichnung, width:220, sortable: true},
                    {header: hwlang.col_name, width: 140, sortable: true},
                    {header: hwlang.col_kunde, width: 90, sortable: true},
                    {header: hwlang.col_standort, width: 230, sortable: true}
            ]);

            // create the Grid

    grid = new YAHOO.ext.grid.Grid('results_tab', dataModel, colModel);
    grid.autoWidth = true;
    grid.autoHeight = true;
    grid.render();
    var view = grid.getView();
    var toolbar = view.getPageToolbar();
    toolbar.addButton({text:'10', click:function(){dataModel.initPaging(kundebunt_urls['popkern.hardware_data'],10); dataModel.loadPage(1);}});
    toolbar.addButton({text:'25', click:function(){dataModel.initPaging(kundebunt_urls['popkern.hardware_data'],25); dataModel.loadPage(1);}});
    toolbar.addButton({text:'250', click:function(){dataModel.initPaging(kundebunt_urls['popkern.hardware_data'],250); dataModel.loadPage(1);}});

    getEl('search_submit').on('click', this.showResults, true);
    grid.on('rowdblclick', this.showDetailsForRow);
    this.showResults();
},

showResults: function(){
    if (! layout) {
        getEl('hw_create').dom.firstChild.href = 'javascript:ResultGridLoader.showCreatePanel()';
        layout = new YAHOO.ext.BorderLayout(document.body, {
            north: {split:false, minSize:30},
            west: {split: true, initialSize:440, minSize:0, collapsible:true, titlebar:true, title:'Suche', autoscroll:true, closeable:true},
            center: {minSize:0, collapsible:true, titlebar:true, closeable:true},
            south: {split: true, initialSize:500, minSize:0, collapsible:true, titlebar:true, title:'Details', autoscroll:true, collapsed:true}
        });
        detailContainer = new YAHOO.ext.ContentPanel('detail_container', {fitToFrame: true, title: hwlang.details});
        detailPanel = new YAHOO.ext.TabPanel('detail_tabs');
        layout.beginUpdate();
        layout.add('north', new YAHOO.ext.ContentPanel('menubar'), {fitToFrame: true});
        layout.add('west', new YAHOO.ext.ContentPanel('content', {fitToFrame: true, title: hwlang.suche}));
        layout.add('center', new YAHOO.ext.GridPanel(grid, {fitToFrame: true, title: hwlang.ergebnisse}));
        layout.add('south', detailContainer);
    }
    else {
        layout.beginUpdate();
    }
    dataModel.baseParams = get_field_values('search_form');
    dataModel.loadPage(1);
    layout.endUpdate();
},

add_new_tab: function(tab_label) {
    var tab = detailPanel.addTab("detail-" + this.seq, tab_label, "", closable=true);
    this.seq += 1;
    return tab;
},

setTitle: function(tab, this_id) {
    var title = getEl("hw" + this_id + "_id_name").dom.value;
    if (! title) {
        title = getEl("hw" + this_id + "_id_hardware_id").dom.value;
    }
    if (! title) {
        title = hwlang.hardware_no + this_id;
    }
    tab.setText(encode_entities(this.truncateTitle(title)));
},

truncateTitle: function(title) {
    if (title && title.length > 20) {
        title = title.substring(0,10) + "..." + title.substring(title.length-10, title.length);
    }
    return title;
},

showDetails: function(id, tab_label) {
    var tab = this.tabPanels[id];
    if (tab) {
        tab.activate();
        tab.getUpdateManager().refresh()
    }
    else {
        tab = this.add_new_tab(this.truncateTitle(tab_label));
        this.tabPanels[id] = tab;
        var updater = tab.getUpdateManager();
        updater.loadScripts = true;
        updater.setDefaultUrl(kundebunt_urls['hardware.hw_edit_panel_prefix'] + id + '/');
        var this_id = id;
        var onDetailUpdate = function() {
            var el = getEl("hw" + this_id + "_id_enthalten_in");
            if (el.dom.value != "") {
                el.on("dblclick", function() {
                    this.showDetails(
                        getEl("hw" + this_id + "_id_enthalten_in_id").dom.value,
                        getEl("hw" + this_id + "_id_enthalten_in_name").dom.value)
                    }, this, true);
            }
            getEl("hw" + id + "_id_submit").on("click", function() {
                    var formEl = getEl("hw" + id + "_form");
                    var url = formEl.dom.action;
                    var values = get_field_values("hw" + this_id + "_form");
                    updater.update(url, values);
                }, this, true);
            getEl("hw" + id + "_id_copy").on('click', function () {this.showCreatePanel(this_id)}, this, true);
            this.setTitle(tab, this_id);
/*            updater.removeListener("update", onDetailUpdate);*/
        };
        updater.on("update", onDetailUpdate, this, true);
        updater.on("failure", this.handle_load_failure);
        tab.on("close", function() {
            this.tabPanels[this_id] = null;
            }, this, true);
        updater.refresh();
        tab.activate();
    }
},

showCreatePanel: function(template_id) {
    var tab = this.tabPanels['new'];
    if (tab) {
        tab.activate();
    }
    else {
        tab = this.add_new_tab("+");
        this.tabPanels['new'] = tab;
        var updater = tab.getUpdateManager();
        var submit_path = kundebunt_urls['hardware.hw_create_panel']
        if (template_id) {
            updater.setDefaultUrl(kundebunt_urls['hardware.hw_copy_panel_prefix'] + template_id + '/');
        }
        else {
            updater.setDefaultUrl(submit_path);
        }
        updater.loadScripts = true;
        var this_id = "new";
        var onDetailUpdate = function(el2, response) {
            var path = response.getResponseHeader['X-Noris-Path'];
            if (path.substring(path.length-1, path.length) == '\x0d') {
                path = path.substring(0, path.length-1);
            }
            if ((path != updater.defaultUrl) && (path != submit_path)) {
                /* switching from creation to update mode */
                submit_path = path;
                updater.setDefaultUrl(path);
                this.tabPanels[this_id] = null;
                this_id = path.substring(path.lastIndexOf("/", path.length - 2) + 1, path.length - 1);
                this.tabPanels[this_id] = tab;
                this.setTitle(tab, this_id);
                getEl("hw" + this_id + "_id_copy").on('click', function () {this.showCreatePanel(this_id)}, this, true);
            }
            getEl("hw" + this_id + "_id_submit").on("click", function() {
                    var values = get_field_values("hw" + this_id + "_form");
                    updater.update(submit_path, values);
                    // updater.formUpdate(getEl(this_id + "_form").dom, submit_path) <-- geht nicht mit IE7
                }, this, true);
        };
        updater.on("update", onDetailUpdate, this, true);
        updater.on("failure", this.handle_load_failure);
        tab.on("close", function() {
            this.tabPanels[this_id] = null;
            }, this, true);
        updater.refresh();
        tab.activate();
    }
    layout.getRegion("south").expand();
},

showDetailsForRow: function(grid, rowIndex, event) {
    var row_id = dataModel.getRowId(rowIndex)
    if (row_id != null) {
        ResultGridLoader.showDetails(row_id, dataModel.getRow(rowIndex)[3]);
        layout.getRegion("south").expand();
    }
},

handle_form_keypress: function(key) {
    if (key.keyCode == 13) {
        this.showResults();
    }
},

showResultsDialog: function(){
    if (!dialog) {
        dialog = new YAHOO.ext.BasicDialog("results_dialog", {
            modal:true,
            autoTabs:true,
            width:800,
            height:700,
            shadow:true,
            minWidth:150,
            minHeight:300
        });
        dialog.addKeyListener(27, dialog.hide, dialog);
        dialog.addButton('Close', dialog.hide, dialog);
        dialog.addButton('Submit', dialog.hide, dialog).disable();
        }
    dataModel.baseParams = get_field_values('search_form');
    dataModel.loadPage(1);
    dialog.show(getEl('search_submit').dom);
},

handle_grid_load: function() {
    if (grid.getDataModel().getRowCount() == 0)
        grid.getDataModel().insertRow(0, ['', '', '', hwlang.keine_ergebnisse, '', '', '']);
},

handle_load_failure: function(obj, e, response) {
    if (! response && e && e.status) {
        /* triggered by of UpdateManager.failure */
        response = e
    }
    if (response) {
        if (response.status == 403) {
            location.href=kundebunt_urls['kunde_auth.forbidden'];
            return;
        }
        else if (response.status >= 500 && response.responseText) {
            document.write(response.responseText);
            return;
        }
    }
    location.href = location.href;
    return;
},

showWartung: function(hw_id, id, url_) {
    var tab = this.tabPanels[id];
    var url = url_
    if (tab) {
        tab.activate();
        tab.getUpdateManager().refresh()
    }
    else {
        tab = this.add_new_tab(this.truncateTitle("Vertrag " + id.slice(2)));
        this.tabPanels[id] = tab;
        var updater = tab.getUpdateManager();
        updater.loadScripts = true;
        updater.setDefaultUrl(url);
        var this_id = id;
        var onDetailUpdate = function() {
            getEl(this_id + "_id_submit").on("click", function() {
                    var formEl = getEl(this_id + "_form");
                    var values = get_field_values(this_id + "_form");
                    updater.update(url, values);
                }, this, true);
            var url_split = url.lastIndexOf("/", url.length - 2);
            var copyUrl = url.slice(0, url_split) + "/copy" + url.slice(url_split);
            getEl(this_id + "_id_copy").on('click', function () {this.showCreateWartung(hw_id, copyUrl);}, this, true);
//            this.setTitle(tab, this_id);
/*            updater.removeListener("update", onDetailUpdate);*/
        };
        updater.on("update", onDetailUpdate, this, true);
        updater.on("failure", this.handle_load_failure);
        tab.on("close", function() {
            this.tabPanels[this_id] = null;
            }, this, true);
        updater.refresh();
        tab.activate();
    }
},

showCreateWartung: function(hw_id, url) {
    var tab = this.tabPanels['wvnew' + hw_id];
    if (tab) {
        tab.activate();
    }
    else {
        tab = this.add_new_tab(hwlang.neuer_vertrag);
        this.tabPanels['wvnew' + hw_id] = tab;
        var updater = tab.getUpdateManager();
        updater.setDefaultUrl(url);
        updater.loadScripts = true;
        var this_id = "wvnew" + hw_id;
        var copyUrl = null;
        var onDetailUpdate = function(el2, response) {
            var path = response.getResponseHeader['X-Noris-Path'];
            if (path.substring(path.length-1, path.length) == '\x0d') {
                path = path.substring(0, path.length-1);
            }
            if (path != updater.defaultUrl) {
                /* switching from creation to update mode */
                updater.setDefaultUrl(path);
                this.tabPanels[this_id] = null;
                var path_split = path.lastIndexOf("/", path.length - 2);
                var pure_id = path.slice(path_split + 1, -1);
                copyUrl = path.slice(0, path_split) + "/copy/" + pure_id + "/";
                this_id = "wv" + pure_id;
                this.tabPanels[this_id] = tab;
                tab.setText(encode_entities(hwlang.vertrag + ' ' + pure_id));

            }
            if (copyUrl) {
                getEl(this_id + "_id_copy").on('click', function () {this.showCreateWartung(hw_id, copyUrl)}, this, true);
            }
            getEl(this_id + "_id_submit").on("click", function() {
                    var values = get_field_values(this_id + "_form");
                    updater.update(updater.defaultUrl, values);
                    // updater.formUpdate(getEl(this_id + "_form").dom, submit_path) <-- geht nicht mit IE7
                }, this, true);
        };
        updater.on("update", onDetailUpdate, this, true);
        updater.on("failure", this.handle_load_failure);
        tab.on("close", function() {
            this.tabPanels[this_id] = null;
            }, this, true);
        updater.refresh();
        tab.activate();
    }
    layout.getRegion("south").expand();
}
};

YAHOO.ext.EventManager.onDocumentReady(ResultGridLoader.init, ResultGridLoader, true);

// YAHOO.ext.EventManager.onDocumentReady(build_tabs);

