# kundebunt main settings

from ConfigParser import RawConfigParser


SITE_ID = 1

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# top level URLs
ROOT_URLCONF = 'kundebunt.urls'
MAILADMIN_ROOTURL= '/mailadmin'
AUTH_ROOTURL='/auth'
ICONS_ROOTURL='/icons'

TEST_URL_FILTER='^/(auth|mailadmin)/'

# installed submodules
INSTALLED_APPS = (
                  #'kundebunt.popkern',
                  #'kundebunt.kunde_auth',
                  #'kundebunt.mailadmin',
                  #'kundebunt.contrib.view_test',

                  'django.contrib.sessions',
                  'django.contrib.admin',
                  'django.contrib.contenttypes',
                  'django.contrib.auth',
                  'django.contrib.sites',

                  #'itscales.apps.perf',
)

# Local time zone for this installation. All choices can be found here:
# http://www.postgresql.org/docs/current/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
TIME_ZONE = 'CET'

# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'en'

LANGUAGES = (
    ('de', ('German')),
    ('en', ('English')),
)


# Make this unique, and don't share it with anybody.
SECRET_KEY = 'z^fqm18q7zf8b_x^exy$vh^15u5=z33n4#3h^u2rvnb$6mpr4('

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    #'kundebunt.contrib.virtual_app_directories.load_template_source',
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.core.template.loaders.eggs.load_template_source',
)

MIDDLEWARE_CLASSES = (
    #"kundebunt.contrib.middleware.csrf.CsrfMiddleware",
    #"kundebunt.contrib.view_test.middleware.TestGhostWriter",
    "django.middleware.common.CommonMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    #"django.middleware.locale.LocaleMiddleware",
    "kundebunt.kunde_auth.middleware.AuthenticationMiddleware",
    #"django.middleware.transaction.TransactionMiddleware",
    #"kundebunt.popkern.updatelog.UpdatelogMiddleware",
    #"kundebunt.popkern.navigation.NavigationMiddleware",
    #"itscales.apps.perf.middleware.Perf",
    "django.middleware.doc.XViewMiddleware",
)

TEMPLATE_CONTEXT_PROCESSORS = (
    "django.core.context_processors.auth",
    #"django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    #"kundebunt.kunde_auth.context_processors.person",
    #"kundebunt.popkern.navigation.navigation_context_processor",
    #"kundebunt.popkern.version_context_processor.processor",
)

#AUTHENTICATION_BACKENDS = ('kundebunt.kunde_auth.auth_backend.PersonAuthBackend',)

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates".
    # Always use forward slashes, even on Windows.
)

#CACHE_BACKEND = 'locmem:///'


INDEX_LIMIT=30

SESSION_COOKIE_AGE=4*3600  # 4 Stunden
SESSION_EXPIRE_AT_BROWSER_CLOSE=True
SESSION_COOKIE_DOMAIN='.noris.net'
SESSION_COOKIE_SECURE=True

SERVER_EMAIL = 'mir+django@noris.de'
SEND_BROKEN_LINK_EMAILS = False

###########################################################
# get settings from installation settings file

config = RawConfigParser()
config.read('/etc/kundebunt/settings.ini')

#DATABASE_USER = config.get('database', 'DATABASE_USER')
#DATABASE_PASSWORD = config.get('database', 'DATABASE_PASSWORD')
#DATABASE_HOST = config.get('database', 'DATABASE_HOST')
#DATABASE_PORT = config.get('database', 'DATABASE_PORT')
#DATABASE_ENGINE = config.get('database', 'DATABASE_ENGINE')
#DATABASE_NAME = config.get('database', 'DATABASE_NAME')
#TEST_DATABASE_NAME = 'django_test_db'

DATABASE_USER = 'django'
DATABASE_PASSWORD = ''
DATABASE_HOST = ''
DATABASE_PORT = ''
DATABASE_ENGINE = 'postgresql'
DATABASE_NAME = 'django_test'
TEST_DATABASE_NAME = 'django_test'

SECRET_KEY = config.get('secrets','SECRET_KEY')
CSRF_MIDDLEWARE_SECRET = config.get('secrets', 'CSRF_MIDDLEWARE_SECRET')

SESSION_COOKIE_DOMAIN = config.get('cookies','SESSION_COOKIE_DOMAIN')
SESSION_COOKIE_SECURE = config.getboolean('cookies','SESSION_COOKIE_SECURE')

DEBUG = config.getboolean('debug','DEBUG')
TEMPLATE_DEBUG = config.getboolean('debug','TEMPLATE_DEBUG')
VIEW_TEST = config.getboolean('debug', 'VIEW_TEST')
INTERNAL_IPS = tuple(config.get('debug', 'INTERNAL_IPS').split())
if config.getboolean('debug', 'SKIP_CSRF_MIDDLEWARE'):
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('CsrfMiddleware')])
if not config.getboolean('debug', 'USE_TEST_GHOST_WRITER_MIDDLEWARE'):
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('TestGhostWriter')])
USE_PERFMON = config.getboolean('debug','USE_PERFMON')
if not USE_PERFMON:
    MIDDLEWARE_CLASSES = tuple([x for x in list(MIDDLEWARE_CLASSES)
                                  if not x.endswith('.Perf')])
    INSTALLED_APPS = tuple([x for x in list(INSTALLED_APPS)
                                  if not x.endswith('.perf')])


SERVER_EMAIL = config.get('email', 'SERVER_EMAIL')
EMAIL_HOST = config.get('email', 'EMAIL_HOST')
ADMINS = ()
MANAGERS = ()


###########################################################
# configure logging
# currently only used for TestGhostWriter

import logging.config
try:
    logging.config.fileConfig('/etc/kundebunt/logging.conf')
except:
    print "cannot read logging.conf, falling back to default logging configuration."
