"""
Wrapper for loading templates from "template" directories in installed app packages.
Different from the django provided app_directories, it creates a different template
namespace for each application. To use the template in your_app/templates/foo.html,
you specify 'your_app/foo'. Only the last app label is used as the namespace.

Mostly shamelessly copied from django's app_directories template loader.
"""

from django.conf import settings
from django.core.exceptions import ImproperlyConfigured
from django.template import TemplateDoesNotExist
from django.utils.datastructures import MultiValueDict
import os

# At compile time, cache the directories to search.
app_template_dirs = MultiValueDict()
for app in settings.INSTALLED_APPS:
    i = app.rfind('.')
    if i == -1:
        m, a = app, None
    else:
        m, a = app[:i], app[i+1:]
    try:
        if a is None:
            mod = __import__(m, '', '', [])
            label = m
        else:
            mod = getattr(__import__(m, '', '', [a]), a)
            label = a
    except ImportError, e:
        raise ImproperlyConfigured, 'ImportError %s: %s' % (app, e.args[0])
    template_dir = os.path.join(os.path.dirname(mod.__file__), 'templates')
    if os.path.isdir(template_dir):
        app_template_dirs.appendlist(label, template_dir)

def get_template_sources(template_name, template_dirs=None):
    # find top level directory component of template_name
    path = []
    head = template_name
    while True:
        head,tail=os.path.split(head)
        if not tail:
            break
        path.insert(0,tail)
    if len(path)<=1:
        return
    template_name = os.path.join(*path[1:])
    for template_dir in app_template_dirs.getlist(path[0]):
        yield os.path.join(template_dir, template_name)

def load_template_source(template_name, template_dirs=None):
    for filepath in get_template_sources(template_name, template_dirs):
        try:
            return (open(filepath).read(), filepath)
        except IOError:
            print "Not found: %s" % filepath
    raise TemplateDoesNotExist, template_name
load_template_source.is_usable = True
