from django import oldforms
from django.core import validators

class AdvisoryFieldMixin(object):
    def __init__(self):
        self.advisors = []

    def create_advisors(self):
        try:
            self.advisors
        except AttributeError:
            self.advisors=[]

    def add_advisors(self, advisors):
        self.create_advisors()
        self.advisors.extend(advisors)
        return self

    def prepare_advisories(self, all_data):
        self.create_advisors()
        advisors = [adv for adv in self.advisors if hasattr(adv, 'prepare')]
        if advisors:
            try:
                field_data = all_data.get(self.member_name, '')
            except AttributeError:
                field_data = all_data.get(self.field_name, '')
            if field_data:
                for adv in advisors:
                    adv.prepare(field_data, all_data)

    def get_advisories(self, all_data):
        self.create_advisors()
        advisories = []
        try:
            field_data = all_data.get(self.member_name, '')
        except AttributeError:
            field_data = all_data.get(self.field_name, '')
        if field_data:
            for fn in self.advisors:
                try:
                    fn(field_data, all_data)
                except validators.ValidationError, err:
                    advisories.extend(err.messages)
        if advisories:
            return [(self.field_name, advisories)]
        else:
            return []

class FormField(oldforms.FormField, AdvisoryFieldMixin):
    def __init__(self):
        AdvisoryFieldMixin.__init__(self)

