"""Integrate doctests into the py.test framework"""

# mostly from http://codespeak.net/pipermail/py-dev/2005-June/000420.html


import py
import doctest


class Directory(py.test.collect.Directory):

    def buildname2items(self):
        # just let our base class do its building
        d = super(Directory, self).buildname2items()

        # let's look for doctests ...
        for fn in self.fspath.listdir('*.py'):
            if fn.basename in d or fn.basename == 'conftest.py':
                continue
            # we have a candidate for doctests, check if it contains doctests at all ...
            try:
                f = open(str(fn),"r")
                for line in f:
                    if ">>>" in line:
                        break
                else:
                    continue
            finally:
                    f.close()
            module = DoctestModule(fn, parent=self)
            d[fn.basename] = module
        return d

    def recfilter(self, path):
        return super(Directory,self).recfilter(path) and path.basename not in ("autogen-models", "debugutils", "fixtures")


class DoctestModule(py.test.collect.Module):
    def funcnamefilter(self, name):
        return True
    def classnamefilter(self, name):
        return True
    def buildname2items(self):
        d = {}
        finder = doctest.DocTestFinder()
        doctests = finder.find(self.obj)
        for test in doctests:
            if test.examples:
                tester = doctest.Tester(mod=self.obj, verbose=0)
                d[test.name] = DoctestItem(test.name, test.docstring, tester, self)
        return d


class DoctestItem(py.test.Item):

    def __init__(self, name, test, tester, parent):
        py.test.Item.__init__(self, name, parent)
        self.test = test
        self.tester = tester

    def run(self):
        from django.utils.translation import gettext
        failed, tried = self.tester.runstring(self.test, self.name)
    	__builtins__['_'] = gettext
        if failed:
            raise self.Failed('ooops')

