from django.conf.urls.defaults import *

PARTS = dict(
            hash=r'(?P<hash>[1-9]\d*)',
            seq=r'(?P<seq>[1-9]\d*)',
            ticket_nr=r'(?P<ticket_nr>[1-9]\d*)',
            kunden_name=r'(?P<kunden_name>[^/]+)',
            person_id=r'(?P<person_id>[1-9]\d*)',
)

urlpatterns = patterns('kundebunt.acct.views',
    (r'^edit-acct/%(hash)s-%(seq)s/$' % PARTS,
            'edit_acct'),
    url(r'^ticket/%(ticket_nr)s/add-acct/%(kunden_name)s/$' % PARTS,
            'add_acct'),
    url(r'^ticket/%(ticket_nr)s/add-acct/$' % PARTS,
            'add_acct', name='add-acct-without-customer'),
    (r'^delete-acct/%(hash)s-%(seq)s/$' % PARTS,
            'delete_acct'),
)
