# -*- encoding: UTF-8 -*-

from datetime import date
from django.conf import settings
from django.utils.translation import ugettext as _

from kundebunt import newforms
from kundebunt.popkern import models

def monatsanfang():
    monatsanfang = date.today()
    monatsanfang = date(monatsanfang.year, monatsanfang.month, 1)
    return monatsanfang

def _zeit_choices(anzahl):
    return [(i*15*60, '%01d:%02d' % (i/4, (i%4) * 15))
            for i in range(1,anzahl+1)
           ]

def _dienst_choices():
    return [(dienst.id, dienst.info)
            for dienst in (
                models.Dienst.objects.get(name=dienst_name)
                for dienst_name in settings.BILLING_DIENSTE)
           ]

class AcctForm(newforms.Form):
    kunde = newforms.CharField(
        label=_(u'Kunde'),
        max_length=32,
        widget=newforms.TextInput(attrs={'class': 'vReadonlyTextField', 'readonly':'readonly'}))
    datum = newforms.DateField(label=_(u'Buchungsdatum'))
    arbeitszeit = newforms.ChoiceField(
        label=_(u'Arbeitszeit'),
        choices=_zeit_choices(39))
    dienst = newforms.ChoiceField(
        label = _(u'Dienst'),
        choices = _dienst_choices())
    text = newforms.CharField(
        label = _(u'Rechnungstext'),
        widget = newforms.Textarea(attrs={'cols':35, 'style': 'width:inherit'}),
        max_length = 65535,
        )

    def clean_datum(self):
        data = self.cleaned_data['datum']
        _monatsanfang = monatsanfang()
        if data < _monatsanfang:
            raise newforms.ValidationError(
                _(u'Das Buchungsdatum darf nicht vor dem Monatsersten liegen.'))
        else:
            return data

    def clean_text(self):
        data = self.cleaned_data['text']
        if u'|' in data:
            raise newforms.ValidationError(
                _(u'Aus technischen Gründen darf das Zeichen "|" hier nicht verwendet werden.'))
        else:
            return data

    def clean_arbeitszeit(self):
        data = self.cleaned_data['arbeitszeit']
        try:
            return int(data)
        except ValueError:
            raise newforms.ValidationError(_(u'Der Wert muß numerisch sein'))

    def clean_dienst(self):
        data = self.cleaned_data['dienst']
        try:
            return int(data)
        except ValueError:
            raise newforms.ValidationError(_(u'Der Wert muß numerisch sein'))

