# -*- encoding: utf-8 -*-

"""
Ein paar Hilfsroutinen zur Datenbank
"""
from django.db.backends.util import dictfetchall
from kundebunt.popkern.models import *

def db_open(db="pop", host="dev"):
    import MySQLdb
    return MySQLdb.connect(host=host, db=db)


def db_read_descr(db, typname):
    """
    Liest alle Einträge zum angegebenen Descr-Typ ein.

    Parameter:
        db: database connection
        typname: string, der einzulesende Typ

    Rückgabe:
        ( type_dict, descr_dict_list )
        mit:
            type_dict: { fieldname: value }
            descr_dict_list: [ { fieldname: value } ]
    """
    cursor = db.cursor()
    cursor.execute(
        """select * from descr_typ where name=%s""",
        [typname])

    typ=dictfetchall(cursor)[0]

    cursor.execute(
        """select descr, bla, gruppe, infotext from descr where typ=%s""",
        [typ["id"]])
    descr = dictfetchall(cursor)
    return (typ,descr)


def db_write_descr(type_dict, descr_dict_list):
    """
    Erzeugt die Deskriptoren in der Datenbank, die durch settings vorgeben ist.
    Rückgabe:
       ( DescrTyp, [ Descr ] )
    """
    descrTyp = DescrTyp(**type_dict)
    descrTyp.id = None
    descrTyp.save()

    descr_list = []
    for x in descr_dict_list:
        x = dict(x)
        x["name"] = x["info"] = 1    # Leider kann man hier zur Zeit kein Null eintragen.
        x["id"] = None
        x["typ"] = descrTyp.id
        descr = Descr.AddManipulator().save(x)
        descr_list.append(descr)

    return (descrTyp, descr_list)
